/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.sms;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.pagehelper.Page;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.db.utils.PageHelperUtils;
import com.icetech.park.dao.sms.SmsAlarmTemplateDao;
import com.icetech.park.domain.dto.sms.SmsAlarmTemplateDto;
import com.icetech.park.domain.entity.sms.SmsAlarmOrder;
import com.icetech.park.domain.entity.sms.SmsAlarmTemplate;
import com.icetech.park.domain.request.sms.SmsAlarmTemplateParam;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsAlarmTemplateService
extends BaseServiceImpl<SmsAlarmTemplateDao, SmsAlarmTemplate> {
    private static final Logger log = LoggerFactory.getLogger(SmsAlarmTemplateService.class);

    public Map<Integer, SmsAlarmTemplate> defMap() {
        return this.defList().stream().collect(Collectors.toMap(SmsAlarmTemplate::getType, Function.identity()));
    }

    public List<SmsAlarmTemplate> defList() {
        return this.getListByPark(0L);
    }

    public List<SmsAlarmTemplate> getListByPark(Long parkId) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SmsAlarmTemplate::getParkId, (Object)parkId)).list();
    }

    public SmsAlarmTemplate getDefByType(int type) {
        return this.getByType(0L, type);
    }

    public SmsAlarmTemplate getByType(long parkId, int type) {
        return (SmsAlarmTemplate)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SmsAlarmTemplate::getParkId, (Object)parkId)).eq(SmsAlarmTemplate::getType, (Object)type)).one();
    }

    public PageResult<SmsAlarmTemplateDto> pageDto(SmsAlarmTemplateParam param) {
        Page page = PageHelperUtils.page((int)param.getPageIndex(), (int)param.getPageSize(), () -> ((SmsAlarmTemplateDao)this.getBaseMapper()).getDtoList(param));
        return PageResult.fromPages((Page)page);
    }

    @Transactional
    public boolean initTemplate(SmsAlarmOrder order) {
        List<SmsAlarmTemplate> templates = this.defList();
        for (SmsAlarmTemplate template : templates) {
            template.setId(null).setParkId(order.getParkId()).setName("0").setContent("0").setTemplateCode(template.getTemplateCode()).setCreateTime(LocalDateTime.now()).setUpdateTime(LocalDateTime.now()).setUpdateUser(order.getCreateUser());
        }
        return this.saveBatch(templates);
    }
}

