/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.sms;

import com.icetech.park.dao.sms.SmsAlarmRuleDeviceDao;
import com.icetech.park.domain.entity.sms.SmsAlarmRuleDevice;
import com.icetech.park.domain.entity.sms.SmsAlarmRulePncCenter;
import com.icetech.park.domain.entity.sms.SmsAlarmRulePncCharge;
import com.icetech.park.service.sms.SmsAlarmRuleBaseOfflineService;
import com.icetech.park.service.sms.SmsAlarmRulePncCenterService;
import com.icetech.park.service.sms.SmsAlarmRulePncChargeService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsAlarmRuleDeviceService
extends SmsAlarmRuleBaseOfflineService<SmsAlarmRuleDeviceDao, SmsAlarmRuleDevice> {
    private static final Logger log = LoggerFactory.getLogger(SmsAlarmRuleDeviceService.class);
    @Resource
    private SmsAlarmRulePncCenterService smsAlarmRulePncCenterService;
    @Resource
    private SmsAlarmRulePncChargeService smsAlarmRulePncChargeService;

    @Override
    @Transactional
    public boolean saveOrUpdateByParkId(SmsAlarmRuleDevice param) {
        param.setId(null);
        boolean result = super.saveOrUpdateByParkId(param);
        if (result && param.getId() != null) {
            SmsAlarmRulePncCharge existsCharge;
            SmsAlarmRulePncCenter existsCenter = (SmsAlarmRulePncCenter)this.smsAlarmRulePncCenterService.getByParkId(param.getParkId());
            if (existsCenter == null) {
                SmsAlarmRulePncCenter center = new SmsAlarmRulePncCenter();
                BeanUtils.copyProperties((Object)param, (Object)center);
                result = this.smsAlarmRulePncCenterService.saveWithCreate(center);
            }
            if ((existsCharge = (SmsAlarmRulePncCharge)this.smsAlarmRulePncChargeService.getByParkId(param.getParkId())) == null) {
                SmsAlarmRulePncCharge charge = new SmsAlarmRulePncCharge();
                BeanUtils.copyProperties((Object)param, (Object)charge);
                result = this.smsAlarmRulePncChargeService.saveWithCreate(charge);
            }
        }
        return result;
    }
}

