/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.sms;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.pagehelper.Page;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.db.utils.PageHelperUtils;
import com.icetech.park.dao.sms.SmsAlarmOrderDao;
import com.icetech.park.domain.dto.sms.SmsAlarmOrderDto;
import com.icetech.park.domain.entity.sms.SmsAlarmOrder;
import com.icetech.park.domain.request.sms.SmsAlarmOrderParam;
import com.icetech.park.service.sms.SmsAlarmConfigService;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsAlarmOrderService
extends BaseServiceImpl<SmsAlarmOrderDao, SmsAlarmOrder> {
    private static final Logger log = LoggerFactory.getLogger(SmsAlarmOrderService.class);
    public static final String PAYMENT_KEY = "sms_alarm:payment:";
    @Resource
    private SmsAlarmConfigService smsAlarmConfigService;

    public PageResult<SmsAlarmOrderDto> pageDto(SmsAlarmOrderParam param) {
        Page page = PageHelperUtils.page((int)param.getPageIndex(), (int)param.getPageSize(), () -> ((SmsAlarmOrderDao)this.getBaseMapper()).getDtoList(param));
        return PageResult.fromPages((Page)page);
    }

    public SmsAlarmOrder sumSmsCountAndAmount(SmsAlarmOrderParam param) {
        return ((SmsAlarmOrderDao)this.getBaseMapper()).sumSmsCountAndAmount(param);
    }

    public SmsAlarmOrder getByOrderNum(String orderNum) {
        return (SmsAlarmOrder)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SmsAlarmOrder::getOrderNum, (Object)orderNum)).one();
    }

    @Transactional
    public void paid(SmsAlarmOrder order) {
        SmsAlarmOrder exists = this.getByOrderNum(order.getOrderNum());
        if (exists != null) {
            log.warn("\u77ed\u4fe1\u670d\u52a1\u8d2d\u4e70\u901a\u77e5|\u5ffd\u7565\u91cd\u590d\u901a\u77e5|{}", (Object)order);
            return;
        }
        order.setId(null).setPayChannel(Integer.valueOf(1)).setCreateTime(LocalDateTime.now());
        this.save(order);
        this.smsAlarmConfigService.saveOrUpdate(order);
    }
}

