/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.sms;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.github.pagehelper.Page;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.db.utils.PageHelperUtils;
import com.icetech.park.dao.sms.SmsAlarmConfigDao;
import com.icetech.park.domain.constant.sms.SmsAlarmOperRecordConsts;
import com.icetech.park.domain.dto.sms.SmsAlarmConfigDto;
import com.icetech.park.domain.entity.sms.SmsAlarmConfig;
import com.icetech.park.domain.entity.sms.SmsAlarmOperRecord;
import com.icetech.park.domain.entity.sms.SmsAlarmOrder;
import com.icetech.park.domain.request.sms.SmsAlarmConfigParam;
import com.icetech.park.service.sms.SmsAlarmOperRecordService;
import com.icetech.park.service.sms.SmsAlarmTemplateService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsAlarmConfigService
extends BaseServiceImpl<SmsAlarmConfigDao, SmsAlarmConfig> {
    private static final Logger log = LoggerFactory.getLogger(SmsAlarmConfigService.class);
    public static final String LOCK_KEY = "lock:sms_alarm:park:";
    @Resource
    private SmsAlarmTemplateService smsAlarmTemplateService;
    @Resource
    private SmsAlarmOperRecordService smsAlarmOperRecordService;
    @Resource
    private ParkService parkService;
    @Resource
    private RedissonClient redissonClient;

    public PageResult<SmsAlarmConfigDto> pageDto(SmsAlarmConfigParam param) {
        Page page = PageHelperUtils.page((int)param.getPageIndex(), (int)param.getPageSize(), () -> ((SmsAlarmConfigDao)this.getBaseMapper()).getDtoList(param));
        return PageResult.fromPages((Page)page);
    }

    public SmsAlarmConfig getByParkId(Long parkId) {
        return (SmsAlarmConfig)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SmsAlarmConfig::getParkId, (Object)parkId)).one();
    }

    public SmsAlarmConfigDto getDtoByParkId(Long parkId) {
        return ((SmsAlarmConfigDao)this.getBaseMapper()).getDtoByParkId(parkId);
    }

    public boolean saveOrUpdate(SmsAlarmOrder order) {
        String lockKey = LOCK_KEY + order.getParkId();
        RLock lock = this.redissonClient.getLock(lockKey);
        try {
            lock.tryLock(30L, 30L, TimeUnit.SECONDS);
            SmsAlarmConfig exists = this.getByParkId(order.getParkId());
            if (exists == null) {
                SmsAlarmConfig config = new SmsAlarmConfig().setParkId(order.getParkId()).setTotalCount(order.getSmsCount()).setCurrCount(order.getSmsCount());
                boolean result = this.save(config);
                this.smsAlarmTemplateService.initTemplate(order);
                boolean bl = result;
                return bl;
            }
            boolean bl = this.changeCount(exists.getParkId(), order.getSmsCount());
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            lock.unlock();
        }
    }

    @Transactional
    public boolean updateEnableFlagByParkId(SmsAlarmConfigParam config) {
        SmsAlarmConfig old = this.getByParkId(config.getParkId());
        if (old == null) {
            throw new ResponseBodyException("404", "\u8f66\u573a\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (config.getDeviceEnableFlag() != null) {
            ObjectResponse parkConfigResp = this.parkService.getParkConfig(config.getParkId());
            ObjectResponse.notError((Response)parkConfigResp);
            ParkConfig parkConfig = (ParkConfig)parkConfigResp.getData();
            if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(parkConfig.getDataCollection())) {
                config.setPncCenterEnableFlag(config.getDeviceEnableFlag()).setPncChargeEnableFlag(config.getDeviceEnableFlag());
            } else {
                config.setPncCenterEnableFlag(null).setPncChargeEnableFlag(null);
            }
        }
        ArrayList<SmsAlarmOperRecord> records = new ArrayList<SmsAlarmOperRecord>(5);
        SmsAlarmConfig updated = new SmsAlarmConfig().setId(old.getId());
        if (config.getDeviceEnableFlag() != null && !config.getDeviceEnableFlag().equals(old.getDeviceEnableFlag())) {
            updated.setDeviceEnableFlag(config.getDeviceEnableFlag());
            records.add(new SmsAlarmOperRecord().setParkId(config.getParkId()).setModuleType(SmsAlarmOperRecordConsts.MODULE_TYPE_DEVICE).setOperType(SmsAlarmOperRecordConsts.OPER_TYPE_STATUS).setOperVal(config.getDeviceEnableFlag()).setOperTime(LocalDateTime.now()).setOperUser(config.getUpdateUser()));
        }
        if (config.getMonthEnableFlag() != null && !config.getMonthEnableFlag().equals(old.getMonthEnableFlag())) {
            updated.setMonthEnableFlag(config.getMonthEnableFlag());
            records.add(new SmsAlarmOperRecord().setParkId(config.getParkId()).setModuleType(SmsAlarmOperRecordConsts.MODULE_TYPE_MONTH).setOperType(SmsAlarmOperRecordConsts.OPER_TYPE_STATUS).setOperVal(config.getMonthEnableFlag()).setOperTime(LocalDateTime.now()).setOperUser(config.getUpdateUser()));
        }
        if (config.getVipEnableFlag() != null && !config.getVipEnableFlag().equals(old.getVipEnableFlag())) {
            updated.setVipEnableFlag(config.getVipEnableFlag());
            records.add(new SmsAlarmOperRecord().setParkId(config.getParkId()).setModuleType(SmsAlarmOperRecordConsts.MODULE_TYPE_VIP).setOperType(SmsAlarmOperRecordConsts.OPER_TYPE_STATUS).setOperVal(config.getVipEnableFlag()).setOperTime(LocalDateTime.now()).setOperUser(config.getUpdateUser()));
        }
        if (config.getPncCenterEnableFlag() != null && !config.getPncCenterEnableFlag().equals(old.getPncCenterEnableFlag())) {
            updated.setPncCenterEnableFlag(config.getPncCenterEnableFlag());
            records.add(new SmsAlarmOperRecord().setParkId(config.getParkId()).setModuleType(SmsAlarmOperRecordConsts.MODULE_TYPE_PNC_CENTER).setOperType(SmsAlarmOperRecordConsts.OPER_TYPE_STATUS).setOperVal(config.getPncCenterEnableFlag()).setOperTime(LocalDateTime.now()).setOperUser(config.getUpdateUser()));
        }
        if (config.getPncChargeEnableFlag() != null && !config.getPncChargeEnableFlag().equals(old.getPncChargeEnableFlag())) {
            updated.setPncChargeEnableFlag(config.getPncChargeEnableFlag());
            records.add(new SmsAlarmOperRecord().setParkId(config.getParkId()).setModuleType(SmsAlarmOperRecordConsts.MODULE_TYPE_PNC_CHARGE).setOperType(SmsAlarmOperRecordConsts.OPER_TYPE_STATUS).setOperVal(config.getPncChargeEnableFlag()).setOperTime(LocalDateTime.now()).setOperUser(config.getUpdateUser()));
        }
        if (records.isEmpty()) {
            return true;
        }
        boolean result = this.updateById(updated);
        this.smsAlarmOperRecordService.saveBatch(records);
        return result;
    }

    public boolean changeCount(long parkId, int count) {
        return ((SmsAlarmConfigDao)this.getBaseMapper()).changeCount(parkId, count) > 0;
    }
}

