/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.shanghai.impl;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.cloudcenter.api.third.ShService;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.anno.DS_SLAVE;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShangHaiServiceImpl
implements ShService {
    private static final Logger log = LoggerFactory.getLogger(ShangHaiServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;

    @DS_SLAVE
    @SentinelResource(value="ShangHaiService.getEnterReRecords", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public Integer getEnterReRecords(Park park) {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date dayStart = calendar.getTime();
        long starttime = dayStart.getTime() / 1000L;
        long endtime = new Date().getTime() / 1000L;
        return this.orderInfoDao.countEnterRecords(String.valueOf(park.getId()), Long.valueOf(starttime), Long.valueOf(endtime), null, null, null);
    }

    @DS_SLAVE
    @SentinelResource(value="ShangHaiService.getExitReRecords", defaultFallback="defaultFallbackHandle", fallbackClass={ExceptionUtils.class})
    public Integer getExitReRecords(Park park) {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date dayStart = calendar.getTime();
        long starttime = dayStart.getTime() / 1000L;
        long endtime = new Date().getTime() / 1000L;
        return this.orderInfoDao.countExitRecords(String.valueOf(park.getId()), Long.valueOf(starttime), Long.valueOf(endtime), null, null, null, null, null);
    }
}

