/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.config.GrayProperties;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateUtils;
import com.icetech.park.domain.entity.lcd.LcdBrightness;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.lcd.LcdShow;
import com.icetech.park.domain.entity.lcd.LcdSound;
import com.icetech.park.domain.entity.lcd.LcdSoundcode;
import com.icetech.park.domain.entity.lcd.LcdTips;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.lcd.LcdBrightnessServiceImpl;
import com.icetech.park.service.lcd.LcdConfigServiceImpl;
import com.icetech.park.service.lcd.LcdShowServiceImpl;
import com.icetech.park.service.lcd.LcdSoundServiceImpl;
import com.icetech.park.service.lcd.LcdSoundcodeServiceImpl;
import com.icetech.park.service.lcd.LcdTipsServiceImpl;
import com.icetech.park.service.ledsound.LedConfigServiceImpl;
import com.icetech.park.service.ledsound.LedShowServiceImpl;
import com.icetech.park.service.ledsound.LedSoundServiceImpl;
import com.icetech.park.service.ledsound.LedTipsServiceImpl;
import com.icetech.park.service.park.impl.ParkGuideServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.SendInfoServiceImpl;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.transaction.annotation.Transactional;

public class VoiceScreenUpServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(VoiceScreenUpServiceImpl.class);
    @Autowired
    private LedConfigServiceImpl ledSoundConfigService;
    @Autowired
    private LedShowServiceImpl ledService;
    @Autowired
    private LedSoundServiceImpl soundService;
    @Autowired
    private LedTipsServiceImpl specialLedService;
    @Autowired
    private LcdConfigServiceImpl lcdConfigService;
    @Autowired
    private LcdBrightnessServiceImpl lcdBrightnessService;
    @Autowired
    private LcdShowServiceImpl lcdShowService;
    @Autowired
    private LcdTipsServiceImpl lcdTipsService;
    @Autowired
    private LcdSoundcodeServiceImpl lcdSoundcodeService;
    @Autowired
    private LcdSoundServiceImpl lcdSoundService;
    @Autowired
    private ParkGuideServiceImpl parkGuideService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private GrayProperties grayProperties;

    @Override
    @Transactional
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) throws Exception {
        if (baseRequest.getBizContent() == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        VoiceScreenUpRequest request = (VoiceScreenUpRequest)JSON.parseObject((String)JSON.toJSONString((Object)baseRequest.getBizContent()), VoiceScreenUpRequest.class);
        if (request == null || request.getType() == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        if (request.getType() != 1 && request.getType() != 2) {
            throw new ResponseBodyException("400", "\u672a\u77e5\u7c7b\u578b: " + request.getType());
        }
        return null;
    }

    private ObjectResponse<Boolean> handleLed(long parkId, VoiceScreenUpRequest.LedDetailInfo info) {
        LedConfig config = this.buildLedSoundConfig(parkId, info);
        if (CollectionUtils.isEmpty((Collection)info.getLedConfig())) {
            return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11LED\u5c4f\u663e\u914d\u7f6e");
        }
        if (CollectionUtils.isEmpty((Collection)info.getSoundConfig())) {
            return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11LED\u8bed\u97f3\u914d\u7f6e");
        }
        if (CollectionUtils.isEmpty((Collection)info.getLedSpecial())) {
            return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11LED\u5c4f\u663e\u7279\u6b8a\u914d\u7f6e");
        }
        List ledShowConfigs = info.getLedConfig().stream().map(ledConfigInfo -> this.buildLedConfig(parkId, (VoiceScreenUpRequest.LedConfigInfo)ledConfigInfo)).collect(Collectors.toList());
        List ledLedSounds = info.getSoundConfig().stream().map(ledSoundConfigInfo -> this.buildLedSound(parkId, (VoiceScreenUpRequest.LedSoundConfigInfo)ledSoundConfigInfo)).collect(Collectors.toList());
        List ledSpecials = info.getLedSpecial().stream().map(ledSpecialInfo -> this.buildLedSpecial(parkId, (VoiceScreenUpRequest.LedSpecialInfo)ledSpecialInfo)).collect(Collectors.toList());
        this.ledSoundConfigService.remove((Wrapper)Wrappers.lambdaQuery(LedConfig.class).eq(LedConfig::getParkId, (Object)parkId));
        this.ledService.remove((Wrapper)Wrappers.lambdaQuery(LedShow.class).eq(LedShow::getParkId, (Object)parkId));
        this.soundService.remove((Wrapper)Wrappers.lambdaQuery(LedSound.class).eq(LedSound::getParkId, (Object)parkId));
        this.specialLedService.remove((Wrapper)Wrappers.lambdaQuery(LedTips.class).eq(LedTips::getParkId, (Object)parkId));
        this.ledSoundConfigService.save(config);
        this.ledService.saveBatch(ledShowConfigs);
        this.soundService.saveBatch(ledLedSounds);
        this.specialLedService.saveBatch(ledSpecials);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(Long.valueOf(parkId));
        guide.setStep5(Integer.valueOf(1));
        this.parkGuideService.updateByParkId(guide);
        this.sendInfoService.save((Object)SendInfo.buildUnneeded((Long)parkId, (Long)parkId, (Integer)DownServiceEnum.LED\u8bed\u97f3\u5c4f\u663e.getServiceType(), (String)"\u672c\u5730\u4e0a\u62a5"));
        LinkedList<String> deleteKeys = new LinkedList<String>();
        deleteKeys.add("led:config:park:" + parkId);
        deleteKeys.add("led:show:park:" + parkId);
        deleteKeys.add("led:sound:park:" + parkId);
        deleteKeys.add("led:tips:park:" + parkId);
        if (this.grayProperties.isCacheEnable()) {
            deleteKeys.add("gray:led:config:park:" + parkId);
            deleteKeys.add("gray:led:show:park:" + parkId);
            deleteKeys.add("gray:led:sound:park:" + parkId);
            deleteKeys.add("gray:led:tips:park:" + parkId);
        }
        this.stringRedisTemplate.delete(deleteKeys);
        return ObjectResponse.success();
    }

    private ObjectResponse<Boolean> handleLcd(long parkId, long channelId, VoiceScreenUpRequest.LcdDetailInfo info) {
        if (CollectionUtils.isEmpty((Collection)info.getLcdBrightness())) {
            return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11LCD\u5c4f\u663e\u4eae\u5ea6\u914d\u7f6e");
        }
        if (CollectionUtils.isEmpty((Collection)info.getLcdShow())) {
            return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11LCD\u5c4f\u663e\u6bcf\u884c\u914d\u7f6e");
        }
        if (CollectionUtils.isEmpty((Collection)info.getLcdTips())) {
            return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11LCD\u8fdb\u51fa\u573a\u63d0\u793a\u914d\u7f6e");
        }
        if (CollectionUtils.isEmpty((Collection)info.getLcdSound())) {
            return ObjectResponse.failed((String)"400", (String)"\u7f3a\u5c11LCD\u8bed\u97f3\u914d\u7f6e");
        }
        LcdConfig lcdConfig = this.buildLcdConfig(parkId, info);
        List lcdShows = info.getLcdShow().stream().map(lcdShowInfo -> this.buildLcdShow(parkId, (VoiceScreenUpRequest.LcdShowInfo)lcdShowInfo)).collect(Collectors.toList());
        List lcdTipses = info.getLcdTips().stream().map(lcdTipsInfo -> this.buildLcdTips(parkId, (VoiceScreenUpRequest.LcdTipsInfo)lcdTipsInfo)).collect(Collectors.toList());
        List lcdSounds = info.getLcdSound().stream().map(lcdSoundInfo -> this.buildLcdSound(parkId, (VoiceScreenUpRequest.LcdSoundInfo)lcdSoundInfo)).collect(Collectors.toList());
        List existsLcdConfigs = this.lcdConfigService.list((Wrapper)Wrappers.lambdaQuery(LcdConfig.class).eq(LcdConfig::getParkId, (Object)parkId));
        if (!existsLcdConfigs.isEmpty()) {
            this.lcdConfigService.remove((Wrapper)Wrappers.lambdaQuery(LcdConfig.class).eq(LcdConfig::getParkId, (Object)parkId));
            this.lcdBrightnessService.remove((Wrapper)Wrappers.lambdaQuery(LcdBrightness.class).in(LcdBrightness::getLcdId, (Collection)existsLcdConfigs.stream().map(LcdConfig::getId).collect(Collectors.toList())));
        }
        this.lcdShowService.remove((Wrapper)Wrappers.lambdaQuery(LcdShow.class).eq(LcdShow::getParkId, (Object)parkId));
        this.lcdTipsService.remove((Wrapper)Wrappers.lambdaQuery(LcdTips.class).eq(LcdTips::getParkId, (Object)parkId));
        this.lcdSoundService.remove((Wrapper)Wrappers.lambdaQuery(LcdSound.class).eq(LcdSound::getParkId, (Object)parkId));
        this.lcdConfigService.save(lcdConfig);
        List lcdBrightnesses = info.getLcdBrightness().stream().map(lcdBrightnessInfo -> this.buildLcdBrightness(lcdConfig.getId(), (VoiceScreenUpRequest.LcdBrightnessInfo)lcdBrightnessInfo)).collect(Collectors.toList());
        this.lcdBrightnessService.saveBatch(lcdBrightnesses);
        this.lcdShowService.saveBatch(lcdShows);
        this.lcdTipsService.saveBatch(lcdTipses);
        this.lcdSoundService.saveBatch(lcdSounds);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(Long.valueOf(parkId));
        guide.setStep5(Integer.valueOf(1));
        this.parkGuideService.updateByParkId(guide);
        this.sendInfoService.save((Object)SendInfo.buildUnneeded((Long)parkId, (Long)parkId, (Integer)DownServiceEnum.LCD\u8bed\u97f3\u5c4f\u663e.getServiceType(), (String)"\u672c\u5730\u4e0a\u62a5"));
        this.stringRedisTemplate.delete(Arrays.asList("lcd:config:channel:" + channelId, "lcd:show:channel:" + channelId, "lcd:sound:channel:" + channelId, "lcd:tips:channel:" + channelId));
        return ObjectResponse.success();
    }

    private LedConfig buildLedSoundConfig(long parkId, VoiceScreenUpRequest.LedDetailInfo info) {
        LedConfig config = new LedConfig();
        config.setParkId(Long.valueOf(parkId));
        config.setLedLineNum(info.getLedLineNum());
        config.setLedRemainDaysMc(info.getLedRemainDaysMc());
        config.setLedExpireDaysMc(info.getLedExpireDaysMc());
        config.setLedBlackCar(info.getLedBlackCar());
        config.setLedRestoreDefaultTime(info.getLedRestoreDefaultTime());
        config.setLedQrcodeRule(info.getLedQrcodeRule());
        config.setVolumeValue(info.getVolumeValue());
        config.setQuietHoursSwitch(info.getQuietHoursSwitch());
        config.setQuietStartTime(LocalTime.parse(info.getQuietStartTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietEndTime(LocalTime.parse(info.getQuietEndTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietVolumeValue(info.getQuietVolumeValue());
        config.setLimitType(info.getLimitType());
        config.setLimitDriveNum1(info.getLimitDriveNum1());
        config.setLimitDriveNum2(info.getLimitDriveNum2());
        config.setLimitDriveNum3(info.getLimitDriveNum3());
        config.setLimitDriveNum4(info.getLimitDriveNum4());
        config.setLimitDriveNum5(info.getLimitDriveNum5());
        return config;
    }

    private LedShow buildLedConfig(long parkId, VoiceScreenUpRequest.LedConfigInfo info) {
        LedShow ledShow = new LedShow();
        ledShow.setParkId(Long.valueOf(parkId));
        ledShow.setDisplayType(info.getDisplayType());
        ledShow.setRowNum(info.getRowNum());
        ledShow.setLedColor(info.getLedColor());
        ledShow.setDynamicContent(info.getDynamicContent());
        ledShow.setCustomContent(info.getCustomContent());
        return ledShow;
    }

    private LedSound buildLedSound(long parkId, VoiceScreenUpRequest.LedSoundConfigInfo info) {
        LedSound ledSound = new LedSound();
        ledSound.setParkId(Long.valueOf(parkId));
        ledSound.setSoundType(info.getSoundType());
        ledSound.setDynamicContent(info.getDynamicContent());
        ledSound.setCustomContent(info.getCustomContent());
        return ledSound;
    }

    private LedTips buildLedSpecial(long parkId, VoiceScreenUpRequest.LedSpecialInfo info) {
        LedTips special = new LedTips();
        special.setParkId(Long.valueOf(parkId));
        special.setEnterTmpSpecial(info.getEnterTmpSpecial());
        special.setEnterMonthVip(info.getEnterMonthVip());
        special.setEnterNotAllowTmpRun(info.getEnterNotAllowTmpRun());
        special.setEnterMultiParkCar(info.getEnterMultiParkCar());
        special.setEnterBlackCar(info.getEnterBlackCar());
        special.setEnterMonthExpire(info.getEnterMonthExpire());
        special.setEnterNoParkingSpace(info.getEnterNoParkingSpace());
        special.setEnterNotAllowNocarRun(info.getEnterNotAllowNocarRun());
        special.setExitPay(info.getExitPay());
        special.setExitOpenGate(info.getExitOpenGate());
        special.setExitNoEnterinfo(info.getExitNoEnterinfo());
        special.setExitNoCarplate(info.getExitNoCarplate());
        special.setExitNotAllowRun(info.getExitNotAllowRun());
        return special;
    }

    private LcdConfig buildLcdConfig(long parkId, VoiceScreenUpRequest.LcdDetailInfo info) {
        LcdConfig config = new LcdConfig();
        config.setLineNum(info.getLineNum());
        config.setRemainDaysMc(info.getRemainDaysMc());
        config.setExpireDaysMc(info.getExpireDaysMc());
        config.setExpireDaysMonth(info.getExpireDaysMonth());
        config.setBlackCar(info.getBlackCar());
        config.setEntranceFreeLayout(info.getEntranceFreeLayout());
        config.setEnterLayout(info.getEnterLayout());
        config.setExitFreeLayout(info.getExitFreeLayout());
        config.setExitLayout(info.getExitLayout());
        config.setRestoreDefaultTime(info.getRestoreDefaultTime());
        config.setVolumeValue(info.getVolumeValue());
        config.setQuietHoursSwitch(info.getQuietHoursSwitch());
        config.setQuietStartTime(LocalTime.parse(info.getQuietStartTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietEndTime(LocalTime.parse(info.getQuietEndTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietVolumeValue(info.getQuietVolumeValue());
        config.setLimitType(info.getLimitType());
        config.setLimitDriveNum1(info.getLimitDriveNum1());
        config.setLimitDriveNum2(info.getLimitDriveNum2());
        config.setLimitDriveNum3(info.getLimitDriveNum3());
        config.setLimitDriveNum4(info.getLimitDriveNum4());
        config.setLimitDriveNum5(info.getLimitDriveNum5());
        config.setParkId(Long.valueOf(parkId));
        return config;
    }

    private LcdBrightness buildLcdBrightness(long lcdId, VoiceScreenUpRequest.LcdBrightnessInfo info) {
        LcdBrightness brightness = new LcdBrightness();
        brightness.setLcdId(Long.valueOf(lcdId));
        brightness.setStartTimePoint(info.getStartTimePoint());
        brightness.setEndTimePoint(info.getEndTimePoint());
        brightness.setBrightnessVal(info.getBrightnessVal());
        brightness.setSort(info.getSort());
        return brightness;
    }

    private LcdShow buildLcdShow(long parkId, VoiceScreenUpRequest.LcdShowInfo info) {
        LcdShow show = new LcdShow();
        show.setParkId(Long.valueOf(parkId));
        show.setDisplayType(info.getDisplayType());
        show.setRowNum(info.getRowNum());
        show.setRowColor(info.getRowColor());
        show.setDynamicContent(info.getDynamicContent());
        show.setCustomContent(info.getCustomContent());
        return show;
    }

    private LcdTips buildLcdTips(long parkId, VoiceScreenUpRequest.LcdTipsInfo info) {
        LcdTips tips = new LcdTips();
        tips.setParkId(Long.valueOf(parkId));
        tips.setEnterTmpSpecial(info.getEnterTmpSpecial());
        tips.setEnterMonthVip(info.getEnterMonthVip());
        tips.setEnterNotAllowTmpRun(info.getEnterNotAllowTmpRun());
        tips.setEnterMultiParkCar(info.getEnterMultiParkCar());
        tips.setEnterBlackCar(info.getEnterBlackCar());
        tips.setEnterMonthExpire(info.getEnterMonthExpire());
        tips.setEnterNoParkingSpace(info.getEnterNoParkingSpace());
        tips.setEnterNotAllowNocarRun(info.getEnterNotAllowNocarRun());
        tips.setExitPay(info.getExitPay());
        tips.setExitOpenGate(info.getExitOpenGate());
        tips.setExitNoEnterinfo(info.getExitNoEnterinfo());
        tips.setExitNoCarplate(info.getExitNoCarplate());
        tips.setExitNotAllowRun(info.getExitNotAllowRun());
        return tips;
    }

    private LcdSoundcode buildLcdSoundCode(VoiceScreenUpRequest.LcdSoundCodeInfo info) {
        LcdSoundcode code = new LcdSoundcode();
        code.setSoundCode(info.getSoundCode());
        code.setContent(info.getContent());
        code.setType(info.getType());
        code.setIsCustom(info.getIsCustom());
        code.setCustomSoundPath(info.getCustomSoundPath());
        return code;
    }

    private LcdSound buildLcdSound(long parkId, VoiceScreenUpRequest.LcdSoundInfo info) {
        LcdSound sound = new LcdSound();
        sound.setParkId(Long.valueOf(parkId));
        sound.setSoundType(info.getSoundType());
        sound.setContentPattern(info.getContentPattern());
        return sound;
    }
}

