/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.UploadFileRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.oss.OssService;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UploadFileServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(UploadFileServiceImpl.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        UploadFileRequest uploadFileRequest = (UploadFileRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), UploadFileRequest.class);
        this.verifyParams(uploadFileRequest);
        String parkCode = dataCenterBaseRequest.getParkCode();
        String date = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date());
        String[] ymd = date.split("-");
        String imgFileName = parkCode + "/image/" + ymd[0] + ymd[1] + "/" + ymd[2] + "/" + uploadFileRequest.getFileName();
        this.ossService.uploadBase64(uploadFileRequest.getBase64Str(), imgFileName);
        log.info("<\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3> \u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\uff0c\u6587\u4ef6\u540d\uff1a{}", (Object)imgFileName);
        int fileType = uploadFileRequest.getFileType();
        String orderId = uploadFileRequest.getOrderId();
        if (orderId != null) {
            String orderNum = this.publicHandle.convert2OrderNum(parkId, orderId);
            OrderCarInfo data = new OrderCarInfo();
            data.setOrderNum(orderNum);
            if (uploadFileRequest.getEnexType() == 1) {
                if (fileType == 1) {
                    data.setEnterImage(imgFileName);
                } else {
                    data.setSmallEnterImage(imgFileName);
                }
            } else if (fileType == 1) {
                data.setExitImage(imgFileName);
            } else {
                data.setSmallExitImage(imgFileName);
            }
            return this.orderCarInfoService.updateCarInfo(data);
        }
        this.redisUtils.set("PNC_FILEID_PROFILE_" + parkCode + uploadFileRequest.getFileId(), (Object)imgFileName, 30L);
        return ObjectResponse.success();
    }
}

