/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderSimpleExitService;
import com.icetech.cloudcenter.domain.request.SimpleExitRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.report.pnc.AbstractExitService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimpleExitServiceImpl
extends AbstractExitService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(SimpleExitServiceImpl.class);
    @Autowired
    private OrderSimpleExitService orderSimpleExitService;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        SimpleExitRequest exitRequest = (SimpleExitRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), SimpleExitRequest.class);
        this.verifyParams(exitRequest);
        exitRequest.setParkId(parkId);
        try {
            ObjectResponse objectResponse;
            String key3;
            String key2 = "QUERY_FEE_FAIL:" + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId();
            if (this.redisUtils.exists(key2)) {
                this.redisUtils.remove(key2);
            }
            if (this.redisUtils.exists(key3 = "SWITCH_FAIL:" + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId())) {
                this.redisUtils.remove(key3);
            }
            if ((objectResponse = this.orderSimpleExitService.exit(exitRequest, dataCenterBaseRequest.getParkCode())) == null) {
                return ObjectResponse.failed((String)"500");
            }
            return objectResponse;
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((String)"500");
        }
    }
}

