/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkLicenseService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkLicenseRequest;
import com.icetech.cloudcenter.domain.response.ParkLicenseDto;
import com.icetech.cloudcenter.domain.response.pnc.LicenseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectLicenceInfoServiceImpl
extends AbstractService
implements ReportService {
    private int LICENSE_STATUS_OK = 1;
    private int LICENSE_STATUS_NO = 2;
    private int LICENSE_STATUS_USE = 3;
    private int LICENSE_STATUS_INVALID = 4;
    private int LICENSE_STATUS_OVER = 5;
    @Autowired
    private ParkLicenseService parkLicenseService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ObjectResponse parkLicenseResponse;
        ParkLicenseRequest parkLicenseRequest = (ParkLicenseRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), ParkLicenseRequest.class);
        this.verifyParams(parkLicenseRequest);
        LicenseResponse licenseResponse = new LicenseResponse();
        String license = this.getLicense(parkLicenseRequest.getLicenceInfo());
        if (StringUtils.isEmpty((CharSequence)license)) {
            licenseResponse.setLicenceStatus(2);
        }
        if (ObjectResponse.isSuccess((Response)(parkLicenseResponse = this.parkLicenseService.selectParkLicense(license)))) {
            ParkLicenseDto data = (ParkLicenseDto)parkLicenseResponse.getData();
            if (data.getGrantStatus() == 1) {
                licenseResponse.setLicenceStatus(this.LICENSE_STATUS_NO);
            } else if (data.getEnableStatus() == 2) {
                licenseResponse.setLicenceStatus(this.LICENSE_STATUS_USE);
            } else if (data.getEnableStatus() == 3) {
                licenseResponse.setLicenceStatus(this.LICENSE_STATUS_INVALID);
            } else if (data.getEnableStatus() == 4) {
                licenseResponse.setLicenceStatus(this.LICENSE_STATUS_OVER);
            } else {
                licenseResponse.setLicenceStatus(this.LICENSE_STATUS_OK);
            }
            return ObjectResponse.success((Object)licenseResponse);
        }
        licenseResponse.setLicenceStatus(2);
        return ObjectResponse.success((Object)licenseResponse);
    }

    private String getLicense(String plusSaltLicense) {
        String license = "";
        char[] chars = plusSaltLicense.toCharArray();
        StringBuffer sf = new StringBuffer();
        for (int i = 1; i < chars.length + 1; ++i) {
            if (i % 4 == 0) continue;
            sf.append(chars[i - 1]);
        }
        license = sf.toString();
        return license;
    }
}

