/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.discount.DiscountService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.DiscountInfoRequest;
import com.icetech.cloudcenter.domain.response.pnc.DiscountInfoResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchDiscountInfoServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private DiscountService discountService;
    @Autowired
    private PublicHandle publicHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        DiscountInfoRequest discountInfoRequest = (DiscountInfoRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), DiscountInfoRequest.class);
        this.verifyParams(discountInfoRequest);
        List<OrderDiscount> orderDiscounts = this.getOrderPays(parkId, discountInfoRequest);
        ArrayList<DiscountInfoResponse> discountInfoResponses = new ArrayList<DiscountInfoResponse>();
        for (int i = 0; i < orderDiscounts.size(); ++i) {
            OrderDiscount orderDiscount = orderDiscounts.get(i);
            DiscountInfoResponse discountInfoResponse = new DiscountInfoResponse();
            discountInfoResponse.setDiscountNo(orderDiscount.getDiscountNo());
            discountInfoResponse.setDiscountType(orderDiscount.getType());
            discountInfoResponse.setDiscountNumber(orderDiscount.getAmount());
            discountInfoResponse.setDiscountTime(Long.valueOf(orderDiscount.getSendTime().getTime() / 1000L));
            discountInfoResponses.add(discountInfoResponse);
        }
        if (discountInfoResponses.size() <= 0) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success(discountInfoResponses);
    }

    private List<OrderDiscount> getOrderPays(Long parkId, DiscountInfoRequest discountInfoRequest) {
        String orderId = discountInfoRequest.getOrderId();
        String orderNum = this.publicHandle.convert2OrderNum(parkId, orderId);
        PageQuery payPageQuery = new PageQuery();
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setParkId(parkId);
        orderDiscount.setOrderNum(orderNum);
        payPageQuery.setParam((Object)orderDiscount);
        ObjectResponse objectResponse = this.discountService.findList(payPageQuery);
        ObjectResponse.notError((Response)objectResponse);
        return (List)objectResponse.getData();
    }
}

