/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RobotShowPayInfoRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2r.impl.ShowPayInfoServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RobotShowPayInfoServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(RobotShowPayInfoServiceImpl.class);
    @Autowired
    private ShowPayInfoServiceImpl showPayInfoService;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        RobotShowPayInfoRequest robotSayShowRequest = (RobotShowPayInfoRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), RobotShowPayInfoRequest.class);
        this.verifyParams(robotSayShowRequest);
        String serialNumber = this.cacheHandle.getChannelRobot(dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        if (serialNumber != null) {
            ShowPayInfoRequest showPayInfoRequest = new ShowPayInfoRequest();
            showPayInfoRequest.setOrderNum(robotSayShowRequest.getOrderId());
            showPayInfoRequest.setQrCodeUrl(robotSayShowRequest.getQrCodeUrl());
            showPayInfoRequest.setNoticeMsg(robotSayShowRequest.getNoticeMsg());
            showPayInfoRequest.setShow(robotSayShowRequest.getShow());
            ObjectResponse objectResponse = this.showPayInfoService.executeDown(parkId, serialNumber, showPayInfoRequest);
            if (objectResponse == null) {
                return ObjectResponse.failed((String)"500", (String)"\u4e0b\u53d1\u673a\u5668\u4eba\u5931\u8d25");
            }
            return objectResponse;
        }
        log.error("[\u4e91\u4e91]\u4e0b\u53d1\u673a\u5668\u4eba\u652f\u4ed8\u5c55\u793a\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u901a\u9053\u673a\u5668\u4eba\u5e8f\u5217\u53f7\uff0cparkCode\uff1a[{}]\uff0cchannelId\uff1a[{}]", (Object)dataCenterBaseRequest.getParkCode(), (Object)robotSayShowRequest.getChannelId());
        return ObjectResponse.failed((String)"500");
    }
}

