/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RobotSayShowRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2r.impl.HintServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RobotSayShowServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(RobotSayShowServiceImpl.class);
    @Autowired
    private HintServiceImpl robotHintService;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        RobotSayShowRequest robotSayShowRequest = (RobotSayShowRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), RobotSayShowRequest.class);
        this.verifyParams(robotSayShowRequest);
        String serialNumber = this.cacheHandle.getChannelRobot(dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        if (serialNumber != null) {
            RobotHintRequest robotHintRequest = new RobotHintRequest();
            robotHintRequest.setPlateNum(robotSayShowRequest.getPlateNum());
            robotHintRequest.setShow(robotSayShowRequest.getShow());
            robotHintRequest.setSay(robotSayShowRequest.getSay());
            ObjectResponse objectResponse = this.robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
            return objectResponse;
        }
        log.info("[\u7aef\u7f51\u4e91]\u4e0b\u53d1\u673a\u5668\u4eba\u8bed\u97f3\u5c4f\u663e\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u901a\u9053\u673a\u5668\u4eba\u5e8f\u5217\u53f7\uff0cparkCode[{}]\uff0cchannelId[{}]", (Object)dataCenterBaseRequest.getParkCode(), (Object)robotSayShowRequest.getChannelId());
        return ObjectResponse.failed((String)"3003", (String)"\u673a\u5668\u4eba\u8bbe\u5907\u4e0d\u5728\u7ebf");
    }
}

