/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.domain.enumeration.P2rCmdEnum;
import com.icetech.cloudcenter.domain.request.p2r.PrintInfoRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RobotPrintInfoRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2r.impl.PrintInfoServiceImpl;
import com.icetech.park.service.handle.P2rMsgHandle;
import com.icetech.park.service.report.pnc.ReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RobotPrintInfoServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(RobotPrintInfoServiceImpl.class);
    @Autowired
    private PrintInfoServiceImpl printInfoService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private P2rMsgHandle p2rMsgHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        RobotPrintInfoRequest robotSayShowRequest = (RobotPrintInfoRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), RobotPrintInfoRequest.class);
        this.verifyParams(robotSayShowRequest);
        String serialNumber = this.cacheHandle.getChannelRobot(dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        if (serialNumber != null) {
            PrintInfoRequest printInfoRequest = new PrintInfoRequest();
            printInfoRequest.setOrderNum(robotSayShowRequest.getOrderId());
            printInfoRequest.setHeadMsg(robotSayShowRequest.getHeadMsg());
            printInfoRequest.setBottomMsg(robotSayShowRequest.getBottomMsg());
            printInfoRequest.setQrCodeUrl(robotSayShowRequest.getQrCodeUrl());
            String messageId = this.p2rMsgHandle.send(parkId, serialNumber, P2rCmdEnum.\u6253\u5370\u673a\u4fe1\u606f\u4e0b\u53d1.getCmdType(), printInfoRequest);
            if (StringUtils.isNotBlank((CharSequence)messageId)) {
                return ObjectResponse.success();
            }
        }
        log.info("[\u7aef\u7f51\u4e91]\u673a\u5668\u4eba\u6253\u5370\u673a\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u901a\u9053\u673a\u5668\u4eba\u5e8f\u5217\u53f7\uff0cparkCode[{}]\uff0cchannelId[{}]", (Object)dataCenterBaseRequest.getParkCode(), (Object)robotSayShowRequest.getChannelId());
        return ObjectResponse.failed((String)"3003", (String)"\u673a\u5668\u4eba\u8bbe\u5907\u4e0d\u5728\u7ebf");
    }
}

