/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RetentionCarRequest;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pncRetentionCarServiceImpl")
public class RetentionCarServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(RetentionCarServiceImpl.class);
    @Resource
    private AlarmService alarmService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderInfoDao orderInfoDao;

    public ObjectResponse<Void> report(DataCenterBaseRequest baseRequest, Long parkId) {
        RetentionCarRequest retentionCarLeaveRequest = (RetentionCarRequest)JsonUtils.convert2bean((Object)baseRequest.getBizContent(), RetentionCarRequest.class);
        this.verifyParams(retentionCarLeaveRequest);
        ObjectResponse parkResponse = this.parkService.findByParkId(parkId);
        Park park = (Park)parkResponse.getData();
        if (Objects.isNull(park)) {
            return ObjectResponse.success();
        }
        ParkInoutdevice parkInoutdevice = this.parkService.getChannelByCodeAndParkId(parkId, retentionCarLeaveRequest.getChannelId());
        if (Objects.isNull(parkInoutdevice)) {
            return ObjectResponse.success();
        }
        OrderInfo orderInfoSearch = new OrderInfo();
        orderInfoSearch.setLocalOrderNum(retentionCarLeaveRequest.getOrderId());
        orderInfoSearch.setParkId(parkId);
        OrderInfo orderInfoResult = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfoSearch);
        AisleInfoVo aisleInfoVo = new AisleInfoVo();
        aisleInfoVo.setParkCode(park.getParkCode());
        aisleInfoVo.setParkId(park.getId());
        aisleInfoVo.setAisleType(parkInoutdevice.getInandoutType());
        aisleInfoVo.setAisleCode(parkInoutdevice.getInandoutCode());
        aisleInfoVo.setOrderNum(orderInfoResult == null ? null : orderInfoResult.getOrderNum());
        aisleInfoVo.setImage(retentionCarLeaveRequest.getMaxImage());
        this.alarmService.aisleDurationAlarm(aisleInfoVo);
        return ObjectResponse.success();
    }
}

