/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.QueryMoreMonthCarRequest;
import com.icetech.cloudcenter.domain.response.pnc.QueryMoreMonthCarResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.more.MoreMonthInfo;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.park.domain.entity.more.MoreMonthPlate;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.more.MoreMonthInfoService;
import com.icetech.park.service.more.MoreMonthParkService;
import com.icetech.park.service.more.MoreMonthPlateService;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMoreMonthCarServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private MoreMonthInfoService moreMonthInfoService;
    @Autowired
    private MoreMonthParkService moreMonthParkService;
    @Autowired
    private MoreMonthPlateService moreMonthPlateService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkService parkService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        QueryMoreMonthCarRequest request = (QueryMoreMonthCarRequest)JSON.parseObject((String)JSON.toJSONString((Object)dataCenterBaseRequest.getBizContent()), QueryMoreMonthCarRequest.class);
        this.verifyParams(request);
        Long moreMonthId = request.getMoreMonthId();
        MoreMonthInfo moreMonthInfo = (MoreMonthInfo)this.moreMonthInfoService.getById(moreMonthId);
        if (moreMonthInfo == null) {
            return ObjectResponse.failed((String)"404", (String)"\u591a\u8f66\u573a\u6708\u5361\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (moreMonthInfo.getCardStatus() != null && moreMonthInfo.getCardStatus() == 3) {
            return ObjectResponse.failed((String)"404", (String)"\u591a\u8f66\u573a\u6708\u5361\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List<MoreMonthPark> monthParks = this.moreMonthParkService.getMonthParkByMoreMonthId(moreMonthId);
        if (CollectionUtils.isEmpty(monthParks)) {
            return ObjectResponse.failed((String)"404", (String)"\u591a\u8f66\u573a\u6708\u5361\u6ca1\u6709\u5173\u8054\u8f66\u573a");
        }
        List<MoreMonthPlate> moreMonthPlates = this.moreMonthPlateService.getMoreMonthPlateByMoreMonthId(moreMonthId);
        if (CollectionUtils.isEmpty(moreMonthPlates)) {
            return ObjectResponse.failed((String)"404", (String)"\u591a\u8f66\u573a\u6708\u5361\u6ca1\u6709\u5173\u8054\u8f66\u724c\u53f7");
        }
        List response = monthParks.stream().map(monthPark -> {
            Long monthParkParkId = monthPark.getParkId();
            ObjectResponse parkObj = this.parkService.findByParkId(monthParkParkId);
            String parkName = ObjectResponse.isSuccess((Response)parkObj) ? ((Park)parkObj.getData()).getParkName() : "";
            return moreMonthPlates.stream().map(MoreMonthPlate::getPlateNum).map(plateNum -> OrderInfo.builder().parkId(monthParkParkId).plateNum(plateNum).build()).map(orderInfo -> this.orderService.findByOrderInfo(orderInfo)).filter(Response::isSuccess).map(ObjectResponse::getData).filter(this::isValidOrder).map(orderResp -> QueryMoreMonthCarResponse.builder().parkId(monthParkParkId).parkName(parkName).enterTime(orderResp.getEnterTime()).exitTime(orderResp.getExitTime()).type(orderResp.getType()).plateNum(orderResp.getPlateNum()).status(Integer.valueOf(orderResp.getServiceStatus() == 1 ? 1 : 2)).build()).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        return ObjectResponse.success(response);
    }

    public boolean isValidOrder(OrderInfo orderResp) {
        if (3 == orderResp.getServiceStatus()) {
            return false;
        }
        return 4 != orderResp.getServiceStatus() || !orderResp.getEnterTime().equals(orderResp.getExitTime());
    }
}

