/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.QueryInParkOrderRequest;
import com.icetech.cloudcenter.domain.response.pnc.QueryInParkOrderResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueryInParkOrderServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(QueryInParkOrderServiceImpl.class);
    @Resource
    private OrderService orderService;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        QueryInParkOrderRequest inParkOrderRequest = (QueryInParkOrderRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), QueryInParkOrderRequest.class);
        this.verifyParams(inParkOrderRequest);
        ObjectResponse objectResponse = this.orderService.findInPark(inParkOrderRequest.getPlateNum(), dataCenterBaseRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)objectResponse.getCode(), (String)"\u672a\u627e\u5230\u5728\u573a\u8bb0\u5f55");
        }
        OrderInfo orderInfo = (OrderInfo)objectResponse.getData();
        OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
        if (orderCarInfo == null) {
            return ObjectResponse.failed((String)objectResponse.getCode(), (String)"\u672a\u627e\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (5 != NumberUtils.toPrimitive((Integer)orderCarInfo.getEnterWay())) {
            return ObjectResponse.failed((String)"404", (String)"\u672a\u627e\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        QueryInParkOrderResponse queryInParkOrderResponse = QueryInParkOrderResponse.builder().orderNum(orderInfo.getLocalOrderNum() == null ? orderInfo.getOrderNum() : orderInfo.getLocalOrderNum()).plateNum(orderInfo.getPlateNum()).enterTime(orderInfo.getEnterTime()).type(orderInfo.getType()).carType(orderInfo.getCarType()).carDesc(orderInfo.getCarDesc()).enterImage(orderCarInfo.getEnterImage()).channelCode(orderCarInfo.getEnterChannelId()).build();
        return ObjectResponse.success((Object)queryInParkOrderResponse);
    }
}

