/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.cloudcenter.domain.request.pnc.AutopayRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.MoneyTool;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.partner.api.ThirdAutoPayService;
import com.icetech.partner.api.request.ThirdAutoPayRequest;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.request.autopay.ExitpayRequest;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="autopayServiceImpl")
public class PncAutopayServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(PncAutopayServiceImpl.class);
    @Autowired
    private IPayCenterService payCenterService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ThirdParkService thirdParkService;
    @Autowired
    private ThirdAutoPayService thirdAutoPayService;
    @Autowired
    private RedisUtils redisUtil;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        Map data;
        AutopayRequest autopayRequest = (AutopayRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), AutopayRequest.class);
        this.verifyParams(autopayRequest);
        String orderId = autopayRequest.getOrderId();
        if (orderId == null) {
            throw new ResponseBodyException("400", "\u68c0\u9a8c\u53c2\u6570\u672a\u901a\u8fc7");
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setLocalOrderNum(orderId);
        ObjectResponse byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
        ObjectResponse.notError((Response)byOrderInfo, (String)"\u672c\u5730\u8ba2\u5355\u53f7\u65e0\u6548");
        OrderInfo orderInfoData = (OrderInfo)byOrderInfo.getData();
        autopayRequest.setOrderNum(orderInfoData.getOrderNum());
        ThirdAutoPayRequest thirdAutoPayRequest = new ThirdAutoPayRequest();
        BeanUtils.copyProperties((Object)autopayRequest, (Object)thirdAutoPayRequest);
        thirdAutoPayRequest.setParkId(parkId);
        thirdAutoPayRequest.setParkCode(dataCenterBaseRequest.getParkCode());
        thirdAutoPayRequest.setEnterTime(orderInfoData.getEnterTime());
        thirdAutoPayRequest.setType(orderInfoData.getType());
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((CharSequence)autopayRequest.getPaidPrice())) {
            totalAmount = totalAmount.add(new BigDecimal(autopayRequest.getPaidPrice()));
        }
        if (StringUtils.isNotBlank((CharSequence)autopayRequest.getTotalPrice())) {
            totalAmount = totalAmount.add(new BigDecimal(autopayRequest.getTotalPrice()));
        }
        thirdAutoPayRequest.setTotalAmount(totalAmount.toString());
        ObjectResponse<Map<String, Object>> response = this.report(dataCenterBaseRequest.getParkCode(), parkId, thirdAutoPayRequest);
        if (ObjectResponse.isSuccess(response) && Boolean.TRUE.equals((data = (Map)response.getData()).get("isAfterPay"))) {
            OrderInfo orderInfoUpdate = new OrderInfo();
            orderInfoUpdate.setOrderNum(orderInfoData.getOrderNum());
            orderInfoUpdate.setTotalPrice(autopayRequest.getTotalPrice());
            orderInfoUpdate.setPaidPrice(autopayRequest.getPaidPrice());
            orderInfoUpdate.setDiscountPrice(autopayRequest.getDiscountPrice());
            orderInfoUpdate.setCityAutopay(Integer.valueOf(1));
            orderInfoUpdate.setNeedPrice(autopayRequest.getUnpayPrice());
            this.orderService.updateOrderInfo(orderInfoUpdate);
        }
        return response;
    }

    public ObjectResponse<Map<String, Object>> report(String parkCode, Long parkId, ThirdAutoPayRequest autoPayRequest) {
        ObjectResponse objectResponse;
        ObjectResponse response;
        block9: {
            log.info("[\u8bf7\u6c42\u7b2c\u4e09\u65b9\u65e0\u611f\u652f\u4ed8] autoPayRequest[{}]", (Object)autoPayRequest);
            response = null;
            try {
                List thirdInfos;
                if (autoPayRequest.getChannelId() == null && autoPayRequest.getChannelCode() != null) {
                    objectResponse = this.parkService.getInOutDeviceByCode(autoPayRequest.getParkId(), autoPayRequest.getChannelCode());
                    ObjectResponse.notError((Response)objectResponse);
                    ParkInoutdevice inoutdevice = (ParkInoutdevice)objectResponse.getData();
                    autoPayRequest.setChannelId(inoutdevice.getId());
                    autoPayRequest.setChannelName(inoutdevice.getInandoutName());
                }
                if (!CollectionUtils.isNotEmpty((Collection)(thirdInfos = this.thirdParkService.selectNoSenConfigs(parkId)))) break block9;
                for (ThirdInfo thirdInfo : thirdInfos) {
                    ObjectResponse objectObjectResponse;
                    response = objectObjectResponse = this.thirdAutoPayService.autoPay(autoPayRequest, thirdInfo);
                    if (!ObjectResponse.isSuccess((Response)objectObjectResponse)) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error("[\u8bf7\u6c42\u7b2c\u4e09\u65b9\u65e0\u611f\u652f\u4ed8] \u8bf7\u6c42\u53c2\u6570[{}], e=", (Object)autoPayRequest, (Object)e);
            }
        }
        if (ObjectResponse.isSuccess(response) && response.getData() != null) {
            Map retMap = JsonUtils.parseMap((String)JsonUtils.toString((Object)response.getData()));
            retMap.put("payWay", 4);
            this.redisUtil.remove("lock:etc:pay:" + autoPayRequest.getOrderNum());
            return ObjectResponse.success((Object)retMap);
        }
        objectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)objectResponse);
        ParkConfig data = (ParkConfig)objectResponse.getData();
        if (data == null || data.getIsNosenpayment() != 1) {
            log.info("<\u79bb\u573a\u6263\u6b3e\u63a5\u53e3> \u8f66\u573a\u672a\u5f00\u542f\u65e0\u611f\u652f\u4ed8\u529f\u80fd\uff0c\u53c2\u6570\uff1a{}", (Object)autoPayRequest);
            return ObjectResponse.failed((String)"2002", (String)CodeConstants.getName((String)"2002"));
        }
        ExitpayRequest exitpayRequest = this.getExitPayRequest(parkCode, autoPayRequest);
        exitpayRequest.setNoSenseType(data.getNoSenPayment());
        log.info("\u51c6\u5907\u8bf7\u6c42\u6263\u8d39\uff0c\u53c2\u6570[{}]", (Object)exitpayRequest);
        ObjectResponse objectResponse1 = null;
        try {
            objectResponse1 = this.payCenterService.autopay(exitpayRequest);
            log.info("\u65e0\u611f\u652f\u4ed8\u54cd\u5e94[{}]", (Object)objectResponse1);
        }
        catch (Exception e) {
            log.error("[\u8bf7\u6c42paycenter\u65e0\u611f\u652f\u4ed8] \u8bf7\u6c42\u53c2\u6570[{}], e=", (Object)autoPayRequest, (Object)e);
        }
        if (objectResponse1 != null && objectResponse1.getCode().equals("200")) {
            autoPayRequest.setPaidPrice(autoPayRequest.getUnpayPrice());
            this.savePayRecord(autoPayRequest, parkId, exitpayRequest.getTradeNo());
            HashMap<String, Object> retMap = new HashMap<String, Object>();
            retMap.put("tradeNo", exitpayRequest.getTradeNo());
            retMap.put("payWay", 4);
            return ObjectResponse.success(retMap);
        }
        return objectResponse1;
    }

    private void savePayRecord(ThirdAutoPayRequest autoPayRequest, Long parkId, String tradeNo) {
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(autoPayRequest.getOrderNum());
        orderPay.setPayStatus(Integer.valueOf(2));
        orderPay.setParkId(parkId);
        orderPay.setDiscountPrice(autoPayRequest.getDiscountPrice());
        orderPay.setPaidPrice(autoPayRequest.getPaidPrice());
        orderPay.setPayChannel(Integer.valueOf(7));
        orderPay.setPayTerminal("\u94f6\u8054\u65e0\u611f\u652f\u4ed8");
        orderPay.setPayTime(autoPayRequest.getPayTime());
        orderPay.setOrderTime(autoPayRequest.getPayTime());
        orderPay.setPayWay(Integer.valueOf(4));
        orderPay.setTotalPrice(autoPayRequest.getTotalPrice());
        orderPay.setTradeNo(tradeNo);
        orderPay.setIsSync(Integer.valueOf(0));
        this.orderPayService.addOrderPay(orderPay);
    }

    private ExitpayRequest getExitPayRequest(String parkCode, ThirdAutoPayRequest autopayRequest) {
        ExitpayRequest exitpayRequest = new ExitpayRequest();
        exitpayRequest.setParkCode(parkCode);
        String tradeNo = CodeTools.GenerateTradeNo();
        exitpayRequest.setTradeNo(tradeNo);
        ObjectResponse objectResponse = this.orderService.findByOrderNum(autopayRequest.getOrderNum());
        ObjectResponse.notError((Response)objectResponse);
        OrderInfo orderInfo = (OrderInfo)objectResponse.getData();
        exitpayRequest.setEnterTime(DateTools.secondTostring((int)orderInfo.getEnterTime().intValue()));
        exitpayRequest.setUnpayPrice(MoneyTool.fromYuanToFen((String)autopayRequest.getUnpayPrice()));
        exitpayRequest.setTotalPrice(MoneyTool.fromYuanToFen((String)autopayRequest.getTotalPrice()));
        exitpayRequest.setExitTime(DateTools.secondTostring((int)autopayRequest.getPayTime().intValue()));
        exitpayRequest.setPlateNum(autopayRequest.getPlateNum());
        exitpayRequest.setOrderNum(orderInfo.getOrderNum());
        return exitpayRequest;
    }
}

