/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.device.impl.ParkDeviceDaoImpl;
import com.icetech.basics.service.park.impl.ParkInoutdeviceServiceImpl;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkingFacilitiesUpRequest;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.charge.ChargeServiceImpl;
import com.icetech.park.service.park.impl.ParkGuideServiceImpl;
import com.icetech.park.service.park.impl.ParkRegionServiceImpl;
import com.icetech.park.service.park.impl.RegionChargeconfigServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.SendInfoServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParkingFacilitiesUpServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ParkingFacilitiesUpServiceImpl.class);
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkRegionServiceImpl parkRegionService;
    @Autowired
    private RegionChargeconfigServiceImpl regionChargeConfigService;
    @Autowired
    private ParkInoutdeviceServiceImpl parkInoutDeviceService;
    @Autowired
    private ParkDeviceDaoImpl parkDeviceService;
    @Autowired
    private ChargeServiceImpl chargeService;
    @Autowired
    private ParkGuideServiceImpl parkGuideService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    @Transactional
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) throws Exception {
        if (baseRequest.getBizContent() == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        List requests = JSON.parseArray((String)JSON.toJSONString((Object)baseRequest.getBizContent()), ParkingFacilitiesUpRequest.class);
        if (CollectionUtils.isEmpty((Collection)requests)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        HashMap<String, ParkingFacilitiesUpRequest> regionInfoMap = new HashMap<String, ParkingFacilitiesUpRequest>(requests.size());
        HashMap<String, ParkingFacilitiesUpRequest.ChannelInfo> channelInfoMap = new HashMap<String, ParkingFacilitiesUpRequest.ChannelInfo>(requests.size() * 2);
        HashMap<String, ParkingFacilitiesUpRequest.DeviceInfo> deviceInfoMap = new HashMap<String, ParkingFacilitiesUpRequest.DeviceInfo>(requests.size() * 2 * 2);
        for (ParkingFacilitiesUpRequest request : requests) {
            regionInfoMap.put(request.getRegionCode(), request);
            if (CollectionUtils.isEmpty((Collection)request.getWayInfo())) continue;
            for (ParkingFacilitiesUpRequest.ChannelInfo channelInfo : request.getWayInfo()) {
                channelInfo.setRegionCode(request.getRegionCode());
                channelInfoMap.put(channelInfo.getInandoutCode(), channelInfo);
                if (CollectionUtils.isEmpty((Collection)channelInfo.getDevices())) continue;
                for (ParkingFacilitiesUpRequest.DeviceInfo device : channelInfo.getDevices()) {
                    device.setInandoutCode(channelInfo.getInandoutCode());
                    deviceInfoMap.put(device.getDeviceCode(), device);
                }
            }
        }
        HashSet<String> cacheKeys = new HashSet<String>();
        Map<String, ParkRegion> regionMap = this.handleRegion(parkId, regionInfoMap);
        this.handleRegionCharge(parkId, regionInfoMap, regionMap);
        cacheKeys.add("charge:region:park:" + parkId);
        Map<String, ParkInoutdevice> channelMap = this.handleChannel(parkId, channelInfoMap, regionMap, cacheKeys);
        this.handleDevice(parkId, deviceInfoMap, channelMap, cacheKeys);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(parkId);
        guide.setStep3(Integer.valueOf(1));
        guide.setStep4(Integer.valueOf(1));
        this.parkGuideService.updateByParkId(guide);
        LinkedList sendInfos = new LinkedList();
        regionMap.values().stream().map(region -> SendInfo.buildUnneeded((Long)parkId, (Long)region.getId(), (Integer)DownServiceEnum.\u533a\u57df\u4fe1\u606f\u548c\u8ba1\u8d39\u89c4\u5219\u5173\u8054\u5173\u7cfb.getServiceType(), (String)"\u672c\u5730\u4e0a\u62a5")).collect(Collectors.toCollection(() -> sendInfos));
        channelMap.values().stream().map(channel -> SendInfo.buildUnneeded((Long)parkId, (Long)channel.getId(), (Integer)DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceType(), (String)"\u672c\u5730\u4e0a\u62a5")).collect(Collectors.toCollection(() -> sendInfos));
        this.sendInfoService.saveBatch(sendInfos);
        this.stringRedisTemplate.delete(cacheKeys);
        return ObjectResponse.success();
    }

    private Map<String, ParkRegion> handleRegion(long parkId, Map<String, ParkingFacilitiesUpRequest> regionInfoMap) {
        List parkRegions = this.parkRegionService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRegion.class).eq(ParkRegion::getParkId, (Object)parkId)).eq(ParkRegion::getStatus, (Object)0));
        Map existsRegionMap = parkRegions.stream().collect(Collectors.toMap(ParkRegion::getRegionCode, Function.identity()));
        LinkedList<ParkRegion> outerRegions = new LinkedList<ParkRegion>();
        LinkedList<ParkRegion> innerRegions = new LinkedList<ParkRegion>();
        LinkedList<ParkRegion> updateRegions = new LinkedList<ParkRegion>();
        HashMap<String, ParkRegion> newRegionMap = new HashMap<String, ParkRegion>();
        for (Map.Entry<String, ParkingFacilitiesUpRequest> regionInfoEntry : regionInfoMap.entrySet()) {
            ParkingFacilitiesUpRequest regionInfo = regionInfoEntry.getValue();
            if (regionInfo.getRegionType() == 1 && StringUtils.isBlank((CharSequence)regionInfo.getParentCode())) {
                throw new ResponseBodyException("400", "\u533a\u57df[" + regionInfo.getRegionCode() + "]\u7236\u533a\u57df\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            ParkRegion existsRegion = (ParkRegion)existsRegionMap.remove(regionInfoEntry.getKey());
            ParkRegion newRegion = this.buildRegion(parkId, regionInfo);
            if (existsRegion == null) {
                if (regionInfo.getRegionType() == 0) {
                    outerRegions.add(newRegion);
                } else {
                    innerRegions.add(newRegion);
                }
            } else {
                newRegion.setId(existsRegion.getId());
                updateRegions.add(newRegion);
            }
            newRegionMap.put(regionInfo.getRegionCode(), newRegion);
        }
        if (!outerRegions.isEmpty()) {
            this.parkRegionService.saveBatch(outerRegions);
        }
        if (!innerRegions.isEmpty()) {
            for (ParkRegion innerRegion : innerRegions) {
                ParkRegion outerRegion = (ParkRegion)newRegionMap.get(innerRegion.getParentCode());
                if (outerRegion == null) {
                    throw new ResponseBodyException("400", "\u533a\u57df[" + innerRegion.getRegionCode() + "]\u5bf9\u5e94\u7236\u533a\u57df[" + innerRegion.getParentCode() + "]\u4e0d\u5b58\u5728");
                }
                innerRegion.setFatherRelationId(outerRegion.getId());
            }
            this.parkRegionService.saveBatch(innerRegions);
        }
        if (!updateRegions.isEmpty()) {
            for (ParkRegion updateRegion : updateRegions) {
                if (updateRegion.getRegionType() != 2) continue;
                ParkRegion region = (ParkRegion)newRegionMap.get(updateRegion.getParentCode());
                if (region == null) {
                    throw new ResponseBodyException("400", "\u533a\u57df[" + updateRegion.getRegionCode() + "]\u5bf9\u5e94\u7236\u533a\u57df[" + updateRegion.getParentCode() + "]\u4e0d\u5b58\u5728");
                }
                updateRegion.setFatherRelationId(region.getId());
            }
            this.parkRegionService.updateBatchById(updateRegions);
        }
        if (!existsRegionMap.isEmpty()) {
            List regionIds = existsRegionMap.values().stream().map(ParkRegion::getId).collect(Collectors.toList());
            log.info("\u5220\u9664\u533a\u57df\u4fe1\u606f|{}", regionIds);
            this.parkRegionService.removeByIds(regionIds);
        }
        return newRegionMap;
    }

    private void handleRegionCharge(long parkId, Map<String, ParkingFacilitiesUpRequest> regionInfoMap, Map<String, ParkRegion> regionMap) {
        ObjectResponse<List<ParkChargeconfig>> parkChargeConfigResp = this.chargeService.getConfigs(parkId);
        Map parkChargeConfigMap = parkChargeConfigResp.getData() == null ? Collections.emptyMap() : ((List)parkChargeConfigResp.getData()).stream().collect(Collectors.toMap(ParkChargeconfig::getBilltypecode, Function.identity()));
        LinkedList<RegionChargeconfig> chargeConfigs = new LinkedList<RegionChargeconfig>();
        for (Map.Entry<String, ParkingFacilitiesUpRequest> regionInfoEntry : regionInfoMap.entrySet()) {
            RegionChargeconfig chargeConfig;
            ParkingFacilitiesUpRequest regionInfo = regionInfoEntry.getValue();
            ParkRegion region = regionMap.get(regionInfo.getRegionCode());
            int regionId = region.getId().intValue();
            if (StringUtils.isNotBlank((CharSequence)regionInfo.getDefaultBill())) {
                chargeConfig = this.buildChargeConfig(regionId, 0, (ParkChargeconfig)parkChargeConfigMap.get(regionInfo.getDefaultBill()));
                chargeConfig.setDefaultCharge(Integer.valueOf(1));
                chargeConfigs.add(chargeConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)regionInfo.getBlueCarBill())) {
                chargeConfig = this.buildChargeConfig(regionId, 3, (ParkChargeconfig)parkChargeConfigMap.get(regionInfo.getBlueCarBill()));
                chargeConfigs.add(chargeConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)regionInfo.getYellowCarBill())) {
                chargeConfig = this.buildChargeConfig(regionId, 4, (ParkChargeconfig)parkChargeConfigMap.get(regionInfo.getYellowCarBill()));
                chargeConfigs.add(chargeConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)regionInfo.getFixedCarBill())) {
                chargeConfig = this.buildChargeConfig(regionId, 5, (ParkChargeconfig)parkChargeConfigMap.get(regionInfo.getFixedCarBill()));
                chargeConfigs.add(chargeConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)regionInfo.getStoredCardBill())) {
                chargeConfig = this.buildChargeConfig(regionId, 6, (ParkChargeconfig)parkChargeConfigMap.get(regionInfo.getStoredCardBill()));
                chargeConfigs.add(chargeConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)regionInfo.getNewEnergyCarBill())) {
                chargeConfig = this.buildChargeConfig(regionId, 1, (ParkChargeconfig)parkChargeConfigMap.get(regionInfo.getNewEnergyCarBill()));
                chargeConfigs.add(chargeConfig);
            }
            if (!StringUtils.isNotBlank((CharSequence)regionInfo.getNewEnergyPureEleCarBill())) continue;
            chargeConfig = this.buildChargeConfig(regionId, 7, (ParkChargeconfig)parkChargeConfigMap.get(regionInfo.getNewEnergyPureEleCarBill()));
            chargeConfigs.add(chargeConfig);
        }
        this.regionChargeConfigService.remove((Wrapper)Wrappers.lambdaQuery(RegionChargeconfig.class).eq(RegionChargeconfig::getParkId, (Object)parkId));
        if (!chargeConfigs.isEmpty()) {
            this.regionChargeConfigService.saveBatch(chargeConfigs);
        }
    }

    private Map<String, ParkInoutdevice> handleChannel(long parkId, Map<String, ParkingFacilitiesUpRequest.ChannelInfo> channelInfoMap, Map<String, ParkRegion> regionMap, Set<String> cacheKeys) {
        List existsChannels = this.parkInoutDeviceService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkInoutdevice.class).eq(ParkInoutdevice::getParkId, (Object)parkId)).eq(ParkInoutdevice::getStatus, (Object)0));
        Map existsChannelMap = existsChannels.stream().collect(Collectors.toMap(ParkInoutdevice::getInandoutCode, Function.identity()));
        LinkedList<ParkInoutdevice> addChannels = new LinkedList<ParkInoutdevice>();
        LinkedList<ParkInoutdevice> updateChannels = new LinkedList<ParkInoutdevice>();
        HashMap<String, ParkInoutdevice> newChannelMap = new HashMap<String, ParkInoutdevice>();
        for (Map.Entry<String, ParkingFacilitiesUpRequest.ChannelInfo> channelInfoEntry : channelInfoMap.entrySet()) {
            ParkingFacilitiesUpRequest.ChannelInfo channelInfo = channelInfoEntry.getValue();
            ParkRegion region = regionMap.get(channelInfo.getRegionCode());
            if (region == null) {
                throw new ResponseBodyException("400", "\u901a\u9053[" + channelInfo.getInandoutCode() + "]\u5bf9\u5e94\u533a\u57df[" + channelInfo.getRegionCode() + "]\u4e0d\u5b58\u5728");
            }
            ParkInoutdevice existsChannel = (ParkInoutdevice)existsChannelMap.remove(channelInfoEntry.getKey());
            ParkInoutdevice newChannel = this.buildChannel(parkId, channelInfo);
            newChannel.setRegionId(region.getId());
            if (existsChannel == null) {
                addChannels.add(newChannel);
            } else {
                newChannel.setId(existsChannel.getId());
                updateChannels.add(newChannel);
                cacheKeys.add("park:channel:id:" + existsChannel.getId());
                cacheKeys.add("park:channel:code:" + existsChannel.getInandoutCode());
                cacheKeys.add("gray:park:channel:id:" + existsChannel.getId());
                cacheKeys.add("gray:park:channel:code:" + existsChannel.getInandoutCode());
            }
            newChannelMap.put(channelInfo.getInandoutCode(), newChannel);
        }
        if (!addChannels.isEmpty()) {
            this.parkInoutDeviceService.saveBatch(addChannels);
        }
        if (!updateChannels.isEmpty()) {
            this.parkInoutDeviceService.updateBatchById(updateChannels);
        }
        if (!existsChannelMap.isEmpty()) {
            List channelIds = existsChannelMap.values().stream().map(channel -> {
                cacheKeys.add("park:channel:id:" + channel.getId());
                cacheKeys.add("park:channel:code:" + channel.getInandoutCode());
                cacheKeys.add("gray:park:channel:id:" + channel.getId());
                cacheKeys.add("gray:park:channel:code:" + channel.getInandoutCode());
                return channel.getId();
            }).collect(Collectors.toList());
            log.info("\u5220\u9664\u901a\u9053\u4fe1\u606f|{}", channelIds);
            this.parkInoutDeviceService.removeByIds(channelIds);
        }
        return newChannelMap;
    }

    private Map<String, ParkDevice> handleDevice(long parkId, Map<String, ParkingFacilitiesUpRequest.DeviceInfo> deviceInfoMap, Map<String, ParkInoutdevice> channelMap, Set<String> cacheKeys) {
        List devices = this.parkDeviceService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkDevice.class).eq(ParkDevice::getParkId, (Object)parkId)).eq(ParkDevice::getDelFlag, (Object)0));
        Map existsDeviceMap = devices.stream().collect(Collectors.toMap(ParkDevice::getDeviceNo, Function.identity()));
        LinkedList<ParkDevice> addDevices = new LinkedList<ParkDevice>();
        LinkedList<ParkDevice> updateDevices = new LinkedList<ParkDevice>();
        HashMap<String, ParkDevice> newDeviceMap = new HashMap<String, ParkDevice>();
        for (Map.Entry<String, ParkingFacilitiesUpRequest.DeviceInfo> deviceInfoEntry : deviceInfoMap.entrySet()) {
            ParkingFacilitiesUpRequest.DeviceInfo deviceInfo = deviceInfoEntry.getValue();
            ParkInoutdevice channel = channelMap.get(deviceInfo.getInandoutCode());
            if (channel == null) {
                throw new ResponseBodyException("400", "\u8bbe\u5907[" + deviceInfo.getDeviceCode() + "]\u5bf9\u5e94\u901a\u9053[" + deviceInfo.getInandoutCode() + "]\u4e0d\u5b58\u5728");
            }
            ParkDevice existsDevice = (ParkDevice)existsDeviceMap.get(deviceInfoEntry.getKey());
            ParkDevice newDevice = this.buildDevice(parkId, deviceInfo);
            newDevice.setChannelId(Integer.valueOf(channel.getId().intValue()));
            if (existsDevice == null) {
                addDevices.add(newDevice);
                continue;
            }
            newDevice.setId(existsDevice.getId());
            updateDevices.add(newDevice);
            cacheKeys.add("park:device:serial_number:" + existsDevice.getSerialNumber());
        }
        if (!addDevices.isEmpty()) {
            this.parkDeviceService.saveBatch(addDevices);
        }
        if (!updateDevices.isEmpty()) {
            this.parkDeviceService.updateBatchById(updateDevices);
        }
        if (!existsDeviceMap.isEmpty()) {
            List deviceIds = existsDeviceMap.values().stream().map(device -> {
                cacheKeys.add("park:device:serial_number:" + device.getSerialNumber());
                return device.getId();
            }).collect(Collectors.toList());
            log.info("\u5220\u9664\u8bbe\u5907\u4fe1\u606f|{}", deviceIds);
            this.parkDeviceService.removeByIds(deviceIds);
        }
        return newDeviceMap;
    }

    private ParkRegion buildRegion(long parkId, ParkingFacilitiesUpRequest request) {
        ParkRegion region = new ParkRegion();
        region.setRegionCode(request.getRegionCode());
        region.setRegionName(request.getRegionName());
        region.setParkId(Long.valueOf(parkId));
        region.setRegionType(Integer.valueOf(request.getRegionType() == 0 ? 1 : 2));
        if (request.getRegionType() == 0) {
            region.setFatherRelationId(Long.valueOf(0L));
        } else {
            region.setParentCode(request.getParentCode());
        }
        region.setRegionPark(request.getRegionTotalPark());
        region.setFreePark(request.getFreeSpace());
        region.setStatus(Integer.valueOf(0));
        region.setDefaultName(request.getRegionType());
        region.setIsNewEnergyDiffBill(request.getIsNewEnergyDiffBill());
        region.setIsFullForbidenter(request.getIsFullForbidEnter());
        region.setIsFullForbidMonthEnter(request.getIsFullForbidMonthEnter());
        region.setIsFullForbidVIPEnter(request.getIsFullForbidVIPEnter());
        region.setIsFullForbidReservEnter(request.getIsFullForbidReservEnter());
        region.setIsFullForbidStoreEnter(request.getIsFullForbidStoreEnter());
        region.setVipCarTypeId(request.getVipCarType());
        region.setIsFullForbidblackenter(request.getIsFullForbidBlackEnter());
        region.setFullEmptynum(request.getFullEmptyNum());
        return region;
    }

    private RegionChargeconfig buildChargeConfig(int regionId, int plateType, ParkChargeconfig parkChargeConfig) {
        if (parkChargeConfig == null) {
            throw new ResponseBodyException("404", "\u672a\u77e5\u8ba1\u8d39\u89c4\u5219");
        }
        RegionChargeconfig config = new RegionChargeconfig();
        config.setParkId(parkChargeConfig.getParkId());
        config.setRegionId(Integer.valueOf(regionId));
        config.setBilltypecode(parkChargeConfig.getBilltypecode());
        config.setBilltype(parkChargeConfig.getBilltype());
        config.setDefaultCharge(Integer.valueOf(0));
        config.setLicensePlateType(Integer.valueOf(plateType));
        config.setStatus(Integer.valueOf(0));
        return config;
    }

    private ParkInoutdevice buildChannel(long parkId, ParkingFacilitiesUpRequest.ChannelInfo info) {
        ParkInoutdevice channel = new ParkInoutdevice();
        channel.setParkId(Long.valueOf(parkId));
        channel.setInandoutCode(info.getInandoutCode());
        channel.setInandoutName(info.getInandoutName());
        channel.setInandoutType(info.getInandoutType());
        channel.setStatus(Integer.valueOf(0));
        channel.setIsAllowTempcarrun(info.getIsAllowTempcarrun());
        channel.setIsAllowNocardrun(info.getIsAllowNocardrun());
        channel.setIsAllowYellowcarrun(info.getIsAllowYellowcarrun());
        channel.setIsOpenVaguetype(info.getIsOpenVaguetype());
        channel.setVaguetype(info.getVagueType());
        channel.setIsOpenQrcodetype(info.getIsOpenQrcodetype());
        channel.setIsAllowNewenergycarrun(info.getIsAllowNewenergycarrun());
        channel.setIsAllowVisitCar(info.getIsAllowVisitCar());
        channel.setIsAllowMonthCar(info.getIsAllowMonthCar());
        channel.setIsAllowOvertimeCar(info.getIsOverTimeMonth());
        channel.setOverTimeDay(info.getOverTimeDay());
        channel.setOverTimeMonthlyCard(info.getOverTimeMonthlyCard());
        channel.setIsAllowBackCar(info.getIsAllowBackCar());
        channel.setIsAllowVipCar(info.getIsVipCar());
        channel.setIsAllowAbcar(info.getIsAllowABcar());
        channel.setIsFee(info.getIsCharge());
        channel.setIsMaster(info.getIsMaster());
        channel.setIsAllowBluerun(info.getIsAllowBluerun());
        channel.setIsAllowStoredCar(info.getIsAllowStoredCar());
        return channel;
    }

    private ParkDevice buildDevice(long parkId, ParkingFacilitiesUpRequest.DeviceInfo info) {
        ParkDevice device = new ParkDevice();
        device.setParkId(Long.valueOf(parkId));
        device.setDeviceNo(info.getDeviceCode());
        device.setType(info.getType());
        device.setSerialNumber(info.getSerialNumber());
        device.setIp(info.getIp());
        device.setPort(info.getPort() == null ? null : info.getPort().toString());
        device.setStatus(Integer.valueOf(0));
        device.setDelFlag(Integer.valueOf(0));
        if (info.getDualCamera() == null || info.getDualCamera() == 0) {
            device.setIsDualcamera(Integer.valueOf(0));
            device.setIsMaster(Integer.valueOf(1));
        } else {
            if (info.getIsMaster() == null) {
                throw new ResponseBodyException("400", "\u7f3a\u5c11\u662f\u5426\u4e3a\u4e3b\u76f8\u673a");
            }
            device.setIsDualcamera(info.getDualCamera());
            device.setIsMaster(info.getIsMaster());
        }
        return device;
    }
}

