/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkStatusRequest;
import com.icetech.cloudcenter.domain.request.pnc.RegionParkInfoRequest;
import com.icetech.cloudcenter.domain.response.pnc.ParkStatusResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.factory.UpdateFreeSpaceServiceFactory;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkStatusServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    private static Long TIMEOUT_SECONDS = 70L;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private UpdateFreeSpaceServiceFactory updateFreeSpaceServiceFactory;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ObjectResponse inOutDeviceByCode;
        ParkStatusRequest parkStatusRequest = (ParkStatusRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), ParkStatusRequest.class);
        this.verifyParams(parkStatusRequest);
        Long cloudTime = DateTools.unixTimestamp();
        if (parkStatusRequest.getChannelId() != null && ObjectResponse.isSuccess((Response)(inOutDeviceByCode = this.parkService.getInOutDeviceByCode(parkId, parkStatusRequest.getChannelId())))) {
            this.redisUtils.set("PNC_ONLINE_CHANNEL_" + dataCenterBaseRequest.getParkCode(), (Object)parkStatusRequest.getChannelId(), TIMEOUT_SECONDS.longValue());
        }
        String hkey = String.valueOf(parkId);
        this.redisUtils.hPut("pnc:heartbeat:time", hkey, (Object)cloudTime);
        this.redisUtils.hPut("pnc:version", hkey, (Object)dataCenterBaseRequest.getVersionNum());
        this.redisUtils.hPut("pnc:protocol", hkey, (Object)NumberUtils.toPrimitive((Integer)parkStatusRequest.getProtocol(), (int)1));
        Integer emptyNumber = parkStatusRequest.getEmptyNumber();
        if (CollectionUtils.isNotEmpty((Collection)parkStatusRequest.getRegionParkInfo())) {
            List regionCodes = parkStatusRequest.getRegionParkInfo().stream().map(RegionParkInfoRequest::getRegionCode).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(regionCodes)) {
                Map<String, Integer> paramMap = parkStatusRequest.getRegionParkInfo().stream().filter(Objects::nonNull).collect(Collectors.toMap(RegionParkInfoRequest::getRegionCode, RegionParkInfoRequest::getRegionEmptyNumber));
                List parkRegions = this.parkRegionDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRegion.class).eq(ParkRegion::getParkId, (Object)parkId)).eq(ParkRegion::getStatus, (Object)0)).in(ParkRegion::getRegionCode, regionCodes));
                if (CollectionUtils.isNotEmpty((Collection)parkRegions)) {
                    for (ParkRegion parkRegion2 : parkRegions) {
                        Integer freePark = paramMap.get(parkRegion2.getRegionCode());
                        if (freePark == null || freePark.equals(parkRegion2.getFreePark())) continue;
                        ParkRegion parkRegionUpdate = new ParkRegion();
                        parkRegionUpdate.setId(parkRegion2.getId());
                        parkRegionUpdate.setFreePark(freePark);
                        parkRegionUpdate.setRealFreePark(freePark);
                        this.parkRegionDao.updateById((Object)parkRegionUpdate);
                    }
                }
                this.parkFreespaceDao.updateFreeSpaceByPark(parkId.longValue(), emptyNumber.intValue());
            }
        } else if (emptyNumber != null) {
            List parkRegions = this.parkRegionDao.selectByParkid(parkId);
            Long regionId = null;
            if (CollectionUtils.isNotEmpty((Collection)parkRegions)) {
                Optional<ParkRegion> first = parkRegions.stream().filter(parkRegion -> !Long.valueOf(0L).equals(parkRegion.getFatherRelationId())).findFirst();
                if (first.isPresent()) {
                    ParkFreespace parkFreespace = new ParkFreespace();
                    parkFreespace.setParkId(parkId);
                    parkFreespace = (ParkFreespace)this.parkFreespaceDao.selectLimitOne((Object)parkFreespace);
                    if (parkFreespace != null) {
                        emptyNumber = NumberUtils.toPrimitive((Integer)parkFreespace.getTotalNum()) - NumberUtils.toPrimitive((Integer)first.get().getFreePark());
                    }
                } else {
                    regionId = ((ParkRegion)parkRegions.get(0)).getId();
                }
            }
            UpdateFreeSpaceService updateFreeSpaceService = this.updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
            updateFreeSpaceService.updateFreeSpace(parkId, regionId, emptyNumber.intValue());
        }
        ParkStatusResponse parkStatusResponse = new ParkStatusResponse();
        Park park = this.getParkByParkId(parkId).orElse((Park)new Park().setChargeCarSpace(Integer.valueOf(0)));
        parkStatusResponse.setChargeCarSpace(park.getChargeCarSpace() == null ? 0 : park.getChargeCarSpace());
        parkStatusResponse.setTotalPark(park.getTotalPark());
        parkStatusResponse.setTime(cloudTime);
        return ObjectResponse.success((Object)parkStatusResponse);
    }

    private Optional<Park> getParkByParkId(Long parkId) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            Park park = (Park)parkObjectResponse.getData();
            if (Objects.nonNull(park)) {
                return Optional.of(park);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

