/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.area.AreaProvinceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.AreaProvince;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkConfigUpRequest;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.park.impl.ParkConfigServiceImpl;
import com.icetech.park.service.park.impl.ParkFreeSpaceServiceImpl;
import com.icetech.park.service.park.impl.ParkGuideServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.SendInfoServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParkConfigUpServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ParkConfigUpServiceImpl.class);
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkConfigServiceImpl parkConfigService;
    @Autowired
    private ParkFreeSpaceServiceImpl parkFreeSpaceService;
    @Autowired
    private AreaProvinceDao areaProvinceDao;
    @Autowired
    private ParkGuideServiceImpl parkGuideService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Override
    @Transactional
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) throws Exception {
        if (baseRequest.getBizContent() == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        ParkConfigUpRequest request = (ParkConfigUpRequest)JsonUtils.convert2bean((Object)baseRequest.getBizContent(), ParkConfigUpRequest.class);
        if (request == null || StringUtils.isBlank((CharSequence)request.getParkName())) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        ObjectResponse parkResp = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)parkResp);
        ObjectResponse parkConfigResp = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)parkConfigResp);
        ObjectResponse<ParkFreespace> spaceResp = this.parkFreeSpaceService.getSpaceByPark(parkId);
        ObjectResponse.notError(spaceResp);
        Park park = (Park)parkResp.getData();
        ParkConfig parkConfig = (ParkConfig)parkConfigResp.getData();
        ParkFreespace space = (ParkFreespace)spaceResp.getData();
        AreaProvince province = (AreaProvince)this.areaProvinceDao.selectLimitOne((LambdaQueryWrapper)Wrappers.lambdaQuery(AreaProvince.class).eq(AreaProvince::getAbbr, (Object)request.getProvinceName()));
        if (province == null) {
            throw new ResponseBodyException("400", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7701\u4efd\u4fe1\u606f");
        }
        ParkRegion parkRegion = this.parkRegionDao.selectOutByParkid(parkId);
        if (parkRegion == null) {
            throw new ResponseBodyException("400", "\u627e\u4e0d\u5230\u5bf9\u5e94\u533a\u57df\u4fe1\u606f");
        }
        Park newPark = this.buildPark(request);
        newPark.setId(parkId);
        newPark.setProvinceId(province.getId());
        ParkConfig newParkConfig = this.buildParkConfig(request);
        newParkConfig.setId(parkConfig.getId());
        ParkFreespace newSpace = this.buildParkFreespace(request);
        newSpace.setId(space.getId());
        ParkRegion newRegion = this.buildRegion(request);
        newRegion.setId(parkRegion.getId());
        this.parkService.updateById((Object)newPark);
        this.parkConfigService.updateById(newParkConfig);
        this.parkFreeSpaceService.updateById(newSpace);
        this.parkRegionDao.updateById((Object)newRegion);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(parkId);
        guide.setStep(Integer.valueOf(1));
        this.parkGuideService.updateByParkId(guide);
        this.sendInfoService.save((Object)SendInfo.buildUnneeded((Long)parkId, (Long)newParkConfig.getId(), (Integer)DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceType(), (String)"\u672c\u5730\u4e0a\u62a5"));
        this.parkService.removeParkParamFromRedis(park.getParkCode(), park.getId());
        return ObjectResponse.success();
    }

    private Park buildPark(ParkConfigUpRequest request) {
        Park park = new Park();
        park.setParkName(request.getParkName());
        park.setTotalPark(request.getTotalPark());
        park.setSwitchFeeTime(request.getSwitchFreeTime());
        int isInterior = NumberUtils.toPrimitive((Integer)request.getIsMidfield(), (int)0) == 1 ? 1 : 0;
        park.setIsInterior(Integer.valueOf(isInterior));
        park.setNestType(Integer.valueOf(isInterior == 1 ? 3 : 0));
        return park;
    }

    private ParkConfig buildParkConfig(ParkConfigUpRequest request) {
        ParkConfig config = new ParkConfig();
        config.setBillPrecision(request.getBilPrecision());
        config.setIsfreeSpecialcar(request.getIsFreeSpecialCar());
        config.setIssupAbmanage(request.getIsMultipleVehicles());
        config.setSwitchTm(request.getMultipleTime());
        config.setSwitchType(request.getMultipleBillType());
        config.setIsreleaseFreetm(request.getIsReleaseFreetm());
        config.setIsEpayment(request.getIsEpayMent());
        config.setIsNosenpayment(request.getIsNosenPayMent());
        config.setIsfreeAfterpay(request.getFreeTimeAfterPay());
        config.setFreetimeStatus(request.getFreeTimeStatus());
        config.setIsFilltime(request.getIsFillTime());
        config.setOvertimeBillType(request.getOverTimeBillType());
        config.setIsallowfreetmonce(request.getIsAllowFreeTmonce());
        config.setIsnotgetsmallchange(request.getIsRounding());
        config.setIsfixedfees(request.getIsFixedFee());
        config.setFixedfeevalue(request.getFixedFeeValue());
        config.setFixedFeeValueBig(request.getFixedFeeValueBig());
        config.setChargeVersionNum(Integer.valueOf(request.getBillVersion() == null ? 0 : request.getBillVersion() - 1));
        config.setMoneyunitType(request.getMonetaryUnit());
        config.setIsCardcount(request.getIsCarDcount());
        config.setIsSpecialPark(Integer.valueOf(request.getIsInOutPass() == 1 ? 1 : 0));
        config.setEnexMinTime(request.getEnexMinTime());
        config.setExenMinTime(request.getExenMinTime());
        config.setDisplayTerminal(request.getScreenType());
        config.setLedcardType(request.getCtrlCardModel());
        config.setTtsType(Integer.valueOf(request.getIsSupportTTS() == 1 ? 1 : 0));
        config.setDualcameraTime(request.getDualCameraTime());
        config.setVisitIscharge(request.getVisitIscharge());
        config.setIsNocardCheck(request.getIsNocardCheck());
        config.setIsExpireMc(Integer.valueOf(NumberUtils.toPrimitive((Integer)request.getOverTimeMonthlyCard())));
        config.setExpireMcDays(request.getExpireMcDays());
        config.setIsAllowOvertimeCar(Integer.valueOf(NumberUtils.toPrimitive((Integer)request.getIsOverTimeMonth())));
        config.setOverTimeDay(request.getOverTimeDay());
        config.setFreeCarReenter(request.getFreeCarReenter());
        config.setCalcSpaceMethod(request.getCalcSpaceMethod());
        config.setPlateFilterType(request.getPlateFilterType());
        config.setFilterTime(request.getFilterTime());
        return config;
    }

    private ParkFreespace buildParkFreespace(ParkConfigUpRequest request) {
        ParkFreespace space = new ParkFreespace();
        space.setFreeSpace(request.getFreePark());
        space.setRealFreeSpace(request.getFreePark());
        space.setTotalNum(request.getTotalPark());
        return space;
    }

    private ParkRegion buildRegion(ParkConfigUpRequest request) {
        ParkRegion parkRegion = new ParkRegion();
        parkRegion.setIsFullForbidenter(request.getIsFullForbidEnter());
        parkRegion.setIsFullForbidMonthEnter(request.getIsFullForbidMonthEnter());
        parkRegion.setIsFullForbidVIPEnter(request.getIsFullForbidVIPEnter());
        parkRegion.setIsFullForbidReservEnter(request.getIsFullForbidReservEnter());
        parkRegion.setIsFullForbidStoreEnter(request.getIsFullForbidStoreEnter());
        parkRegion.setFullEmptynum(request.getFullEmptyNum());
        parkRegion.setIsFullForbidblackenter(request.getIsFullForbidBlackEnter());
        parkRegion.setVipCarTypeId(request.getVipCarTypeId());
        return parkRegion;
    }
}

