/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.PaidInfoRequest;
import com.icetech.cloudcenter.domain.response.pnc.PaidInfoResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaidInfoServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private PublicHandle publicHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        PaidInfoRequest paidInfoRequest = (PaidInfoRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), PaidInfoRequest.class);
        this.verifyParams(paidInfoRequest);
        List<OrderPay> orderPays = this.getOrderPays(parkId, paidInfoRequest);
        ArrayList<PaidInfoResponse> paidInfoResponses = new ArrayList<PaidInfoResponse>();
        for (int i = 0; i < orderPays.size(); ++i) {
            OrderPay orderPay1 = orderPays.get(i);
            PaidInfoResponse paidInfoResponse = new PaidInfoResponse();
            BeanUtils.copyProperties((Object)orderPay1, (Object)paidInfoResponse);
            paidInfoResponses.add(paidInfoResponse);
        }
        if (paidInfoResponses.size() <= 0) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success(paidInfoResponses);
    }

    private List<OrderPay> getOrderPays(Long parkId, PaidInfoRequest paidInfoRequest) {
        String orderId = paidInfoRequest.getOrderId();
        String orderNum = this.publicHandle.convert2OrderNum(parkId, orderId);
        PageQuery payPageQuery = new PageQuery();
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(parkId);
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(Integer.valueOf(2));
        payPageQuery.setParam((Object)orderPay);
        ObjectResponse objectResponse = this.orderPayService.findList(payPageQuery);
        ObjectResponse.notError((Response)objectResponse);
        return (List)objectResponse.getData();
    }
}

