/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.OrderTraceUploadRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.order.impl.OrderServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderTrackUploadServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        OrderTraceUploadRequest orderTraceUploadRequest = (OrderTraceUploadRequest)JSON.parseObject((String)JSON.toJSONString((Object)dataCenterBaseRequest.getBizContent()), OrderTraceUploadRequest.class);
        ParkRegion region = this.parkRegionDao.getRegionByCode(parkId, orderTraceUploadRequest.getRegionCode());
        if (region == null) {
            return ObjectResponse.failed((String)"400", (String)"\u533a\u57df\u4e0d\u5b58\u5728");
        }
        ParkInoutdevice channel = this.parkService.getChannelByCodeAndParkId(parkId, orderTraceUploadRequest.getChannelCode());
        if (channel == null) {
            return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u4e0d\u5b58\u5728");
        }
        OrderInfo orderInfo = (OrderInfo)this.orderService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)this.orderService.getLambdaQueryWrapper().eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getLocalOrderNum, (Object)orderTraceUploadRequest.getOrderId()));
        if (orderInfo == null) {
            return ObjectResponse.failed((String)"400", (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (orderInfo.getHasSon() == 1 && (orderInfo = (OrderInfo)this.orderSonInfoService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)this.orderSonInfoService.getLambdaQueryWrapper().eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getRegionId, (Object)region.getId())).eq(OrderInfo::getLocalOrderNum, (Object)orderTraceUploadRequest.getOrderId()))) == null) {
            return ObjectResponse.failed((String)"400", (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OrderTrack orderTrack = new OrderTrack();
        orderTrack.setParkId(parkId);
        orderTrack.setRegionId(region.getId());
        orderTrack.setOrderNum(orderInfo.getOrderNum());
        orderTrack.setRecordType(orderTraceUploadRequest.getRecordType());
        orderTrack.setEnexTime(orderTraceUploadRequest.getEnexTime());
        OrderTrack existsOrderTrack = (OrderTrack)this.orderTrackService.selectLimitOne((Object)orderTrack);
        if (existsOrderTrack != null) {
            return ObjectResponse.failed((String)"405", (String)"\u8ba2\u5355\u8f68\u8ff9\u5df2\u5b58\u5728");
        }
        orderTrack.setChannelName(channel.getInandoutName());
        orderTrack.setPlateNum(orderInfo.getPlateNum());
        orderTrack.setType(orderInfo.getType());
        orderTrack.setImage(orderTraceUploadRequest.getImage());
        orderTrack.setInoutEvent(Integer.valueOf(orderTraceUploadRequest.getInoutEvent()));
        orderTrack.setOperAccount(orderTraceUploadRequest.getOperAccount());
        orderTrack.setExTerminal(orderTraceUploadRequest.getExTerminal());
        orderTrack.setOpenReason(orderTraceUploadRequest.getExceptionReason());
        orderTrack.setCreateTime(new Date());
        this.orderTrackService.save((Object)orderTrack);
        return ObjectResponse.success();
    }
}

