/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.icetech.basics.config.GrayProperties;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ModifyCtrlCardTypeRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.redis.handle.RedisHandle;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyCtrlCardTypeServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private GrayProperties grayProperties;
    @Resource
    private RedisHandle redisHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ModifyCtrlCardTypeRequest request = (ModifyCtrlCardTypeRequest)JSON.parseObject((String)JSON.toJSONString((Object)dataCenterBaseRequest.getBizContent()), ModifyCtrlCardTypeRequest.class);
        this.verifyParams(request);
        ObjectResponse deviceObj = this.parkService.getInoutDeviceByCode(request.getChannelCode());
        if (!ObjectResponse.isSuccess((Response)deviceObj)) {
            return ObjectResponse.failed((String)"400", (String)"\u901a\u9053\u4e0d\u5b58\u5728");
        }
        ParkInoutdevice inOutDevice = (ParkInoutdevice)deviceObj.getData();
        if (!inOutDevice.getLedcardType().equals(request.getCtrlCardType()) || !inOutDevice.getTtsType().equals(request.getTtsType())) {
            ParkInoutdevice update = new ParkInoutdevice();
            update.setId(inOutDevice.getId());
            update.setLedcardType(request.getCtrlCardType());
            update.setTtsType(request.getTtsType());
            this.parkInoutdeviceDao.updateById((Object)update);
            String cacheKey = "park:channel:code:" + inOutDevice.getInandoutCode();
            String cacheIdKey = "park:channel:id:" + inOutDevice.getId();
            if (this.grayProperties.isCacheEnable()) {
                cacheKey = "gray:" + cacheKey;
                cacheIdKey = "gray:" + cacheIdKey;
            }
            this.redisHandle.delete(cacheKey);
            this.redisHandle.delete(cacheIdKey);
        }
        return ObjectResponse.success();
    }
}

