/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkLicenseService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkLicenseRequest;
import com.icetech.cloudcenter.domain.response.ParkLicenseDto;
import com.icetech.cloudcenter.domain.response.pnc.LicenseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogonLicenceInfoServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkLicenseService parkLicenseService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ParkLicenseRequest parkLicenseRequest = (ParkLicenseRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), ParkLicenseRequest.class);
        this.verifyParams(parkLicenseRequest);
        LicenseResponse licenseResponse = new LicenseResponse();
        String license = this.getLicense(parkLicenseRequest.getLicenceInfo());
        if (StringUtils.isEmpty((CharSequence)license)) {
            licenseResponse.setLicenceStatus(2);
            return ObjectResponse.success((Object)licenseResponse);
        }
        ObjectResponse byParkCode = this.parkService.findByParkCode(dataCenterBaseRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)byParkCode)) {
            return ObjectResponse.failed((String)"404", (String)("\u672a\u627e\u5230\u8be5\u8f66\u573a[" + byParkCode + "]"));
        }
        ObjectResponse parkLicenseDto = this.parkLicenseService.registerParkLicense(((Park)byParkCode.getData()).getId(), license);
        ParkLicenseDto data = (ParkLicenseDto)parkLicenseDto.getData();
        licenseResponse.setLicenceStatus(data.getLicenceStatus());
        if (ObjectResponse.isSuccess((Response)parkLicenseDto)) {
            licenseResponse.setLicenceType(Integer.valueOf(data.getType()));
            licenseResponse.setEnablingTime(Long.valueOf(data.getEnableTime().getTime()));
            if (data.getType() == 2) {
                licenseResponse.setUseDays(Integer.valueOf(data.getUseDays()));
            }
        }
        return ObjectResponse.success((Object)licenseResponse);
    }

    private String getLicense(String plusSaltLicense) {
        String license = "";
        if (plusSaltLicense.length() == 40) {
            char[] chars = plusSaltLicense.toCharArray();
            StringBuffer sf = new StringBuffer();
            for (int i = 1; i < chars.length + 1; ++i) {
                if (i % 4 == 0) {
                    System.out.println(chars[i - 1]);
                    continue;
                }
                sf.append(chars[i - 1]);
            }
            license = sf.toString();
        } else if (plusSaltLicense.length() == 32) {
            // empty if block
        }
        return license;
    }

    public static void main(String[] args) {
        String s = "00bD5ead2c9R276207fr8b8Tbcaveae58cdp841X";
        System.out.println(s.length());
        char[] chars = s.toCharArray();
        StringBuffer sf = new StringBuffer();
        for (int i = 1; i < chars.length + 1; ++i) {
            if (i % 4 == 0) {
                System.out.println(chars[i - 1]);
                continue;
            }
            sf.append(chars[i - 1]);
        }
        System.out.println(sf.toString());
    }
}

