/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderExitService;
import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.cloudcenter.domain.request.ExitRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.mongo.document.ExitRecord;
import com.icetech.park.service.record.ExitRecordService;
import com.icetech.park.service.report.pnc.AbstractExitService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExitServiceImpl
extends AbstractExitService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ExitServiceImpl.class);
    @Autowired
    private OrderExitService orderExitService;
    @Autowired
    private RedisUtils redisUtils;
    @Resource
    private ExitRecordService exitRecordService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ExitRequest exitRequest = (ExitRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), ExitRequest.class);
        if (this.verifyParams((ExitCommonRequest)exitRequest)) {
            exitRequest.setParkId(parkId);
            this.addExitRecord(exitRequest);
            try {
                ObjectResponse objectResponse;
                String key3;
                String key2 = "QUERY_FEE_FAIL:" + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId();
                if (this.redisUtils.exists(key2)) {
                    this.redisUtils.remove(key2);
                }
                if (this.redisUtils.exists(key3 = "SWITCH_FAIL:" + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId())) {
                    this.redisUtils.remove(key3);
                }
                if ((objectResponse = this.orderExitService.exit(exitRequest, dataCenterBaseRequest.getParkCode())) == null) {
                    return ObjectResponse.failed((String)"500");
                }
                return objectResponse;
            }
            catch (ResponseBodyException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("[\u7aef\u7f51\u4e91]\u79bb\u573a\u4e0a\u62a5\u5904\u7406\u5931\u8d25", (Throwable)e);
                return ObjectResponse.failed((String)"500");
            }
        }
        return ObjectResponse.failed((String)"400");
    }

    private void addExitRecord(ExitRequest request) {
        ExitRecord record = new ExitRecord();
        BeanUtils.copyProperties((Object)request, (Object)record);
        record.setOrderNum(request.getOrderId());
        record.setImage(request.getExitImage());
        record.setSmallImage(request.getSmallImage());
        this.exitRecordService.saveRecordAsync(record);
    }
}

