/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExitPayCautionRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExitPayCautionServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CommonShowHandle commonShowHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ExitPayCautionRequest exitPayCautionRequest = (ExitPayCautionRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), ExitPayCautionRequest.class);
        this.verifyParams(exitPayCautionRequest);
        exitPayCautionRequest.setParkCode(dataCenterBaseRequest.getParkCode());
        String key1 = "PNC_EXIT_CHANNEL_PAY_" + parkId + "_" + exitPayCautionRequest.getChannelId();
        String key2 = "PNC_EXIT_ORDER_PAY_" + parkId + "_" + exitPayCautionRequest.getOrderId();
        ExitPayCautionRequest old = (ExitPayCautionRequest)this.redisUtils.get(key1, ExitPayCautionRequest.class);
        if (old != null) {
            String orderId = old.getOrderId();
            String oldOrder = "PNC_EXIT_ORDER_PAY_" + parkId + "_" + orderId;
            this.redisUtils.remove(oldOrder);
            this.redisUtils.remove(key1);
        }
        this.redisUtils.set(key1, (Object)exitPayCautionRequest, 1800L);
        this.redisUtils.set(key2, (Object)exitPayCautionRequest, 1800L);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("fee", exitPayCautionRequest.getUnpayPrice());
        String thirdPayUrl = this.commonShowHandle.getThirdPayUrl(parkId, dataCenterBaseRequest.getParkCode(), exitPayCautionRequest.getChannelId(), null, exitPayCautionRequest.getPlateNum(), param);
        if (StringUtils.isNotBlank((CharSequence)thirdPayUrl)) {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put("payQrCode", thirdPayUrl);
            return ObjectResponse.success(ret);
        }
        return ObjectResponse.success();
    }
}

