/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExceptionOpenRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExceptionOpenServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ExceptionOpenServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ExceptionOpenRequest exceptionOpenRequest = (ExceptionOpenRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), ExceptionOpenRequest.class);
        this.verifyParams(exceptionOpenRequest);
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        openingDtoRequest.setRecordType(exceptionOpenRequest.getEnexType());
        openingDtoRequest.setParkCode(dataCenterBaseRequest.getParkCode());
        openingDtoRequest.setPlateNum(exceptionOpenRequest.getPlateNum());
        openingDtoRequest.setExecuteTime(exceptionOpenRequest.getLiftTime());
        String openImage = exceptionOpenRequest.getOpenImage();
        String fileId = exceptionOpenRequest.getFileId();
        if (fileId != null) {
            String imgFileName = (String)this.redisUtils.get("PNC_FILEID_PROFILE_" + dataCenterBaseRequest.getParkCode() + fileId, String.class);
            openingDtoRequest.setImgUrl(imgFileName);
        } else {
            openingDtoRequest.setImgUrl(openImage);
        }
        openingDtoRequest.setAisleCode(exceptionOpenRequest.getChannelId());
        openingDtoRequest.setReasonType(exceptionOpenRequest.getOpenReason());
        openingDtoRequest.setOperAccount(exceptionOpenRequest.getOperAccount());
        openingDtoRequest.setSourcegate(exceptionOpenRequest.getOpenType());
        if (StringUtils.isNotBlank((CharSequence)exceptionOpenRequest.getOrderId())) {
            try {
                String orderNum = this.publicHandle.convert2OrderNum(parkId, exceptionOpenRequest.getOrderId());
                openingDtoRequest.setOrderNum(orderNum);
            }
            catch (ResponseBodyException e) {
                log.warn("\u8ba2\u5355\u4e0d\u5b58\u5728, {}", (Object)exceptionOpenRequest);
            }
        }
        return this.parkService.saveOpeningRecord(openingDtoRequest);
    }
}

