/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.EtcPermissionRequest;
import com.icetech.cloudcenter.domain.response.pnc.EtcPermissionResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class EtcPermissionServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(EtcPermissionServiceImpl.class);
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;

    public ObjectResponse<EtcPermissionResponse> report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        EtcPermissionRequest etcPermissionRequest = (EtcPermissionRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), EtcPermissionRequest.class);
        this.verifyParams(etcPermissionRequest);
        EtcPermissionResponse etcPermissionResponse = new EtcPermissionResponse();
        OrderInfo query = new OrderInfo();
        query.setLocalOrderNum(etcPermissionRequest.getOrderId());
        OrderInfo orderInfo = this.orderInfoDao.selectLimitOneOrderByEnterDesc(query);
        if (Objects.isNull(orderInfo) && (orderInfo = this.orderInfoDao.selectByOrderNum(etcPermissionRequest.getOrderId())) == null) {
            etcPermissionResponse.setEtcPay(Integer.valueOf(1));
            return ObjectResponse.success((Object)etcPermissionResponse);
        }
        String lock1 = (String)this.redisTemplate.opsForValue().get((Object)("PAY_LOCK_" + dataCenterBaseRequest.getParkCode() + orderInfo.getOrderNum()));
        String lock2 = (String)this.redisTemplate.opsForValue().get((Object)("lock:pay:after:" + orderInfo.getOrderNum()));
        log.info("[etc\u652f\u4ed8\u83b7\u53d6\u652f\u4ed8\u9501 orderNum {} lock {} {}]", new Object[]{orderInfo.getOrderNum(), lock1, lock2});
        if (StringUtils.isNotBlank((CharSequence)lock1) || StringUtils.isNotBlank((CharSequence)lock2)) {
            log.info("[etc\u652f\u4ed8\u6743\u9650\u6709\u5176\u4ed6\u652f\u4ed8\u6e20\u9053\u5728\u652f\u4ed8\u8be5\u8ba2\u5355 orderNum {} lock {} {}]", new Object[]{orderInfo.getOrderNum(), lock1, lock2});
            etcPermissionResponse.setEtcPay(Integer.valueOf(0));
        } else {
            etcPermissionResponse.setEtcPay(Integer.valueOf(1));
        }
        return ObjectResponse.success((Object)etcPermissionResponse);
    }
}

