/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderEnterService;
import com.icetech.cloudcenter.domain.request.EnterRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.mongo.document.EnterRecord;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.record.EnterRecordService;
import com.icetech.park.service.report.pnc.ReportService;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private OrderEnterService orderEnterService;
    @Resource
    private EnterRecordService enterRecordService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        EnterRequest enterRequest = (EnterRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), EnterRequest.class);
        this.verifyParams(enterRequest);
        enterRequest.setParkId(parkId);
        this.addEnterRecord(enterRequest);
        ObjectResponse objectResponse = this.orderEnterService.enter(enterRequest, dataCenterBaseRequest.getParkCode());
        if (objectResponse == null) {
            return ObjectResponse.failed((String)"500");
        }
        return objectResponse;
    }

    private void addEnterRecord(EnterRequest request) {
        EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties((Object)request, (Object)record);
        record.setOrderNum(request.getOrderId());
        record.setImage(request.getEnterImage());
        record.setSmallImage(request.getSmallImage());
        this.enterRecordService.saveRecordAsync(record);
    }
}

