/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkLicenseService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.response.AccessInfoDto;
import com.icetech.cloudcenter.domain.response.pnc.DownConnectResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DownConnectParamServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(DownConnectParamServiceImpl.class);
    private int VERSION_N = 1;
    private int VERSION_v = 2;
    @Autowired
    private ParkLicenseService parkLicenseService;
    @Value(value="${cloudcenter.license.dsttopic}")
    private String dstTopic;
    @Value(value="${cloudcenter.license.clientid}")
    private String clientId;
    @Value(value="${cloudcenter.license.endpoint}")
    private String endPoint;
    @Value(value="${cloudcenter.license.bucketname}")
    private String bucketName;
    @Value(value="${cloudcenter.license.servaddr}")
    private String servAddr;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        String versionNum = dataCenterBaseRequest.getVersionNum();
        ObjectResponse accessInfoByType = null;
        if (versionNum.startsWith("n") || versionNum.startsWith("N")) {
            accessInfoByType = this.parkLicenseService.getAccessInfoByType(this.VERSION_N);
        } else if (versionNum.startsWith("v") || versionNum.startsWith("V")) {
            accessInfoByType = this.parkLicenseService.getAccessInfoByType(this.VERSION_v);
        } else {
            return ObjectResponse.failed((String)"400", (String)"\u7248\u672c\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (ObjectResponse.isSuccess((Response)accessInfoByType)) {
            DownConnectResponse licenseResponse = new DownConnectResponse();
            AccessInfoDto data = (AccessInfoDto)accessInfoByType.getData();
            licenseResponse.setAccessKeyId(DownConnectParamServiceImpl.salt(data.getAccessKeyId()));
            licenseResponse.setAccessKeySecret(DownConnectParamServiceImpl.salt(data.getAccessKeySecret()));
            licenseResponse.setDstTopic(this.dstTopic);
            licenseResponse.setClienTid(this.clientId);
            licenseResponse.setBucketName(this.bucketName);
            licenseResponse.setEndPoint(this.endPoint);
            licenseResponse.setServAddr(this.servAddr);
            return ObjectResponse.success((Object)licenseResponse);
        }
        return ObjectResponse.failed((String)"500");
    }

    public static String salt(String license) {
        String salt = "0123456789abcdefghijklmnopqrstuvwxyz";
        int charLength = salt.length();
        Random random = new Random();
        char[] chars1 = salt.toCharArray();
        char[] chars = license.toCharArray();
        StringBuffer sf = new StringBuffer();
        int key = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (key % 3 == 0 && key != 0) {
                int i1 = random.nextInt(charLength);
                System.out.println(chars1[i1]);
                sf.append(chars1[i1]);
            }
            ++key;
            sf.append(chars[i]);
        }
        sf.append(chars1[random.nextInt(charLength)]);
        return sf.toString();
    }

    public static void main(String[] args) {
        String pass = "50b99cf8803544808738f5976dfb6666#1qa2ws3ed4rf";
        try {
            System.out.println(DigestUtils.md5Hex((String)pass));
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
        }
        String charStr = "0123456789abcdefghijklmnopqrstuvwxyz";
        String s = "LTAI4Feik71ksCdPWrfpPcpf";
        int charLength = charStr.length();
        Random random = new Random();
        char[] chars1 = charStr.toCharArray();
        char[] chars = s.toCharArray();
        StringBuffer sf = new StringBuffer();
        int key = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (key % 3 == 0 && key != 0) {
                int i1 = random.nextInt(charLength);
                System.out.println(chars1[i1]);
                sf.append("#");
            }
            ++key;
            sf.append(chars[i]);
        }
        sf.append("#");
        System.out.println(sf.toString());
    }
}

