/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.dao.device.HeartbeatOfflineDao;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.DeviceStatusRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceStatusSyncServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(DeviceStatusSyncServiceImpl.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private HeartbeatOfflineDao heartbeatOfflineDao;
    private static final int[] DEVICE_STATUS = new int[]{1, 2, 3, 4};

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        DeviceStatusRequest deviceStatusRequest = (DeviceStatusRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), DeviceStatusRequest.class);
        this.verifyParams(deviceStatusRequest);
        Integer deviceStatus = deviceStatusRequest.getDeviceStatus();
        Long reportTime = dataCenterBaseRequest.getTimestamp();
        String deviceNo = deviceStatusRequest.getDeviceNo();
        ParkDevice device = this.parkDeviceDao.getByDeviceNo(parkId.longValue(), deviceNo);
        if (device == null) {
            log.info("\u8bbe\u5907\u72b6\u6001\u66f4\u65b0\uff0c\u672a\u627e\u5230\u8bbe\u5907\u7f16\u53f7[{}]", (Object)deviceNo);
            return ObjectResponse.failed((String)"404");
        }
        if (!deviceStatus.equals(device.getStatus())) {
            HeartbeatOffline ret;
            if (deviceStatus.equals(DEVICE_STATUS[1])) {
                HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
                heartbeatOffline.setParkId(parkId);
                Date endTime = device.getEndUpdatetime();
                heartbeatOffline.setLastConnectionTime(Long.valueOf(endTime == null ? reportTime : endTime.getTime() / 1000L));
                heartbeatOffline.setDeviceNo(deviceNo);
                this.heartbeatOfflineDao.insert((Object)heartbeatOffline);
            } else if (deviceStatus.equals(DEVICE_STATUS[0]) && (ret = this.heartbeatOfflineDao.selectLast(parkId, deviceNo)) != null) {
                ret.setReconnectTime(reportTime);
                ret.setOffTime(Long.valueOf(reportTime - ret.getLastConnectionTime()));
                this.heartbeatOfflineDao.updateById((Object)ret);
            }
        }
        if (deviceStatusRequest.getProductModel() != null && !deviceStatusRequest.getProductModel().equals(device.getProductModel()) || deviceStatusRequest.getFirmwareVersion() != null && !deviceStatusRequest.getFirmwareVersion().equals(device.getFirmwareVersion())) {
            ParkDevice deviceUpdate = new ParkDevice();
            deviceUpdate.setId(device.getId());
            deviceUpdate.setProductModel(deviceStatusRequest.getProductModel());
            deviceUpdate.setFirmwareVersion(deviceStatusRequest.getFirmwareVersion());
            this.parkDeviceService.updateDevice(deviceUpdate);
        }
        return this.parkDeviceService.modifyStatus(parkId, deviceStatusRequest.getDeviceNo(), deviceStatusRequest.getDeviceStatus(), deviceStatusRequest.getFailureCause(), deviceStatusRequest.getWrongTime());
    }
}

