/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.DeviceInfoRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceInfoServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    private static final int[] OPER_TYPE = new int[]{1, 2, 3};
    private static final int DEL_FLAG = 1;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        DeviceInfoRequest deviceInfoRequest = (DeviceInfoRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), DeviceInfoRequest.class);
        this.verifyParams(deviceInfoRequest);
        ParkDevice parkDevice_para = new ParkDevice();
        parkDevice_para.setParkId(parkId);
        parkDevice_para.setDeviceNo(deviceInfoRequest.getDeviceNo());
        ParkDevice parkDevice_result = this.parkDeviceDao.selectByParam(parkDevice_para);
        int operType = deviceInfoRequest.getOperType();
        if (parkDevice_result != null) {
            if (operType == OPER_TYPE[0]) {
                return ObjectResponse.failed((String)"405");
            }
            if (operType == OPER_TYPE[1]) {
                ParkDevice parkDevice = new ParkDevice();
                parkDevice.setParkId(parkId);
                parkDevice.setDeviceNo(deviceInfoRequest.getDeviceNo());
                parkDevice.setDelFlag(Integer.valueOf(1));
                this.parkDeviceDao.updateById((Object)parkDevice);
            } else if (operType == OPER_TYPE[2]) {
                this.parkDeviceDao.updateById((Object)this.getParkDevice(deviceInfoRequest, parkId));
            }
        } else if (operType == OPER_TYPE[0]) {
            this.parkDeviceDao.insert((Object)this.getParkDevice(deviceInfoRequest, parkId));
        } else {
            if (operType == OPER_TYPE[1]) {
                return ObjectResponse.failed((String)"405");
            }
            if (operType == OPER_TYPE[2]) {
                this.parkDeviceDao.insert((Object)this.getParkDevice(deviceInfoRequest, parkId));
            }
        }
        return ObjectResponse.success();
    }

    private ParkDevice getParkDevice(DeviceInfoRequest deviceInfoRequest, Long parkId) {
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(parkId);
        parkDevice.setDeviceNo(deviceInfoRequest.getDeviceNo());
        parkDevice.setType(deviceInfoRequest.getDeviceType());
        parkDevice.setIp(deviceInfoRequest.getDeviceIp());
        parkDevice.setPort(deviceInfoRequest.getDevicePort());
        return parkDevice;
    }
}

