/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.domain.request.pnc.ChargeStatusRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.response.pnc.ParkStatusResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChargeStatusServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) {
        ChargeStatusRequest request = (ChargeStatusRequest)JSON.parseObject((String)JSON.toJSONString((Object)baseRequest.getBizContent()), ChargeStatusRequest.class);
        Long cloudTime = DateTools.unixTimestamp();
        request.setTime(cloudTime);
        String redisKey = "pnc:heartbeat:charge:" + parkId;
        this.redisUtils.hPut(redisKey, request.getId().toString(), (Object)request);
        this.redisUtils.expire(redisKey, 10800L);
        ParkStatusResponse parkStatusResponse = new ParkStatusResponse();
        parkStatusResponse.setTime(cloudTime);
        return ObjectResponse.success((Object)parkStatusResponse);
    }
}

