/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.charge.Charge24charge;
import com.icetech.basics.domain.entity.charge.Charge24chargeSet;
import com.icetech.basics.domain.entity.charge.ChargeDaynight;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeNaturalday;
import com.icetech.basics.domain.entity.charge.ChargeOnce;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.service.charge.impl.Charge24chargeServiceImpl;
import com.icetech.basics.service.charge.impl.Charge24chargeSetServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeDaynightServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeDurationServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeNaturaldayServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeOnceServiceImpl;
import com.icetech.basics.service.charge.impl.ParkChargeConfigServiceImpl;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.charge.ChargeServiceImpl;
import com.icetech.park.service.park.impl.ParkGuideServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.SendInfoServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChargeRuleUpServiceImpl
extends AbstractService
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ChargeRuleUpServiceImpl.class);
    @Autowired
    private ChargeServiceImpl chargeService;
    @Autowired
    private ParkChargeConfigServiceImpl parkChargeConfigService;
    @Autowired
    private ChargeNaturaldayServiceImpl chargeNaturaldayService;
    @Autowired
    private ChargeDaynightServiceImpl chargeDaynightService;
    @Autowired
    private Charge24chargeServiceImpl charge24chargeService;
    @Autowired
    private Charge24chargeSetServiceImpl charge24chargeSetService;
    @Autowired
    private ChargeOnceServiceImpl chargeOnceService;
    @Autowired
    private ChargeDurationServiceImpl chargeDurationService;
    @Autowired
    private ParkGuideServiceImpl parkGuideService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    @Transactional
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) throws Exception {
        if (baseRequest.getBizContent() == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        List requests = JSON.parseArray((String)JSON.toJSONString((Object)baseRequest.getBizContent()), ChargeRuleUpRequest.class);
        if (CollectionUtils.isEmpty((Collection)requests)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_400);
        }
        LinkedList<ParkChargeconfig> parkChargeConfigs = new LinkedList<ParkChargeconfig>();
        LinkedList<ChargeNaturalday> chargeNaturalDays = new LinkedList<ChargeNaturalday>();
        LinkedList<ChargeNaturalday> chargeDayNights = new LinkedList<ChargeNaturalday>();
        LinkedList<ChargeOnce> chargeOnces = new LinkedList<ChargeOnce>();
        LinkedList<ChargeDuration> chargeDurations = new LinkedList<ChargeDuration>();
        LinkedList<ChargeNaturalday> charge24Charges = new LinkedList<ChargeNaturalday>();
        LinkedList<Charge24chargeSet> charge24ChargeSets = new LinkedList<Charge24chargeSet>();
        for (ChargeRuleUpRequest request : requests) {
            ChargeNaturalday charge;
            ChargeRuleUpRequest.NaturalDayInfo info;
            ParkChargeconfig config = this.buildParkChargeConfig(parkId, request);
            parkChargeConfigs.add(config);
            if (request.getBilltype() == ParkChargeconfig.BilltypeEnum.\u901a\u7528\u81ea\u7136\u5929.type) {
                info = (ChargeRuleUpRequest.NaturalDayInfo)request.getChargeRule().toJavaObject(ChargeRuleUpRequest.NaturalDayInfo.class);
                charge = this.buildChargeNaturalDay(parkId, request, info);
                chargeNaturalDays.add(charge);
                this.fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 1, info.getOneBillmethod(), info.getFirstConfig(), chargeOnces, chargeDurations);
                if (info.getIsspecialdaycharge() != 1) continue;
                this.fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 2, info.getTwoBillmethod(), info.getTwoConfig(), chargeOnces, chargeDurations);
                continue;
            }
            if (request.getBilltype() == ParkChargeconfig.BilltypeEnum.\u767d\u5929\u591c\u95f4\u6536\u8d39.type) {
                info = (ChargeRuleUpRequest.DayNightInfo)request.getChargeRule().toJavaObject(ChargeRuleUpRequest.DayNightInfo.class);
                charge = this.buildChargeDayNight(parkId, request, (ChargeRuleUpRequest.DayNightInfo)info);
                chargeDayNights.add(charge);
                this.fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 1, info.getDayBillmethod(), info.getDayConfig(), chargeOnces, chargeDurations);
                this.fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 2, info.getNightBillmethod(), info.getNightConfig(), chargeOnces, chargeDurations);
                continue;
            }
            if (request.getBilltype() == ParkChargeconfig.BilltypeEnum.\u4e8c\u5341\u56db\u5c0f\u65f6\u8ba1\u8d39.type) {
                info = (ChargeRuleUpRequest.Hour24Info)request.getChargeRule().toJavaObject(ChargeRuleUpRequest.Hour24Info.class);
                charge = this.buildCharge24Charge(parkId, request, (ChargeRuleUpRequest.Hour24Info)info);
                charge24Charges.add(charge);
                if (info.getDetails() == null || info.getDetails().size() != 48) {
                    throw new ResponseBodyException("400", "24H\u8ba1\u8d39\u89c4\u5219[" + request.getBilltypecode() + "]\u8be6\u60c5\u4e0d\u5168");
                }
                for (ChargeRuleUpRequest.Hour24Detail detail : info.getDetails()) {
                    Charge24chargeSet chargeSet = this.buildCharge24ChargeSet(parkId, request.getBilltypecode(), detail);
                    charge24ChargeSets.add(chargeSet);
                }
                continue;
            }
            log.warn("\u672a\u77e5\u8ba1\u8d39\u89c4\u5219\u7c7b\u578b|{}|{}|{}", new Object[]{request.getBilltypecode(), request.getBilltypename(), request.getBilltype()});
        }
        List existsConfigs = this.parkChargeConfigService.list((Wrapper)Wrappers.lambdaQuery(ParkChargeconfig.class).eq(ParkChargeconfig::getParkId, (Object)parkId));
        HashSet<String> cacheKeys = new HashSet<String>(existsConfigs.size() + 1);
        cacheKeys.add("charge:park:" + parkId);
        if (CollectionUtils.isNotEmpty((Collection)existsConfigs)) {
            Set existsTypeCodes = existsConfigs.stream().map(existsConfig -> {
                cacheKeys.add("charge:natural:code:" + existsConfig.getBilltypecode());
                cacheKeys.add("charge:day_night:code:" + existsConfig.getBilltypecode());
                cacheKeys.add("charge:24hour:code:" + existsConfig.getBilltypecode());
                return existsConfig.getBilltypecode();
            }).collect(Collectors.toSet());
            this.parkChargeConfigService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkChargeconfig.class).eq(ParkChargeconfig::getParkId, (Object)parkId)).in(ParkChargeconfig::getBilltypecode, existsTypeCodes));
            this.chargeNaturaldayService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChargeNaturalday.class).eq(ChargeNaturalday::getParkId, (Object)parkId)).in(ChargeNaturalday::getBilltypecode, existsTypeCodes));
            this.chargeDaynightService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ChargeDaynight.class).eq(ChargeDaynight::getParkId, (Object)parkId)).in(ChargeDaynight::getBilltypecode, existsTypeCodes));
            this.chargeOnceService.remove((Wrapper)Wrappers.lambdaQuery(ChargeOnce.class).in(ChargeOnce::getBilltypecode, existsTypeCodes));
            this.chargeDurationService.remove((Wrapper)Wrappers.lambdaQuery(ChargeDuration.class).in(ChargeDuration::getBilltypecode, existsTypeCodes));
            this.charge24chargeService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(Charge24charge.class).eq(Charge24charge::getParkId, (Object)parkId)).in(Charge24charge::getBilltypecode, existsTypeCodes));
            this.charge24chargeSetService.remove((Wrapper)Wrappers.lambdaQuery(Charge24chargeSet.class).in(Charge24chargeSet::getBilltypecode, existsTypeCodes));
        }
        this.saveBatch((BaseServiceImpl)this.parkChargeConfigService, (Collection)parkChargeConfigs);
        this.saveBatch((BaseServiceImpl)this.chargeNaturaldayService, (Collection)chargeNaturalDays);
        this.saveBatch((BaseServiceImpl)this.chargeDaynightService, (Collection)chargeDayNights);
        this.saveBatch((BaseServiceImpl)this.chargeOnceService, (Collection)chargeOnces);
        this.saveBatch((BaseServiceImpl)this.chargeDurationService, (Collection)chargeDurations);
        this.saveBatch((BaseServiceImpl)this.charge24chargeService, (Collection)charge24Charges);
        this.saveBatch((BaseServiceImpl)this.charge24chargeSetService, (Collection)charge24ChargeSets);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(parkId);
        guide.setStep6(Integer.valueOf(1));
        this.parkGuideService.updateByParkId(guide);
        this.sendInfoService.save((Object)SendInfo.buildUnneeded((Long)parkId, (Long)parkId, (Integer)DownServiceEnum.\u8ba1\u8d39\u89c4\u5219.getServiceType(), (String)"\u672c\u5730\u4e0a\u62a5"));
        this.stringRedisTemplate.delete(cacheKeys);
        return ObjectResponse.success();
    }

    private <T> boolean saveBatch(BaseServiceImpl<?, T> baseService, Collection<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return true;
        }
        return baseService.saveBatch(data);
    }

    private void fillBillMethodList(String billTypeCode, int billType, int billGroup, int billMethod, JSONObject billConfig, List<ChargeOnce> chargeOnces, List<ChargeDuration> chargeDurations) {
        if (billMethod == 1) {
            ChargeRuleUpRequest.OnceInfo onceInfo = (ChargeRuleUpRequest.OnceInfo)billConfig.toJavaObject(ChargeRuleUpRequest.OnceInfo.class);
            ChargeOnce charge = this.buildChargeOnce(billTypeCode, billType, billGroup, onceInfo);
            chargeOnces.add(charge);
        } else if (billMethod == 2) {
            ChargeRuleUpRequest.DurationInfo durationInfo = (ChargeRuleUpRequest.DurationInfo)billConfig.toJavaObject(ChargeRuleUpRequest.DurationInfo.class);
            ChargeDuration charge = this.buildChargeDuration(billTypeCode, billType, billGroup, durationInfo);
            chargeDurations.add(charge);
            for (ChargeRuleUpRequest.StepChargeDetail detail : durationInfo.getStepChargeDetails()) {
                charge = this.buildChargeDuration(billTypeCode, billType, billGroup, detail);
                chargeDurations.add(charge);
            }
        } else {
            log.warn("\u672a\u77e5\u8ba1\u8d39\u65b9\u5f0f|{}|{}", (Object)billTypeCode, (Object)billMethod);
        }
    }

    private ParkChargeconfig buildParkChargeConfig(long parkId, ChargeRuleUpRequest request) {
        ParkChargeconfig config = new ParkChargeconfig();
        config.setParkId(Long.valueOf(parkId));
        config.setBilltypecode(request.getBilltypecode());
        config.setBilltype(request.getBilltype());
        config.setDefaultCharge(request.getIsDefault());
        config.setBilltypename(request.getBilltypename());
        config.setStatus(Integer.valueOf(0));
        return config;
    }

    private ChargeNaturalday buildChargeNaturalDay(long parkId, ChargeRuleUpRequest request, ChargeRuleUpRequest.NaturalDayInfo info) {
        ChargeNaturalday charge = new ChargeNaturalday();
        charge.setBilltypecode(request.getBilltypecode());
        charge.setBilltypename(request.getBilltypename());
        charge.setParkId(Long.valueOf(parkId));
        charge.setBillmethod(info.getOneBillmethod());
        charge.setNoworkBillmethod(info.getTwoBillmethod());
        charge.setIsspecialdaycharge(info.getIsspecialdaycharge());
        charge.setFreetime(info.getFreetime());
        charge.setDaynightmaxfeeusing(info.getDaynightmaxfeeusing());
        charge.setDaynightmaxfee(info.getDaynightmaxfee());
        charge.setStatus(Integer.valueOf(0));
        charge.setDaynightmaxfeeBig(info.getDaynightmaxfeeBig());
        charge.setIsSmallbigcarSet(info.getIsSmallbigcarSet());
        charge.setMaxFeeType(info.getDaynightmaxfeetype());
        charge.setCountType(info.getDaynightmaxfeecounttype());
        charge.setIsFreetimeOnce(info.getIsFreetimeOnce());
        return charge;
    }

    private ChargeDaynight buildChargeDayNight(long parkId, ChargeRuleUpRequest request, ChargeRuleUpRequest.DayNightInfo info) {
        ChargeDaynight charge = new ChargeDaynight();
        charge.setBilltypecode(request.getBilltypecode());
        charge.setBilltypename(request.getBilltypename());
        charge.setParkId(Long.valueOf(parkId));
        charge.setBillmethodday(info.getDayBillmethod());
        charge.setBillmethodnight(info.getNightBillmethod());
        charge.setFreetime(info.getFreetime());
        charge.setDaynightmaxfeeusing(info.getDaynightmaxfeeusing());
        charge.setDaynightmaxfee(info.getDaynightmaxfee());
        charge.setDaybegin(info.getDaybegin());
        charge.setNightbegin(info.getNightbegin());
        charge.setDaymaxfeeusing(info.getDaymaxfeeusing());
        charge.setDaymaxfee(info.getDaymaxfee());
        charge.setNightmaxfeeusing(info.getNightmaxfeeusing());
        charge.setNightmaxfee(info.getNightmaxfee());
        charge.setStatus(Integer.valueOf(0));
        charge.setDaynightmaxfeeBig(info.getDaynightmaxfeeBig());
        charge.setDaymaxfeeBig(info.getDaymaxfeeBig());
        charge.setNightmaxfeeBig(info.getNightmaxfeeBig());
        charge.setIsSmallbigcarSet(info.getIsSmallbigcarSet());
        charge.setMaxFeeType(info.getDaynightmaxfeetype());
        charge.setCountType(info.getDaynightmaxfeecounttype());
        charge.setIsFreetimeOnce(info.getIsFreetimeOnce());
        return charge;
    }

    private ChargeOnce buildChargeOnce(String billTypeCode, int billType, int billGroup, ChargeRuleUpRequest.OnceInfo info) {
        ChargeOnce charge = new ChargeOnce();
        charge.setBilltypecode(billTypeCode);
        charge.setIsnaturaldayfee(Integer.valueOf(billType));
        charge.setDayornightfeemark(Integer.valueOf(billGroup));
        charge.setIsopenoncecharge(info.getIsopenoncecharge());
        charge.setOncechargefee(info.getOncechargefee());
        charge.setIsopenother2(info.getIsopenother2());
        charge.setTimeFrame(info.getTimeFrame());
        charge.setTimeFrameOncefee(info.getTimeFrameOncefee());
        charge.setOtherTimeframeOncefee(info.getOtherTimeframeOncefee());
        charge.setIsattachoption(info.getIsattachoption());
        charge.setOverTime(info.getOverTime());
        charge.setAddOvernightFee(info.getAddOvernightFee());
        charge.setOncechargefeeBig(info.getOncechargefeeBig());
        charge.setTimeFrameOncefeeBig(info.getTimeFrameOncefeeBig());
        charge.setOtherTimeframeOncefeeBig(info.getOtherTimeframeOncefeeBig());
        charge.setAddOvernightFeeBig(info.getAddOvernightFeeBig());
        return charge;
    }

    private ChargeDuration buildChargeDuration(String billTypeCode, int billType, int billGroup, ChargeRuleUpRequest.DurationInfo info) {
        ChargeDuration charge = new ChargeDuration();
        charge.setBilltypecode(billTypeCode);
        charge.setIsnaturaldayfee(Integer.valueOf(billType));
        charge.setDayornightfeemark(Integer.valueOf(billGroup));
        charge.setStartTimeModule(Integer.valueOf(0));
        charge.setEndTimeModule(Integer.valueOf(0));
        charge.setFeespantime(info.getFeespantime());
        charge.setFeespanrate(info.getFeespanrate());
        charge.setFeespanrateBig(info.getFeespanrateBig());
        charge.setIsOverTimeSet(info.getIsOverTimeSet());
        charge.setOverTime(info.getOverTime());
        return charge;
    }

    private ChargeDuration buildChargeDuration(String billTypeCode, int billType, int billGroup, ChargeRuleUpRequest.StepChargeDetail detail) {
        ChargeDuration charge = new ChargeDuration();
        charge.setBilltypecode(billTypeCode);
        charge.setIsnaturaldayfee(Integer.valueOf(billType));
        charge.setDayornightfeemark(Integer.valueOf(billGroup));
        charge.setStartTimeModule(detail.getStartTimeModule());
        charge.setEndTimeModule(detail.getEndTimeModule());
        charge.setFeespantime(detail.getFeespantime());
        charge.setFeespanrate(detail.getFeespanrate());
        charge.setFeespanrateBig(detail.getFeespanrateBig());
        charge.setIsOverTimeSet(Integer.valueOf(2));
        charge.setOverTime(Integer.valueOf(0));
        return charge;
    }

    private Charge24charge buildCharge24Charge(long parkId, ChargeRuleUpRequest request, ChargeRuleUpRequest.Hour24Info info) {
        Charge24charge charge = new Charge24charge();
        charge.setBilltypecode(request.getBilltypecode());
        charge.setBilltypename(request.getBilltypename());
        charge.setParkId(Long.valueOf(parkId));
        charge.setFreetime(info.getFreetime());
        charge.setDaynightmaxfeeusing(info.getDaynightmaxfeeusing());
        charge.setDaynightmaxfee(info.getDaynightmaxfee());
        charge.setDivisionTime(info.getDivisionTime());
        charge.setIsOverTimeSet(info.getIsOverTimeSet());
        charge.setFeespantimestep(info.getFeespantimestep());
        charge.setFeespanratestep(info.getFeespanratestep());
        charge.setStatus(Integer.valueOf(0));
        charge.setDaynightmaxfeeBig(info.getDaynightmaxfeeBig());
        charge.setFeespanratestepBig(info.getFeespanratestepBig());
        charge.setIsSmallbigcarSet(info.getIsSmallbigcarSet());
        charge.setMaxFeeType(info.getDaynightmaxfeetype());
        charge.setCountType(info.getDaynightmaxfeetype());
        charge.setIsFreetimeOnce(info.getIsFreetimeOnce());
        return charge;
    }

    private Charge24chargeSet buildCharge24ChargeSet(long parkId, String billTypeCode, ChargeRuleUpRequest.Hour24Detail info) {
        Charge24chargeSet charge = new Charge24chargeSet();
        charge.setBilltypecode(billTypeCode);
        charge.setFeespantime(info.getFeespantime());
        charge.setFeespanrate(info.getFeespanrate());
        charge.setFeespanrateBig(info.getFeespanrateBig());
        return charge;
    }
}

