/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.pnc.ChannelInfoRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelInfoServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkService parkService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ObjectResponse objectResponse = this.parkService.getInoutByParkId(parkId);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            List parkInoutdevices = (List)objectResponse.getData();
            ChannelInfoRequest channelInfoRequest = new ChannelInfoRequest();
            channelInfoRequest.setChannelNum(Integer.valueOf(parkInoutdevices.size()));
            ArrayList<ChannelInfoRequest.ChannelData> channelDataList = new ArrayList<ChannelInfoRequest.ChannelData>();
            for (ParkInoutdevice parkInoutdevice : parkInoutdevices) {
                ChannelInfoRequest.ChannelData channelData = new ChannelInfoRequest.ChannelData();
                channelData.setChannelCode(parkInoutdevice.getInandoutCode());
                channelData.setChannelName(parkInoutdevice.getInandoutName());
                channelData.setGateType(parkInoutdevice.getInandoutType());
                channelData.setNoCardRun(parkInoutdevice.getIsAllowNocardrun());
                channelData.setQrcodeType(parkInoutdevice.getIsOpenQrcodetype());
                channelData.setTempCarRun(parkInoutdevice.getIsAllowTempcarrun());
                channelData.setVagueType(parkInoutdevice.getVaguetype());
                channelData.setYellowCarRun(parkInoutdevice.getIsAllowYellowcarrun());
                ObjectResponse listObjectResponse = this.parkDeviceService.getDeviceByParkChannel(parkId, parkInoutdevice.getId());
                if (ObjectResponse.isSuccess((Response)listObjectResponse)) {
                    List parkDevices = (List)listObjectResponse.getData();
                    channelData.setDeviceNum(Integer.valueOf(parkDevices.size()));
                    ArrayList<ChannelInfoRequest.DeviceData> deviceDataList = new ArrayList<ChannelInfoRequest.DeviceData>();
                    for (ParkDevice parkDevice : parkDevices) {
                        ChannelInfoRequest.DeviceData deviceData = new ChannelInfoRequest.DeviceData();
                        deviceData.setDeviceCode(parkDevice.getDeviceNo());
                        deviceData.setDeviceType(parkDevice.getType());
                        deviceData.setSerialNumber(parkDevice.getSerialNumber());
                        deviceData.setCallMethods(parkDevice.getCallMethods());
                        deviceData.setDualCamera(parkDevice.getIsDualcamera());
                        deviceData.setIp(parkDevice.getIp());
                        deviceData.setPort(parkDevice.getPort());
                        deviceData.setMasterCamera(parkDevice.getIsMaster());
                        deviceData.setVideoUrl(parkDevice.getVideoUrl());
                        deviceDataList.add(deviceData);
                    }
                    channelData.setDeviceData(deviceDataList);
                } else {
                    channelData.setDeviceNum(Integer.valueOf(0));
                }
                channelDataList.add(channelData);
            }
            channelInfoRequest.setChannelData(channelDataList);
            return ObjectResponse.success((Object)channelInfoRequest);
        }
        return ObjectResponse.failed((String)"404");
    }
}

