/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.pnc.CashRefundRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.fee.dao.CashRefundDao;
import com.icetech.fee.domain.entity.CashRefund;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashRefundServiceImpl
extends AbstractService
implements ReportService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private CashRefundDao cashRefundDao;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        CashRefundRequest cashRefundRequest = (CashRefundRequest)JsonUtils.convert2bean((Object)dataCenterBaseRequest.getBizContent(), CashRefundRequest.class);
        this.verifyParams(cashRefundRequest);
        ObjectResponse inOutDeviceByCode = this.parkService.getInOutDeviceByCode(parkId, cashRefundRequest.getChannelId());
        if (!ObjectResponse.isSuccess((Response)inOutDeviceByCode)) {
            return ObjectResponse.failed((String)"402", (String)"channelId\u672a\u88ab\u6ce8\u518c");
        }
        ParkInoutdevice inoutdevice = (ParkInoutdevice)inOutDeviceByCode.getData();
        CashRefund cashRefund = new CashRefund();
        cashRefund.setParkId(parkId);
        cashRefund.setInandoutName(inoutdevice.getInandoutName());
        String orderNum = this.publicHandle.convert2OrderNum(parkId, cashRefundRequest.getOrderId());
        cashRefund.setOrderNum(orderNum);
        cashRefund.setPlateNum(cashRefundRequest.getPlateNum());
        cashRefund.setParkId(parkId);
        cashRefund.setDeviceNo(cashRefundRequest.getDeviceNo());
        cashRefund.setActualCash(new BigDecimal(cashRefundRequest.getActualCash()));
        cashRefund.setReceiveTime(new Date(cashRefundRequest.getReceiveTime() * 1000L));
        this.cashRefundDao.insert(cashRefund);
        return ObjectResponse.success();
    }
}

