/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2r.impl;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.RecCashRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.MoneyTool;
import com.icetech.common.validator.Validator;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.p2r.impl.PrintInfoServiceImpl;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.paycenter.api.IRedpackService;
import com.icetech.paycenter.domain.request.RedpackPreSendRequest;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2rRecCashServiceImpl")
public class RecCashServiceImpl
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(RecCashServiceImpl.class);
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private IRedpackService redpackService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private PrintInfoServiceImpl printInfoService;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        RecCashRequest recCashRequest = (RecCashRequest)JsonUtils.convert2bean((Object)p2rBaseRequest.getBizContent(), RecCashRequest.class);
        if (!Validator.validate((Object)recCashRequest)) {
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
        }
        String orderNum = recCashRequest.getOrderNum();
        ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum);
        if (!ObjectResponse.isSuccess((Response)orderInfoObjectResponse)) {
            log.warn("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u65e0\u6548\u7684\u8ba2\u5355\u53f7\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNum);
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode(), (String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        OrderInfo orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(Integer.valueOf(2));
        orderPay.setParkId(tokenDeviceVo.getParkId());
        QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
        if (channelFee == null) {
            log.warn("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u901a\u9053\u8d39\u7528\u5df2\u7ecf\u6e05\u7a7a\uff0c\u8bbe\u5907\u4fe1\u606f\uff1a{}", (Object)tokenDeviceVo);
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u8bf7\u6c42\u91cd\u590d.getCode(), (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39");
        }
        float discountPrice = Float.parseFloat(channelFee.getDiscountPrice());
        float unpayPrice = Float.parseFloat(channelFee.getUnpayPrice());
        orderPay.setDiscountPrice(channelFee.getDiscountPrice());
        orderPay.setPaidPrice(channelFee.getUnpayPrice());
        orderPay.setPayChannel(Integer.valueOf(8));
        orderPay.setPayTerminal(tokenDeviceVo.getDeviceNo());
        orderPay.setPayTime(channelFee.getQueryTime());
        orderPay.setOrderTime(channelFee.getQueryTime());
        orderPay.setPayWay(Integer.valueOf(1));
        float totalPrice = discountPrice + unpayPrice;
        String tradeNo = CodeTools.GenerateTradeNo();
        float totalCashAmount = Float.parseFloat(recCashRequest.getTotalCashAmount());
        if (unpayPrice < totalCashAmount) {
            BigDecimal redpackRet = new BigDecimal(totalCashAmount).subtract(new BigDecimal(unpayPrice)).setScale(2, 5);
            log.info("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u8ba2\u5355\u53f7\uff1a{} \u9700\u8981\u627e\u96f6\uff1a{} \u5143", (Object)recCashRequest.getOrderNum(), (Object)redpackRet);
            orderPay.setActualCash(recCashRequest.getTotalCashAmount());
            orderPay.setRedpackRet(String.valueOf(redpackRet));
            RedpackPreSendRequest preSendRequest = new RedpackPreSendRequest();
            preSendRequest.setParkCode(tokenDeviceVo.getParkCode());
            preSendRequest.setAmount(Integer.valueOf(Integer.parseInt(MoneyTool.fromYuanToFen((String)redpackRet.toString()))));
            ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(tokenDeviceVo.getParkId());
            ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
            preSendRequest.setRedpackModel(parkConfig.getRedpackModel());
            preSendRequest.setTradeNo(tradeNo);
            log.info("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u8bf7\u6c42\u9884\u53d1\u9001\u7ea2\u5305\u53c2\u6570\uff1a{}", (Object)preSendRequest);
            ObjectResponse objectResponse = this.redpackService.preSendRedpack(preSendRequest);
            log.info("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u8bf7\u6c42\u9884\u53d1\u9001\u7ea2\u5305\u54cd\u5e94\uff1a{}", (Object)objectResponse);
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                String preId = (String)objectResponse.getData();
                ObjectResponse objectResponse1 = this.printInfoService.downRedpack(tokenDeviceVo.getParkCode(), preId, tokenDeviceVo.getParkId(), tokenDeviceVo.getDeviceNo(), orderNum);
                if (!ObjectResponse.isSuccess((Response)objectResponse1)) {
                    log.error("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u7ea2\u5305\u6253\u5370\u4e0b\u53d1\u5931\u8d25\uff0cpreId\uff1a{}", (Object)preId);
                }
            } else {
                log.error("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u7ea2\u5305\u9884\u53d1\u653e\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\uff1a{}", (Object)preSendRequest, (Object)objectResponse);
            }
        }
        orderPay.setTotalPrice(String.valueOf(totalPrice));
        orderPay.setTradeNo(tradeNo);
        orderPay.setIsSync(Integer.valueOf(1));
        ObjectResponse objectResponse = this.orderPayService.addOrderPay(orderPay);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            DataExitRequest exitRequest = new DataExitRequest();
            exitRequest.setOrderNum(recCashRequest.getOrderNum());
            exitRequest.setParkCode(tokenDeviceVo.getParkCode());
            exitRequest.setType(orderInfo.getType());
            exitRequest.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
            CarExitRequest exit = this.cacheHandle.getExit(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
            exitRequest.setExitTime(exit == null ? new Date() : new Date(exit.getExitTime() * 1000L));
            exitRequest.setAisleCode(tokenDeviceVo.getInandoutCode());
            exitRequest.setPlateNum(orderInfo.getPlateNum());
            ObjectResponse objectResponse1 = this.manageService.allowExit(exitRequest);
            log.info("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u5e73\u53f0\u64cd\u4f5c\u79bb\u573a, \u53c2\u6570[{}], \u7ed3\u679c[{}]", (Object)exitRequest, (Object)objectResponse1);
            return P2rBaseResponse.success((P2rBaseRequest)p2rBaseRequest);
        }
        return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)Integer.parseInt(objectResponse.getCode()));
    }
}

