/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2r.impl;

import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.PayCodeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.PayChannelConstants;
import com.icetech.common.constants.PayWayContants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.MoneyTool;
import com.icetech.common.validator.Validator;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.PlatformPayType;
import com.icetech.paycenter.domain.normalpay.request.UnifiedOrderRequest;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2rPayCodeServiceImpl")
public class PayCodeServiceImpl
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(PayCodeServiceImpl.class);
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private IPayCenterService payCenterService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private OrderService orderService;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        PayCodeRequest payCodeRequest = (PayCodeRequest)JsonUtils.convert2bean((Object)p2rBaseRequest.getBizContent(), PayCodeRequest.class);
        if (!Validator.validate((Object)payCodeRequest)) {
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
        }
        QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
        if (channelFee == null) {
            log.warn("<\u673a\u5668\u4eba\u4ed8\u6b3e\u7801\u4e0a\u62a5> \u901a\u9053\u8d39\u7528\u5df2\u7ecf\u6e05\u7a7a\uff0c\u8bbe\u5907\u4fe1\u606f\uff1a{}", (Object)tokenDeviceVo);
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u8bf7\u6c42\u91cd\u590d.getCode(), (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39");
        }
        String payCode = payCodeRequest.getPayCode();
        String orderNum = payCodeRequest.getOrderNum();
        ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum);
        if (!ObjectResponse.isSuccess((Response)orderInfoObjectResponse)) {
            log.warn("<\u673a\u5668\u4eba\u4ed8\u6b3e\u7801\u4e0a\u62a5> \u65e0\u6548\u7684\u8ba2\u5355\u53f7\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNum);
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode(), (String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        OrderInfo orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
        UnifiedOrderRequest unifiedOrderRequest = new UnifiedOrderRequest();
        int payWay = PayCodeServiceImpl.getWxAliPayCode(payCode);
        ObjectResponse response = this.parkService.selectGroupPayType(tokenDeviceVo.getParkCode());
        if (ObjectResponse.isSuccess((Response)response) && StringUtils.isNotBlank((CharSequence)((CharSequence)response.getData()))) {
            unifiedOrderRequest.setSelectTradeType(PlatformPayType.getTradeTypeScan((String)((String)response.getData()), (Integer)payWay));
        }
        String tradeNo = CodeTools.GenerateTradeNo();
        unifiedOrderRequest.setTradeNo(tradeNo);
        unifiedOrderRequest.setParkCode(tokenDeviceVo.getParkCode());
        unifiedOrderRequest.setPrice(MoneyTool.fromYuanToFen((String)channelFee.getUnpayPrice()));
        unifiedOrderRequest.setPayCode(payCode);
        unifiedOrderRequest.setParkId(tokenDeviceVo.getParkId());
        String parkName = null;
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(orderInfo.getParkId());
        if (ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            parkName = ((Park)parkObjectResponse.getData()).getParkName();
        }
        String productInfo = unifiedOrderRequest.genProductInfo(parkName, orderInfo.getPlateNum(), "\u505c\u8f66\u8d39");
        unifiedOrderRequest.setProductInfo(productInfo);
        ObjectResponse unifiedOrderResponseObjectResponse = this.payCenterService.doUnifiedOrder(unifiedOrderRequest);
        if (ObjectResponse.isSuccess((Response)unifiedOrderResponseObjectResponse)) {
            OrderPay orderPay = new OrderPay();
            orderPay.setOrderNum(orderNum);
            orderPay.setPayStatus(Integer.valueOf(2));
            orderPay.setParkId(tokenDeviceVo.getParkId());
            float discountPrice = Float.parseFloat(channelFee.getDiscountPrice());
            float unpayPrice = Float.parseFloat(channelFee.getUnpayPrice());
            orderPay.setDiscountPrice(channelFee.getDiscountPrice());
            orderPay.setPaidPrice(channelFee.getUnpayPrice());
            orderPay.setPayChannel(PayChannelConstants.ROBOT);
            orderPay.setPayTerminal(tokenDeviceVo.getDeviceNo());
            orderPay.setPayTime(channelFee.getQueryTime());
            orderPay.setOrderTime(channelFee.getQueryTime());
            orderPay.setPayWay(Integer.valueOf(payWay));
            float totalPrice = discountPrice + unpayPrice;
            orderPay.setTotalPrice(String.valueOf(totalPrice));
            orderPay.setTradeNo(tradeNo);
            orderPay.setIsSync(Integer.valueOf(1));
            orderPay.setPayAisle(PlatformPayType.getPayAisle((String)((String)response.getData()), (Integer)payWay));
            this.orderPayService.addOrderPay(orderPay);
            DataExitRequest exitRequest = new DataExitRequest();
            exitRequest.setOrderNum(orderNum);
            exitRequest.setParkCode(tokenDeviceVo.getParkCode());
            exitRequest.setType(orderInfo.getType());
            exitRequest.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
            CarExitRequest exit = this.cacheHandle.getExit(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode());
            exitRequest.setExitTime(exit == null ? new Date() : new Date(exit.getExitTime() * 1000L));
            exitRequest.setAisleCode(tokenDeviceVo.getInandoutCode());
            exitRequest.setPlateNum(orderInfo.getPlateNum());
            ObjectResponse objectResponse1 = this.manageService.allowExit(exitRequest);
            log.info("<\u673a\u5668\u4eba\u73b0\u91d1\u4e0a\u62a5> \u5e73\u53f0\u64cd\u4f5c\u79bb\u573a, \u53c2\u6570[{}], \u7ed3\u679c[{}]", (Object)exitRequest, (Object)objectResponse1);
            return P2rBaseResponse.success((P2rBaseRequest)p2rBaseRequest);
        }
        return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)Integer.parseInt(unifiedOrderResponseObjectResponse.getCode()), (String)unifiedOrderResponseObjectResponse.getMsg());
    }

    private static int getWxAliPayCode(String payCode) {
        if (payCode.length() == 18 && (payCode.startsWith("10") || payCode.startsWith("11") || payCode.startsWith("12") || payCode.startsWith("13") || payCode.startsWith("14") || payCode.startsWith("15"))) {
            return PayWayContants.WECHAT;
        }
        return PayWayContants.ALIPAY;
    }
}

