/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2r.impl;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.HeartbeatRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.response.p2r.HeartbeatResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.validator.Validator;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.third.utils.RedisUtils;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2rHeartbeatServiceImpl")
public class HeartbeatServiceImpl
extends AbstractService
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatServiceImpl.class);
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)JsonUtils.convert2bean((Object)p2rBaseRequest.getBizContent(), HeartbeatRequest.class);
        if (!Validator.validate((Object)heartbeatRequest)) {
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
        }
        this.redisUtils.hPut("p2r:heartbeat:time", tokenDeviceVo.getDeviceNo(), (Object)DateTools.unixTimestamp());
        this.asyncHandle(tokenDeviceVo);
        HeartbeatResponse heartbeatResponse = new HeartbeatResponse();
        heartbeatResponse.setCloudTime(String.valueOf(System.currentTimeMillis()));
        return P2rBaseResponse.success((P2rBaseRequest)p2rBaseRequest, (Object)heartbeatResponse);
    }

    private void asyncHandle(TokenDeviceVo tokenDeviceVo) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            this.cacheHandle.expireRobotDeviceInfo(tokenDeviceVo.getDeviceNo());
            this.cacheHandle.setChannelRobot(tokenDeviceVo.getParkCode(), tokenDeviceVo.getInandoutCode(), tokenDeviceVo.getDeviceNo());
        }));
    }
}

