/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2r.impl;

import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.utils.DataConvertTools;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.ErrorMsgRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.validator.Validator;
import com.icetech.fee.dao.CashRefundDao;
import com.icetech.fee.domain.entity.CashRefund;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.service.report.p2r.IRobotEventService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2rErrorMsgServiceImpl")
public class ErrorMsgServiceImpl
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(ErrorMsgServiceImpl.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CashRefundDao cashRefundDao;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        Map keyValMap;
        String totalCashAmount;
        String cashDetails;
        ErrorMsgRequest errorMsgRequest = (ErrorMsgRequest)JsonUtils.convert2bean((Object)p2rBaseRequest.getBizContent(), ErrorMsgRequest.class);
        if (!Validator.validate((Object)errorMsgRequest)) {
            return P2rBaseResponse.instance((P2rBaseRequest)p2rBaseRequest, (int)CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
        }
        String errorCode = errorMsgRequest.getErrorCode();
        String errorMsg = RobotErrorCode.getErrorMsg(errorCode);
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(tokenDeviceVo.getParkId());
        parkDevice.setSerialNumber(tokenDeviceVo.getDeviceNo());
        ParkDevice parkDevice1 = this.parkDeviceDao.selectByParam(parkDevice);
        ObjectResponse objectResponse = this.parkDeviceService.modifyStatus(tokenDeviceVo.getParkId(), parkDevice1.getDeviceNo(), Integer.valueOf(3), errorMsg == null ? "" : (errorMsgRequest.getErrorMsg() == null ? errorMsg : errorMsg + "," + errorMsgRequest.getErrorMsg()), Long.valueOf(DateTools.unixTimestamp()));
        ObjectResponse.notError((Response)objectResponse);
        if ((errorCode.equals(RobotErrorCode.R900201.name()) || errorCode.equals(RobotErrorCode.R900202.name()) || errorCode.equals(RobotErrorCode.R900203.name())) && StringUtils.isNotBlank((CharSequence)(cashDetails = errorMsgRequest.getCashDetails())) && StringUtils.isNotBlank((CharSequence)(totalCashAmount = (String)(keyValMap = DataConvertTools.convert2Map((String)cashDetails)).get("totalCashAmount"))) && Double.parseDouble(totalCashAmount) > 0.0) {
            CashRefund cashRefund = new CashRefund();
            cashRefund.setParkId(tokenDeviceVo.getParkId());
            cashRefund.setInandoutName(tokenDeviceVo.getInandoutName());
            String orderNum = (String)keyValMap.get("orderNum");
            cashRefund.setOrderNum(orderNum);
            ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum);
            if (ObjectResponse.isSuccess((Response)orderInfoObjectResponse)) {
                OrderInfo orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
                cashRefund.setPlateNum(orderInfo.getPlateNum());
            }
            cashRefund.setDeviceNo(parkDevice1.getDeviceNo());
            cashRefund.setActualCash(new BigDecimal((String)keyValMap.get("totalCashAmount")));
            cashRefund.setReceiveTime(new Date());
            this.cashRefundDao.insert(cashRefund);
        }
        return P2rBaseResponse.success((P2rBaseRequest)p2rBaseRequest);
    }

    public static enum RobotErrorCode {
        R900201("\u5f53\u524d\u6536\u8d39\u4fe1\u606f\u754c\u9762\u8fd8\u6ca1\u6709\u652f\u4ed8\u6210\u529f\uff0c\u5c31\u63a5\u6536\u5230\u65b0\u7684\u652f\u4ed8\u4fe1\u606f\u6307\u4ee4\uff0c\u754c\u9762\u5c55\u793a\u65b0\u7684\u652f\u4ed8\u4fe1\u606f"),
        R900101("\u6253\u5370\u673a\u672a\u8fde\u63a5"),
        R900104("\u6253\u5370\u673a\u5207\u5200\u672a\u590d\u4f4d"),
        R900105("\u6253\u5370\u673a\u8fc7\u70ed"),
        R900107("\u6253\u5370\u673a\u7eb8\u5c3d"),
        R900108("\u6253\u5370\u673a\u7eb8\u5c06\u5c3d"),
        R900202("\u94b1\u7bb1\u6709\u6536\u5165\u73b0\u91d1\uff0c\u7528\u6237\u901a\u8fc7\u5176\u4ed6\u9014\u5f84\u652f\u4ed8\u6210\u529f"),
        R900203("\u94b1\u7bb1\u6709\u6536\u5165\u73b0\u91d1\uff0c\u7528\u6237\u8d85\u65f6\u672a\u652f\u4ed8"),
        R900241("\u949e\u7bb1\u6ee1"),
        R900242("\u949e\u7bb1\u79fb\u9664"),
        R900243("\u7eb8\u5e01\u8bc6\u522b\u5668\u8fc7\u949e\u901a\u9053\u5835\u585e\u9519\u8bef"),
        R900245("\u6076\u610f\u5165\u949e"),
        R900246("\u94b1\u7bb1\u8bbe\u5907\u901a\u8baf\u65ad\u5f00"),
        R90024750("\u538b\u949e\u9a6c\u8fbe\u6545\u969c"),
        R90024751("\u7801\u76d8\u4f20\u611f\u5668\u6545\u969c"),
        R90024752("\u4f20\u8f93\u9a6c\u8fbe\u6545\u969c"),
        R90024753("\u7eb8\u5e01\u5c45\u4e2d\u9a6c\u8fbe\u6545\u969c"),
        R90024755("\u5149\u5b66\u4f20\u611f\u5668\u6545\u969c"),
        R90024756("\u78c1\u6027\u4f20\u611f\u5668\u6545\u969c"),
        R90024795("\u7535\u5bb9\u4f20\u611f\u5668\u6545\u969c");

        private String errorMsg;

        private RobotErrorCode(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public static String getErrorMsg(String errorCode) {
            for (RobotErrorCode codeEnum : RobotErrorCode.values()) {
                if (!errorCode.equals(codeEnum.name())) continue;
                return codeEnum.errorMsg;
            }
            return "";
        }
    }
}

