/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2r.impl;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.AuthDeviceRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.response.p2r.AuthDeviceResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.common.validator.Validator;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="p2rAuthDeviceServiceImpl")
public class AuthDeviceServiceImpl
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(AuthDeviceServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private CacheHandle cacheHandle;
    @Value(value="${web.url}")
    private String webUrl;
    private static final String KEY = "7c5977ae21302d02fd846f6a02f2dc34";

    public P2rBaseResponse executeEvent(String args, String serialNumber) {
        AuthDeviceRequest authDeviceRequest = (AuthDeviceRequest)JsonUtils.parseObject((String)args, AuthDeviceRequest.class, (Class[])new Class[0]);
        P2rBaseResponse p2rBaseResponse = new P2rBaseResponse();
        p2rBaseResponse.setMessageId(authDeviceRequest.getMessageId());
        if (!Validator.validate((Object)authDeviceRequest)) {
            p2rBaseResponse.setCode(CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
            p2rBaseResponse.setMsg(CodeEnum.\u7f3a\u5931\u53c2\u6570.getMsg());
            return p2rBaseResponse;
        }
        boolean verifySign = SignTools.verifyMD5Sign((Object)authDeviceRequest, (String)KEY);
        if (!verifySign) {
            p2rBaseResponse.setCode(CodeEnum.\u8ba4\u8bc1\u5931\u8d25.getCode());
            p2rBaseResponse.setMsg(CodeEnum.\u8ba4\u8bc1\u5931\u8d25.getMsg());
            return p2rBaseResponse;
        }
        String parkCode = authDeviceRequest.getParkCode();
        String channelCode = authDeviceRequest.getChannelCode();
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            log.info("[\u7aef\u4e91\u673a\u5668\u4eba\u6388\u6743] parkCode\uff1a{}\u672a\u6dfb\u52a0\uff0c\u4e0d\u5141\u8bb8\u8fde\u63a5", (Object)parkCode);
            p2rBaseResponse.setCode(CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode());
            p2rBaseResponse.setMsg(CodeEnum.\u975e\u6cd5\u53c2\u6570.getMsg());
            return p2rBaseResponse;
        }
        Park park = (Park)parkObjectResponse.getData();
        ObjectResponse parkInoutdeviceObjectResponse = this.parkService.getInOutDeviceByCode(park.getId(), channelCode);
        if (!ObjectResponse.isSuccess((Response)parkInoutdeviceObjectResponse)) {
            log.info("[\u7aef\u4e91\u673a\u5668\u4eba\u6388\u6743] parkCode\uff1a{}\uff0cchannelCode\uff1a{}\u672a\u6dfb\u52a0\uff0c\u4e0d\u5141\u8bb8\u8fde\u63a5", (Object)parkCode, (Object)channelCode);
            p2rBaseResponse.setCode(CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode());
            p2rBaseResponse.setMsg(CodeEnum.\u975e\u6cd5\u53c2\u6570.getMsg());
            return p2rBaseResponse;
        }
        ParkInoutdevice inoutDevice = (ParkInoutdevice)parkInoutdeviceObjectResponse.getData();
        ObjectResponse parkDeviceObjectResponse = this.parkDeviceService.getDeviceByChannel(park.getId(), channelCode, Integer.valueOf(5));
        if (ObjectResponse.isSuccess((Response)parkDeviceObjectResponse)) {
            List parkDevices = (List)parkDeviceObjectResponse.getData();
            ParkDevice parkDevice = (ParkDevice)parkDevices.get(0);
            if (StringUtils.isNotBlank((CharSequence)parkDevice.getSerialNumber()) && !parkDevice.getSerialNumber().equals(authDeviceRequest.getDeviceMac())) {
                log.warn("[\u7aef\u4e91\u673a\u5668\u4eba\u6388\u6743] \u5f53\u524d\u901a\u9053\u5df2\u7ecf\u5b58\u5728\u673a\u5668\u4eba\uff1a{}", (Object)parkDevice);
                p2rBaseResponse.setCode(CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode());
                p2rBaseResponse.setMsg("\u5f53\u524d\u901a\u9053\u5df2\u6709\u673a\u5668\u4eba\uff0c\u4e0d\u80fd\u91cd\u590d\u6388\u6743");
                return p2rBaseResponse;
            }
            if (StringUtils.isBlank((CharSequence)parkDevice.getSerialNumber())) {
                parkDevice.setSerialNumber(authDeviceRequest.getDeviceMac());
                parkDevice.setIp(authDeviceRequest.getDeviceIp());
                parkDevice.setEndUpdatetime(new Date());
                this.parkDeviceService.updateDevice(parkDevice);
            }
        } else {
            ParkDevice parkDevice = new ParkDevice();
            parkDevice.setParkId(park.getId());
            parkDevice.setSerialNumber(authDeviceRequest.getDeviceMac());
            parkDevice.setChannelId(Integer.valueOf(inoutDevice.getId().intValue()));
            parkDevice.setDeviceNo("D" + System.currentTimeMillis() + RandomUtils.nextInt((int)10, (int)100));
            parkDevice.setIp(authDeviceRequest.getDeviceIp());
            parkDevice.setType(Integer.valueOf(5));
            parkDevice.setStatus(Integer.valueOf(1));
            parkDevice.setAdder("system");
            parkDevice.setDelFlag(Integer.valueOf(0));
            parkDevice.setEndUpdatetime(new Date());
            this.parkDeviceService.addDevice(parkDevice);
        }
        AuthDeviceResponse authDeviceResponse = this.authDevice(serialNumber, authDeviceRequest, parkCode, park, inoutDevice);
        p2rBaseResponse.setCode(CodeEnum.\u6210\u529f.getCode());
        p2rBaseResponse.setMsg(CodeEnum.\u6210\u529f.getMsg());
        p2rBaseResponse.setData((Object)authDeviceResponse);
        p2rBaseResponse.setToken(authDeviceResponse.getToken());
        return p2rBaseResponse;
    }

    private AuthDeviceResponse authDevice(String serialNumber, AuthDeviceRequest authDeviceRequest, String parkCode, Park park, ParkInoutdevice inoutDevice) {
        String token = null;
        TokenDeviceVo robotDeviceInfo = this.cacheHandle.getRobotDeviceInfo(serialNumber);
        if (robotDeviceInfo != null) {
            token = robotDeviceInfo.getToken();
        }
        token = StringUtils.isBlank(token) ? UUIDTools.getUuid() : token;
        Integer inandoutType = inoutDevice.getInandoutType();
        ParkConnectedDeviceVo parkConnectedDeviceVo = new ParkConnectedDeviceVo();
        parkConnectedDeviceVo.setDeviceNo(serialNumber);
        parkConnectedDeviceVo.setInandoutCode(inoutDevice.getInandoutCode());
        parkConnectedDeviceVo.setInandoutType(inandoutType);
        parkConnectedDeviceVo.setId(inoutDevice.getId());
        this.cacheHandle.addParkRobotConnectList(parkCode, parkConnectedDeviceVo);
        TokenDeviceVo tdv = new TokenDeviceVo();
        tdv.setParkId(park.getId());
        tdv.setParkCode(parkCode);
        tdv.setDeviceNo(serialNumber);
        tdv.setVersion(authDeviceRequest.getVersion());
        tdv.setId(inoutDevice.getId());
        tdv.setInandoutName(inoutDevice.getInandoutName());
        tdv.setInandoutCode(inoutDevice.getInandoutCode());
        tdv.setInandoutType(inoutDevice.getInandoutType());
        tdv.setToken(token);
        this.cacheHandle.setRobotDeviceInfo(serialNumber, tdv);
        this.cacheHandle.setChannelRobot(parkCode, inoutDevice.getInandoutCode(), serialNumber);
        AuthDeviceResponse authDeviceResponse = new AuthDeviceResponse();
        authDeviceResponse.setToken(token);
        authDeviceResponse.setCloudTime(String.valueOf(System.currentTimeMillis()));
        authDeviceResponse.setEnexType(inandoutType);
        authDeviceResponse.setHeadMsg("\u5fae\u4fe1\u626b\u7801\u7535\u5b50\u7ea2\u5305\u627e\u96f6");
        authDeviceResponse.setBottomMsg("\u63d0\u793a\uff1a\u627e\u96f6\u7ea2\u5305\u8bf7\u572824\u5c0f\u65f6\u5185\u9886\u53d6");
        authDeviceResponse.setRedpackUrlPrefix(this.webUrl + "/redpack/robot-send");
        return authDeviceResponse;
    }

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        return null;
    }
}

