/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl.exit;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.p2c.impl.OfflineRecordServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.flow.p2c.impl.CarExitFlowProcessImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.park.service.report.p2c.impl.exit.CarExitBaseHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CarExitHandler
extends CarExitBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(CarExitHandler.class);
    @Autowired
    private CarExitFlowProcessImpl carExitFlowProcess;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OfflineRecordServiceImpl offlineRecordService;
    @Autowired
    private RabbitSender rabbitSender;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    private static final Long OFFSET = 10L;
    private static final String OFFLINE_RECORDS_PREFIX = "offline:record:";
    @Value(value="${custom.repeatEx.enable:false}")
    private boolean customRepeatExEnable;
    @Value(value="${custom.repeatEx.parkCodes:P}")
    private String customRepeatExParkCodes;
    @Value(value="${custom.repeatEx.showDevice:1}")
    private Integer customRepeatExShowDevice;

    public P2cBaseResponse<CarEnexResponse> execute(TokenDeviceVo deviceToken, P2cBaseRequest<CarExitRequest> baseRequest) {
        CarExitRequest exitRequest = (CarExitRequest)baseRequest.getBizContent();
        String parkCode = exitRequest.getParkCode();
        String inandoutCode = exitRequest.getInandoutCode();
        String deviceNo = deviceToken.getDeviceNo();
        Long parkId = exitRequest.getParkId();
        Long exitTime = exitRequest.getExitTime();
        long now = DateTools.unixTimestamp();
        if (now + OFFSET < exitTime) {
            log.warn("alarmType[{}],keyword1[{}],keyword2[SN:{}, \u4e0a\u62a5\u79bb\u573a\u65f6\u95f4:{}]", new Object[]{"\u7aef\u4e91\u76f8\u673a\u65f6\u95f4\u4e0d\u540c\u6b65", parkCode, deviceNo, exitTime});
            exitRequest.setExitTime(Long.valueOf(now));
        }
        CarEnexResponse carEnexResponse = new CarEnexResponse();
        boolean softTriggerFlag = TriggerTypeEnum.\u8f6f\u89e6\u53d1.getVal().equals(exitRequest.getTriggerType());
        if (softTriggerFlag) {
            this.redisUtils.releaseLock("softTrigger:" + deviceNo);
            String plateNum = exitRequest.getPlateNum();
            if (DataCommonConstants.isNoPlate((String)plateNum)) {
                return this.softTrigger(baseRequest, exitRequest, carEnexResponse, parkCode, inandoutCode);
            }
            this.softTrigger(baseRequest, exitRequest, carEnexResponse, parkCode, inandoutCode);
        }
        if (Integer.valueOf(0).equals(exitRequest.getShamFlag())) {
            ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(parkId);
            ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
            Integer enableShamPlate = parkConfig.getEnableShamPlate();
            if (Integer.valueOf(1).equals(enableShamPlate)) {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                this.setCustomShowSay(parkId, exitRequest, carEnexResponse, null, FlowCondition.ResultCode.\u865a\u5047\u8f66\u724c);
                this.dealShamPlate(deviceToken, exitRequest, parkCode, inandoutCode, parkId);
                return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
            }
        }
        this.lastExitHandle(exitRequest, parkCode, inandoutCode);
        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(), exitRequest.getInandoutCode(), deviceToken.getDeviceNo(), deviceToken.getVersion(), exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        String plateNum = exitRequest.getPlateNum();
        OrderInfo orderInfo = null;
        if (!DataCommonConstants.isNoPlate((String)plateNum)) {
            ObjectResponse inPark = this.orderService.findInPark(plateNum, parkCode);
            if (inPark != null && inPark.getCode().equals("200")) {
                orderInfo = (OrderInfo)inPark.getData();
                exitRequest.setOrderNum(orderInfo.getOrderNum());
                this.setType(deviceToken.getRegionId(), exitRequest, orderInfo);
                paramHolder.setOrderNum(orderInfo.getOrderNum());
            } else {
                inPark = this.orderService.fuzzyPlate(parkId, inandoutCode, plateNum);
                if (inPark != null && inPark.getCode().equals("200")) {
                    orderInfo = (OrderInfo)inPark.getData();
                    log.info("[\u7aef\u4e91-\u79bb\u573a\u63a5\u53e3]\u79bb\u573a\u8f66\u724c[{}], \u6a21\u7cca\u5339\u914d\u5230\u8f66\u724c[{}]", (Object)plateNum, (Object)orderInfo.getPlateNum());
                    exitRequest.setOrderNum(orderInfo.getOrderNum());
                    plateNum = orderInfo.getPlateNum();
                    exitRequest.setPlateNum(plateNum);
                    exitRequest.setFuzzyOrder(Boolean.valueOf(true));
                    this.setType(deviceToken.getRegionId(), exitRequest, orderInfo);
                    paramHolder.setOrderNum(orderInfo.getOrderNum());
                }
            }
        }
        if (exitRequest.getProperty() == 2 || FlowCondition.YES.equals(exitRequest.getOpenFlag())) {
            Park parkInfo = paramHolder.getParkInfo();
            if (exitRequest.getProperty() == 2 && Integer.valueOf(1).equals(parkInfo.getIsInterior())) {
                this.cacheHandle.cacheExitRecords(parkCode, plateNum, exitRequest);
                if (this.redisUtils.tryLock(OFFLINE_RECORDS_PREFIX + parkCode + "_" + plateNum, parkCode, 4000L)) {
                    this.offlineRecordService.send(parkId, parkCode, plateNum);
                    this.rabbitSender.sendMessage(MqConstants.Exchange.OFFLINE_RECORDS_DELAYED_EXCHANGE, "offline.records.routing", (Object)(parkCode + "_" + plateNum), Long.valueOf(20000L));
                }
                return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
            }
            if (orderInfo == null) {
                String orderNum = this.replenishEnter(exitRequest);
                carEnexResponse.setOrderNum(orderNum);
                exitRequest.setOrderNum(orderNum);
                paramHolder.setOrderNum(orderNum);
                this.dealOfflinePay(exitRequest, orderNum);
            } else {
                this.dealOfflinePay(exitRequest, orderInfo.getOrderNum());
            }
            if (exitRequest.getProperty() == 1 && FlowCondition.YES.equals(exitRequest.getOpenFlag())) {
                this.otherDeviceSync(exitRequest, parkCode, inandoutCode, parkId, paramHolder, orderInfo == null ? null : orderInfo.getEnterTime());
            }
            if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(exitRequest.getType()) && orderInfo != null) {
                FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                this.carExitFlowProcess.queryFeeHandle(orderInfo, exitTime, flowRet, paramMap, parkCode, inandoutCode, paramHolder.getParkConfig());
                if (FlowCondition.ResultCode.\u9700\u7f34\u8d39.equals((Object)flowRet.getResultCode())) {
                    log.warn("\u76f8\u673a\u5df2\u5f00\u95f8\u4f46\u5b9e\u9645\u9700\u652f\u4ed8, \u53c2\u6570[{}]", paramMap);
                } else {
                    double discountPrice;
                    double unpayPrice;
                    QueryOrderFeeResponse orderFee = (QueryOrderFeeResponse)paramMap.get("orderFee");
                    if (orderFee != null && (unpayPrice = NumberUtils.toDouble((String)orderFee.getUnpayPrice())) + (discountPrice = NumberUtils.toDouble((String)orderFee.getDiscountPrice())) > 0.0) {
                        this.saveDiscountPay(exitRequest.getInandoutName(), inandoutCode, orderFee, unpayPrice, discountPrice);
                    }
                }
            }
            return this.normalExit(baseRequest, paramHolder, carEnexResponse);
        }
        if (orderInfo != null && Integer.valueOf(1).equals(orderInfo.getNoneEnterFlag())) {
            log.info("[\u7aef\u4e91-\u79bb\u573a\u63a5\u53e3] \u7591\u4f3c\u65e0\u5165\u573a\u8bb0\u5f55\u7684\u8f66\u724c\u4e8c\u6b21\u8bc6\u522b\uff0c\u624b\u52a8\u6821\u6b63orderInfo\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
            orderInfo = null;
        }
        long parkTime = 0L;
        if (orderInfo != null) {
            CarExitRequest cacheExit = this.cacheHandle.getExit(parkCode, inandoutCode);
            if (cacheExit != null && orderInfo.getOrderNum().equals(cacheExit.getOrderNum())) {
                log.info("[\u7aef\u4e91-\u79bb\u573a\u63a5\u53e3] \u8fde\u7eed\u8bc6\u522b\u4f7f\u7528\u4e0a\u6b21\u8bc6\u522b\u65f6\u95f4, plateNum[{}], lastTime[{}]", (Object)plateNum, (Object)cacheExit.getExitTime());
                exitRequest.setExitTime(cacheExit.getExitTime());
            }
            parkTime = exitRequest.getExitTime() - orderInfo.getEnterTime();
        }
        if (this.customRepeatExEnable && this.customRepeatExParkCodes.contains(parkCode) && orderInfo == null) {
            log.info("[\u5b9a\u5236\u529f\u80fd-\u91cd\u590d\u79bb\u573a] {}", (Object)exitRequest);
            carEnexResponse.setOpenFlag(FlowCondition.NO);
            carEnexResponse.setShow(exitRequest.getPlateNum() + "/\u6b64\u8f66\u5df2\u79bb\u573a/\u8bf7\u52ff\u91cd\u590d\u79bb\u573a/\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
            carEnexResponse.setSay("\u6b64\u8f66\u5df2\u79bb\u573a \u8bf7\u52ff\u91cd\u590d\u79bb\u573a");
            carEnexResponse.setShowDeviceType(this.customRepeatExShowDevice);
            return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
        }
        try {
            FlowCondition.FlowRet flowRet = this.carExitFlowProcess.flowHandle(orderInfo, exitRequest, paramHolder);
            return this.notOpenedFlowHandle(baseRequest, paramHolder, flowRet, parkTime);
        }
        catch (ResponseBodyException re) {
            log.warn("[\u7aef\u4e91-\u79bb\u573a\u63a5\u53e3]\u4e1a\u52a1\u5f02\u5e38, \u8f66\u724c\u53f7[{}]", (Object)plateNum, (Object)re);
            if (re.getMessage().contains("\u672a\u914d\u7f6e\u9ed8\u8ba4\u8ba1\u8d39\u89c4\u5219")) {
                carEnexResponse.setOpenFlag(Integer.valueOf(1));
                carEnexResponse.setOrderNum(orderInfo != null ? orderInfo.getOrderNum() : null);
                this.setCustomShowSay(parkId, exitRequest, carEnexResponse, null, FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
                return this.normalExit(baseRequest, paramHolder, carEnexResponse);
            }
            return P2cBaseResponse.instance(baseRequest, (int)Integer.parseInt(re.getErrCode()), (String)re.getMessage());
        }
        catch (Exception e) {
            log.error("[\u7aef\u4e91-\u79bb\u573a\u63a5\u53e3]\u670d\u52a1\u5f02\u5e38, \u8f66\u724c\u53f7[{}]", (Object)plateNum, (Object)e);
            return P2cBaseResponse.instance(baseRequest, (int)CodeEnum.\u670d\u52a1\u5668\u5f02\u5e38.getCode());
        }
    }

    private void setType(Long currRegionId, CarExitRequest exitRequest, OrderInfo orderInfo) {
        exitRequest.setType(orderInfo.getType());
        if (orderInfo.getRegionId() != null && !orderInfo.getRegionId().equals(currRegionId) && Integer.valueOf(1).equals(orderInfo.getHasSon())) {
            OrderSonInfo orderSonInfo = new OrderSonInfo();
            orderSonInfo.setParkId(exitRequest.getParkId());
            orderSonInfo.setOrderNum(orderInfo.getOrderNum());
            orderSonInfo.setRegionId(currRegionId);
            OrderSonInfo sonInfo = this.orderSonInfoDao.selectOneByEntity(orderSonInfo);
            if (sonInfo != null) {
                exitRequest.setType(sonInfo.getType());
            }
        }
    }

    private void lastExitHandle(CarExitRequest exitRequest, String parkCode, String channelCode) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            CarExitRequest cacheExit = this.cacheHandle.getExit(parkCode, channelCode);
            if (cacheExit != null && !DataCommonConstants.isNoPlate((String)exitRequest.getPlateNum()) && !cacheExit.getPlateNum().equals(exitRequest.getPlateNum())) {
                OrderBack orderBack;
                QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(parkCode, channelCode);
                if (channelFee != null) {
                    cacheExit.setTotalAmount(channelFee.getTotalAmount());
                    cacheExit.setPaidAmount(channelFee.getPaidAmount());
                    cacheExit.setDiscountAmount(channelFee.getDiscountAmount());
                }
                if ((orderBack = (OrderBack)this.redisUtils.get("mor:back:" + cacheExit.getOrderNum(), OrderBack.class)) != null && Math.abs(cacheExit.getOriginalExitTime() - orderBack.getExitTime()) < 5L) {
                    log.info("[\u7aef\u4e91-\u79bb\u573a\u63a5\u53e3] \u5f53\u524d\u8ba2\u5355\u5df2\u6298\u8fd4\u56de\u573a\uff0c\u4e0d\u6309\u6b20\u8d39[{}]", (Object)cacheExit);
                    return;
                }
                ObjectResponse<Map<String, Object>> response = this.carOrderExitService.exceptionExit(cacheExit, OrderOddStatusEnum.\u975e\u6b63\u5e38\u51fa\u573a.getVal());
                log.info("[\u7aef\u4e91-\u79bb\u573a\u63a5\u53e3]\u4e0a\u6b21\u975e\u6b63\u5e38\u51fa\u573a\u8f66\u724c\u5904\u7406, \u8f66\u724c\u53f7[{}], \u54cd\u5e94[{}]", (Object)cacheExit.getPlateNum(), response);
            }
        }));
    }

    private void otherDeviceSync(CarExitRequest exitRequest, String parkCode, String channelCode, Long parkId, ReportParamHolder paramHolder, Long enterTime) {
        String robotSn = this.cacheHandle.getChannelRobot(parkCode, channelCode);
        String itcSn = this.itcCacheHandle.getSerialNumber(parkCode, channelCode);
        if (robotSn == null && itcSn == null) {
            return;
        }
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            ParkInoutdevice channel = paramHolder.getParkChannel();
            ObjectResponse plateTypeDtoObjectResponse = this.orderService.getPlateType(parkId, exitRequest.getPlateNum(), channel.getRegionId());
            PlateTypeDto plateTypeDto = (PlateTypeDto)plateTypeDtoObjectResponse.getData();
            exitRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
            FlowCondition.ResultCode resultCode = plateTypeDto.getPlateTypeEnum().equals((Object)PlateTypeEnum.\u6708\u5361\u8f66) ? FlowCondition.ResultCode.\u6708\u5361\u8f66 : FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39;
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("regionId", channel.getRegionId());
            para.put("orderNum", exitRequest.getOrderNum());
            if (enterTime != null) {
                para.put("parkTime", exitRequest.getExitTime() - enterTime);
            }
            String show = null;
            String say = null;
            if (robotSn != null) {
                show = this.commonShowHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para);
                say = this.commonSayHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para);
            }
            this.downOtherDeviceHint(exitRequest, show, say, para, resultCode);
        }));
    }
}

