/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl.exit;

import com.alibaba.fastjson.TypeReference;
import com.github.pagehelper.util.StringUtil;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryNotPayResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderTagsService;
import com.icetech.order.service.ShamPlateService;
import com.icetech.park.domain.entity.ShamPlate;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.park.ExitIdentify;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.mongo.document.ExitRecord;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.down.p2c.impl.FreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.down.p2r.impl.HintServiceImpl;
import com.icetech.park.service.down.p2r.impl.ShowPayInfoServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedSayHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.handle.showsay.ShowSayConstants;
import com.icetech.park.service.order.impl.exit.CarOrderExitServiceImpl;
import com.icetech.park.service.record.ExitRecordService;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.park.service.report.p2c.impl.exit.ExitIdentifyHandler;
import com.icetech.park.service.report.pnc.impl.PncAutopayServiceImpl;
import com.icetech.partner.api.request.ThirdAutoPayRequest;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class CarExitBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(CarExitBaseHandler.class);
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected CarOrderEnterService carOrderEnterService;
    @Autowired
    protected OrderPayService orderPayService;
    @Autowired
    protected CarOrderExitServiceImpl carOrderExitService;
    @Autowired
    protected HintServiceImpl robotHintService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected ChannelRulesServiceImpl channelRulesService;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected com.icetech.park.service.down.p2c.impl.HintServiceImpl hintService;
    @Autowired
    protected FreeSpaceServiceImpl freeSpaceService;
    @Autowired
    protected PncAutopayServiceImpl autopayService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected ShowPayInfoServiceImpl showPayInfoService;
    @Value(value="${web.url}")
    private String webUrl;
    @Value(value="${datacenter.exitPayUrl}")
    private String exitPayUrl;
    @Autowired
    protected CommonShowHandle commonShowHandle;
    @Autowired
    protected CommonSayHandle commonSayHandle;
    @Resource
    private ExitRecordService exitRecordService;
    @Autowired
    protected ThirdInfoService thirdInfoService;
    @Autowired
    protected LedShowHandle ledShowHandle;
    @Autowired
    protected ItcCacheHandle itcCacheHandle;
    @Autowired
    protected ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    protected ItcHintServiceImpl itcHintService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private SoftTriggerServiceImpl softTriggerService;
    @Autowired
    private ShamPlateService shamPlateService;
    @Autowired
    private OrderTagsService orderTagsService;
    @Resource
    private RabbitSender rabbitSender;
    @Value(value="${aisle.exceptionExit.time:600}")
    private Integer aisleExceptionExitTime;
    @Autowired
    private ExitIdentifyHandler exitIdentifyHandler;

    protected P2cBaseResponse<CarEnexResponse> softTrigger(P2cBaseRequest<CarExitRequest> baseRequest, CarExitRequest exitRequest, CarEnexResponse carEnexResponse, String parkCode, String inandoutCode) {
        String triggerNo = exitRequest.getTriggerNo();
        this.cacheHandle.setSoftImage(triggerNo, exitRequest.getMaxImage());
        if (exitRequest.getOpenFlag().equals(FlowCondition.YES)) {
            this.cacheHandle.removeExit(parkCode, inandoutCode);
        }
        String orderNum = CodeTools.GenerateOrderNum();
        log.info("[\u7aef\u4e91-\u51fa\u573a\u4e8b\u4ef6] \u8f6f\u89e6\u53d1\u63a5\u53e3\u8fd4\u56de\uff0ctriggerNo\uff1a{}\uff0c\u54cd\u5e94\u7684orderNum\u4e3a\uff1a{}", (Object)triggerNo, (Object)orderNum);
        carEnexResponse.setOrderNum(orderNum);
        String messageId = (String)this.redisUtils.get("messageId:triggerNo:" + triggerNo, String.class);
        if (messageId != null) {
            SendInfoRecord sendInfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, (TypeReference)new TypeReference<SendInfoRecord<SoftTriggerRequest>>(){});
            this.softTriggerService.notify(triggerNo, exitRequest, (SendInfoRecord<SoftTriggerRequest>)sendInfoRecord);
        }
        return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
    }

    protected void dealShamPlate(TokenDeviceVo deviceToken, CarExitRequest exitRequest, String parkCode, String inandoutCode, Long parkId) {
        OrderTags orderTags;
        ObjectResponse infoObjectResponse;
        ShamPlate shamPlate = new ShamPlate();
        shamPlate.setParkId(parkId);
        shamPlate.setPlateNum(exitRequest.getPlateNum());
        ObjectResponse objectResponse = this.orderService.getPlateType(parkId, exitRequest.getPlateNum(), deviceToken.getRegionId());
        shamPlate.setType(((PlateTypeDto)objectResponse.getData()).getPlateTypeEnum().getType());
        shamPlate.setExType(Integer.valueOf(2));
        shamPlate.setCarImage(exitRequest.getMaxImage());
        shamPlate.setAlarmTime(new Date(exitRequest.getExitTime() * 1000L));
        shamPlate.setChannelCode(inandoutCode);
        shamPlate.setChannelName(exitRequest.getInandoutName());
        CarExitRequest lastExit = this.cacheHandle.getExit(parkCode, inandoutCode);
        if (lastExit != null && !exitRequest.getPlateNum().equals(lastExit.getPlateNum())) {
            shamPlate.setRelCarImage(lastExit.getMaxImage());
            shamPlate.setRelPlateNum(lastExit.getPlateNum());
        }
        if (ObjectResponse.isSuccess((Response)(infoObjectResponse = this.orderService.findInParkId(exitRequest.getPlateNum(), parkId))) && (orderTags = this.orderTagsService.getListByOrderNumAndTagId(((OrderInfo)infoObjectResponse.getData()).getOrderNum(), Integer.valueOf(5), null)) != null) {
            shamPlate.setOrderNum(orderTags.getOrderNum());
        }
        this.shamPlateService.addShamPlate(shamPlate);
    }

    protected String replenishEnter(CarExitRequest carExitRequest) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        BeanUtils.copyProperties((Object)carExitRequest, (Object)carEnterRequest);
        carEnterRequest.setEnterTime(carExitRequest.getExitTime());
        carEnterRequest.setEnterWay(Integer.valueOf(1));
        carEnterRequest.setNoneEnterFlag(true);
        ObjectResponse enterObjectResponse = this.carOrderEnterService.enter(carEnterRequest);
        if (ObjectResponse.isSuccess((Response)enterObjectResponse)) {
            return ((CarEnterResult)enterObjectResponse.getData()).getOrderNum();
        }
        log.info("[\u7aef\u4e91-\u8131\u673a\u8865\u5145\u5165\u573a\u8ba2\u5355] \u5165\u573a\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)enterObjectResponse.getMsg());
        return null;
    }

    protected void dealOfflinePay(CarExitRequest exitRequest, String orderNum) {
        Integer paidAmountFen = exitRequest.getPaidAmountFen();
        if (exitRequest.getProperty() == 2 && paidAmountFen != null && paidAmountFen > 0) {
            PageQuery pageQuery = new PageQuery();
            OrderPay orderPayPara = new OrderPay();
            orderPayPara.setParkId(exitRequest.getParkId());
            orderPayPara.setOrderNum(orderNum);
            orderPayPara.setPayStatus(Integer.valueOf(2));
            pageQuery.setParam((Object)orderPayPara);
            ObjectResponse orderPayListObjectResponse = this.orderPayService.findList(pageQuery);
            if (ObjectResponse.isSuccess((Response)orderPayListObjectResponse)) {
                List orderPayList = (List)orderPayListObjectResponse.getData();
                for (OrderPay orderPay : orderPayList) {
                    if (orderPay.getPayTerminal() == null || !orderPay.getPayTerminal().startsWith("\u8131\u673a")) continue;
                    return;
                }
            }
            OrderPay orderPay = new OrderPay();
            orderPay.setPayStatus(Integer.valueOf(2));
            orderPay.setOrderNum(orderNum);
            orderPay.setChannelId(exitRequest.getInandoutCode());
            orderPay.setPayWay(Integer.valueOf(1));
            orderPay.setTradeNo(CodeTools.GenerateTradeNo());
            orderPay.setTotalPrice(String.valueOf((double)(paidAmountFen + exitRequest.getDiscountAmountFen()) / 100.0));
            orderPay.setPaidPrice(String.valueOf((double)paidAmountFen.intValue() / 100.0));
            orderPay.setPayTime(exitRequest.getOriginalExitTime());
            orderPay.setOrderTime(exitRequest.getExitTime());
            orderPay.setPayTerminal(exitRequest.getInandoutName());
            orderPay.setPayChannel(Integer.valueOf(10));
            orderPay.setDiscountPrice(String.valueOf((double)exitRequest.getDiscountAmountFen().intValue() / 100.0));
            orderPay.setIsSync(Integer.valueOf(0));
            ObjectResponse orderPayResponse = this.orderPayService.addOrderPay(orderPay);
            if (orderPayResponse == null || !"200".equals(orderPayResponse.getCode())) {
                log.error("[\u7aef\u4e91-\u8131\u673a\u51fa\u573a\u4e8b\u4ef6] \u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u5931\u8d25,\u53c2\u6570=[{}],\u54cd\u5e94=[{}]", (Object)orderPay, (Object)orderPayResponse);
            } else {
                log.info("[\u7aef\u4e91-\u8131\u673a\u51fa\u573a\u4e8b\u4ef6] \u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u6210\u529f,\u53c2\u6570=[{}],\u54cd\u5e94=[{}]", (Object)orderPay, (Object)orderPayResponse);
            }
        }
    }

    protected void downOtherDeviceHint(CarExitRequest exitRequest, String show, String say, Map<String, Object> param, FlowCondition.ResultCode resultCode) {
        String itcSn;
        String channelCode;
        Long parkId = exitRequest.getParkId();
        String parkCode = exitRequest.getParkCode();
        String serialNumber = this.cacheHandle.getChannelRobot(parkCode, channelCode = exitRequest.getInandoutCode());
        if (serialNumber != null) {
            RobotHintRequest robotHintRequest = new RobotHintRequest();
            robotHintRequest.setPlateNum(exitRequest.getPlateNum());
            robotHintRequest.setShow(show);
            robotHintRequest.setSay(say);
            this.robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
        }
        if ((itcSn = this.itcCacheHandle.getSerialNumber(parkCode, channelCode)) != null) {
            ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, channelCode);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            HintRequest itcHintRequest = HintRequest.builder().scene(Integer.valueOf(this.showSayBaseHandle.getSceneByResultCode(resultCode, 2))).plateNum(exitRequest.getPlateNum()).type(this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), param)).freeSpace(this.showSayBaseHandle.getFreeSpace(parkId, channel.getId(), param)).remainDaysMc(this.showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), exitRequest.getPlateNum(), param)).unpayPrice(param.get("fee") == null ? null : Integer.valueOf((int)(Float.parseFloat((String)param.get("fee")) * 100.0f))).parkTime((Long)param.get("parkTime")).build();
            if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(itcHintRequest.getType())) {
                itcHintRequest.setVipTypeName((String)param.get("carDesc"));
            }
            if (ShowSayConstants.QR_RESULT_LIST.contains((Object)resultCode)) {
                itcHintRequest.setQrCodeUrl(this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            this.itcHintService.execute(parkId, itcSn, itcHintRequest);
        }
    }

    protected P2cBaseResponse<CarEnexResponse> normalExit(P2cBaseRequest<CarExitRequest> baseRequest, ReportParamHolder paramHolder, CarEnexResponse carEnexResponse) {
        CarExitRequest exitRequest = (CarExitRequest)baseRequest.getBizContent();
        String parkCode = paramHolder.getParkCode();
        String channelId = exitRequest.getInandoutCode();
        exitRequest.setExitWay(Integer.valueOf(1));
        log.info("[\u7aef\u4e91-\u51fa\u573a\u4e8b\u4ef6] \u51c6\u5907\u8bf7\u6c42cloudcenter\u79bb\u573a\u670d\u52a1\uff0c\u53c2\u6570\uff1a{}", (Object)exitRequest);
        ObjectResponse<Map<String, Object>> objectResponse = this.carOrderExitService.exit(exitRequest, paramHolder);
        if (ObjectResponse.isSuccess(objectResponse)) {
            this.cacheHandle.removeExit(parkCode, channelId);
            this.cacheHandle.removeChannelFee(parkCode, channelId);
            Map data = (Map)objectResponse.getData();
            carEnexResponse.setOrderNum((String)data.get("orderNum"));
            if (paramHolder.getVersionIndex() < P2cVersionEnum.\u7248\u672c3.getIndex()) {
                this.showFreeSpace(exitRequest.getParkId(), parkCode, exitRequest.getPlateNum());
            }
            return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
        }
        log.error("[\u7aef\u4e91-\u51fa\u573a\u4e8b\u4ef6] \u6b63\u5e38\u79bb\u573a\u670d\u52a1\u5931\u8d25 parkCode[{}],{}", (Object)parkCode, objectResponse);
        return P2cBaseResponse.instance(baseRequest, (int)Integer.parseInt(objectResponse.getCode()));
    }

    protected void showFreeSpace(Long parkId, String parkCode, String plateNum) {
        String specialParkCode = "P1576060397,P1562641618";
        String ledSpecialParkCode = "P1574734634";
        if ("P1576060397,P1562641618".contains(parkCode) || ledSpecialParkCode.contains(parkCode)) {
            log.info("\u8fdb\u5165\u5b9a\u5236\u8f66\u573a\uff0cparkId\uff1a{}", (Object)parkId);
            ObjectResponse parkFreespaceObjectResponse = this.parkService.getParkSpace(parkId);
            log.info("\u67e5\u8be2\u7a7a\u8f66\u4f4d\uff0cparkFreespaceObjectResponse\uff1a{}", (Object)parkFreespaceObjectResponse);
            if (ObjectResponse.isSuccess((Response)parkFreespaceObjectResponse)) {
                String show = LedShowHandle.complement4Rows("" + ((ParkFreespace)parkFreespaceObjectResponse.getData()).getFreeSpace());
                com.icetech.cloudcenter.domain.request.p2c.HintRequest hintRequest = new com.icetech.cloudcenter.domain.request.p2c.HintRequest();
                hintRequest.setShow(show);
                hintRequest.setPlateNum(plateNum);
                ObjectResponse<Void> response = this.hintService.executeSendEnter(parkId, parkCode, hintRequest);
                if (!ObjectResponse.isSuccess(response)) {
                    log.info("\u79bb\u573a\u66f4\u65b0\u5165\u53e3\u5c4f\u663e\u7684\u7a7a\u8f66\u4f4d\u5931\u8d25\uff0c\u79bb\u573a\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                }
            }
        }
    }

    public P2cBaseResponse<CarEnexResponse> notOpenedFlowHandle(P2cBaseRequest<CarExitRequest> baseRequest, ReportParamHolder paramHolder, FlowCondition.FlowRet flowRet, Long parkTime) {
        CarExitRequest exitRequest = (CarExitRequest)baseRequest.getBizContent();
        String plateNum = exitRequest.getPlateNum();
        Long parkId = exitRequest.getParkId();
        String parkCode = paramHolder.getParkCode();
        String inandoutCode = exitRequest.getInandoutCode();
        String inandoutName = exitRequest.getInandoutName();
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("parkTime", parkTime);
        CarEnexResponse carEnexResponse = new CarEnexResponse();
        FlowCondition.ResultCode resultCode = flowRet.getResultCode();
        Map<Object, Object> paramMap = flowRet.getPara() == null ? new HashMap() : flowRet.getPara();
        QueryOrderFeeResponse queryOrderFeeResponse = (QueryOrderFeeResponse)paramMap.get("orderFee");
        QueryNotPayResponse queryNotPayResponse = paramHolder.queryNotPayFee();
        if (!FlowCondition.ResultCode.\u79bb\u573a\u9650\u5236.equals((Object)resultCode) && NumberUtils.parseDouble((Object)queryNotPayResponse.getTotalNotPayPrice()) > 0.0) {
            resultCode = FlowCondition.ResultCode.\u6b20\u8d39\u8865\u7f34;
        }
        log.info("FlowCondition.ResultCode exit > {} {}", (Object)resultCode, (Object)plateNum);
        switch (resultCode) {
            case \u79bb\u573a\u9650\u5236: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.carOrderExitService.sendWebsocketMessage(exitRequest, "1", carEnexResponse.getOpenFlag(), carEnexResponse.getOpenFlag())));
                return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
            }
            case \u6708\u5361\u8f66: 
            case \u5185\u90e8\u8f66\u8f86: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(plateNum + "/\u4e00\u8def\u987a\u98ce");
                carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                break;
            }
            case \u7279\u6b8a\u8f66\u8f86\u514d\u8d39: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                exitRequest.setType(PlateTypeEnum.\u7279\u6b8a\u8f66\u8f86.getType());
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(plateNum + "/\u4e00\u8def\u987a\u98ce");
                carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                break;
            }
            case \u65e0\u9700\u7f34\u8d39: {
                double discountPrice;
                double unpayPrice;
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (queryOrderFeeResponse != null && (unpayPrice = NumberUtils.toDouble((String)queryOrderFeeResponse.getUnpayPrice())) + (discountPrice = NumberUtils.toDouble((String)queryOrderFeeResponse.getDiscountPrice())) > 0.0) {
                    this.saveDiscountPay(inandoutName, inandoutCode, queryOrderFeeResponse, unpayPrice, discountPrice);
                }
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(plateNum + "/\u65e0\u9700\u7f34\u8d39/\u4e00\u8def\u987a\u98ce");
                carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                break;
            }
            case \u514d\u8d39\u65f6\u95f4\u5185: {
                int isreleaseFreetm = (Integer)paramMap.get("isreleaseFreetm");
                if (isreleaseFreetm == 1) {
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                } else {
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                }
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(plateNum + "/\u65e0\u9700\u7f34\u8d39/\u4e00\u8def\u987a\u98ce");
                carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                break;
            }
            case \u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(plateNum + "/\u65e0\u9700\u7f34\u8d39/\u4e00\u8def\u987a\u98ce");
                carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                break;
            }
            case \u9884\u7f34\u8d39\u672a\u8d85\u65f6: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    Object isDo = paramMap.get("isDo");
                    if (isDo != null && (Integer)isDo == 0) {
                        carEnexResponse.setOpenFlag(FlowCondition.NO);
                        return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
                    }
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(plateNum + "/\u5df2\u7f34\u8d39/\u4e00\u8def\u987a\u98ce");
                carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                break;
            }
            case \u9ed1\u540d\u5355\u8f66: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    Integer isShow = (Integer)paramMap.get("isShow");
                    para.put("isShow", isShow);
                    if (isShow != null && isShow == 0) break;
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow("\u9650\u884c\u8f66\u8f86/\u7981\u6b62\u901a\u884c");
                carEnexResponse.setSay("\u9650\u884c\u8f66\u8f86 \u3001\u7981\u6b62\u901a\u884c");
                break;
            }
            case \u9700\u7f34\u8d39: {
                boolean autoPayStatus;
                para.put("fee", queryOrderFeeResponse.getUnpayPrice());
                para.put("parkTime", queryOrderFeeResponse.getParkTime());
                boolean cardPayStatus = this.enterChargeStoreCard(queryOrderFeeResponse.getOrderNum(), parkId, queryOrderFeeResponse, paramHolder.getChannelCode());
                if (cardPayStatus) {
                    exitRequest.setType(PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType());
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39;
                    if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                        this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
                        break;
                    }
                    carEnexResponse.setShow(plateNum + "/\u4e00\u8def\u987a\u98ce");
                    carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                    break;
                }
                Map<String, Object> retMap = this.autoPay(queryOrderFeeResponse, parkCode, parkId, inandoutCode, paramHolder.getParkChannel().getId(), paramHolder.getParkChannel().getInandoutName(), exitRequest.getExitTime() - (parkTime == null ? 0L : parkTime), exitRequest.getType(), exitRequest.getPlateColor());
                boolean bl = autoPayStatus = retMap != null;
                if (autoPayStatus) {
                    double aDouble;
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39;
                    if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                        this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
                    } else {
                        carEnexResponse.setShow(plateNum + "/\u4e00\u8def\u987a\u98ce");
                        carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                    }
                    if (!Boolean.TRUE.equals(retMap.get("isAfterPay"))) break;
                    exitRequest.setTotalAmount(queryOrderFeeResponse.getTotalAmount());
                    exitRequest.setPaidAmount(queryOrderFeeResponse.getPaidAmount());
                    double dis = 0.0;
                    String discountAmount = queryOrderFeeResponse.getDiscountAmount();
                    String discountPrice1 = queryOrderFeeResponse.getDiscountPrice();
                    if (StringUtil.isNotEmpty((String)discountAmount)) {
                        aDouble = Double.parseDouble(discountAmount);
                        dis += aDouble;
                    }
                    if (StringUtil.isNotEmpty((String)discountPrice1)) {
                        aDouble = Double.parseDouble(discountPrice1);
                        dis += aDouble;
                    }
                    exitRequest.setDiscountAmount(String.valueOf(dis));
                    exitRequest.setUnpayPrice(queryOrderFeeResponse.getUnpayPrice());
                    exitRequest.setIsAfterPay(Integer.valueOf(1));
                    break;
                }
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    para.put("hasInnerAreaFee", queryOrderFeeResponse.getHasInnerAreaFee());
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(LedShowHandle.needPay(parkCode, plateNum, queryOrderFeeResponse.getParkTime(), queryOrderFeeResponse.getUnpayPrice()));
                carEnexResponse.setSay(LedSayHandle.needPay(parkCode, plateNum, queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getParkTime()));
                break;
            }
            case \u65e0\u5165\u573a\u8bb0\u5f55: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow("\u65e0\u5165\u573a\u4fe1\u606f/\u8bf7\u626b\u7801\u8054\u7cfb\u7ba1\u7406\u5458");
                carEnexResponse.setSay("\u65e0\u5165\u573a\u4fe1\u606f\uff0c\u8bf7\u626b\u7801\u8054\u7cfb\u7ba1\u7406\u5458\u534f\u52a9");
                break;
            }
            case \u56fa\u5b9a\u8d39\u7528: {
                para.put("fee", queryOrderFeeResponse.getUnpayPrice());
                para.put("parkTime", queryOrderFeeResponse.getParkTime());
                float fixedFee = Float.parseFloat(queryOrderFeeResponse.getUnpayPrice());
                if (fixedFee >= 0.0f) {
                    if (fixedFee > 0.0f) {
                        float f = fixedFee = this.enterChargeStoreCard(queryOrderFeeResponse.getOrderNum(), parkId, queryOrderFeeResponse, paramHolder.getChannelCode()) ? 0.0f : fixedFee;
                    }
                    if (fixedFee == 0.0f) {
                        exitRequest.setType(PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType());
                        carEnexResponse.setOpenFlag(FlowCondition.YES);
                        resultCode = FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39;
                        if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                            this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
                            break;
                        }
                        carEnexResponse.setShow(plateNum + "/\u4e00\u8def\u987a\u98ce");
                        carEnexResponse.setSay("\u4e00\u8def\u987a\u98ce");
                        break;
                    }
                }
                exitRequest.setOrderNum(queryOrderFeeResponse.getOrderNum());
                paramHolder.setOrderNum(queryOrderFeeResponse.getOrderNum());
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow(plateNum + "/\u8bf7\u7f34\u8d39" + queryOrderFeeResponse.getUnpayPrice() + "\u5143");
                carEnexResponse.setSay(LedSayHandle.needPay(parkCode, plateNum, queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getParkTime()));
                break;
            }
            case \u65e0\u5165\u573aVIP\u5168\u514d\u8f66: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                exitRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
                para.putAll(paramMap);
                this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                break;
            }
            case \u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                exitRequest.setAllowExit(Boolean.valueOf(false));
                this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                break;
            }
            case \u6b20\u8d39\u8865\u7f34: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                AssertTools.notNull((Object)queryNotPayResponse, (String)"400", (String)"\u6b20\u8d39\u8bb0\u5f55\u4e3a\u7a7a");
                if (queryOrderFeeResponse == null) {
                    queryOrderFeeResponse = QueryOrderFeeResponse.buildEmptyOrderFee((String)plateNum, (String)paramHolder.getParkInfo().getParkName(), (Integer)paramHolder.getParkConfig().getIsfreeAfterpay(Integer.valueOf(15)), (Integer)1, (String)exitRequest.getOrderNum());
                }
                BigDecimal sumPrice = new BigDecimal(queryOrderFeeResponse.getUnpayPrice()).add(new BigDecimal(queryNotPayResponse.getTotalNotPayPrice()));
                queryOrderFeeResponse.setSumPrice(sumPrice.toString());
                queryOrderFeeResponse.setTotalNotPayPrice(queryNotPayResponse.getTotalNotPayPrice());
                queryOrderFeeResponse.setNotPayDetails(queryNotPayResponse.getNotPayDetails());
                para.put("fee", sumPrice.toString());
                para.put("parkTime", queryOrderFeeResponse.getParkTime());
                this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                break;
            }
            default: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (paramHolder.getVersionIndex() >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(parkId, exitRequest, carEnexResponse, para, resultCode);
                    break;
                }
                carEnexResponse.setShow("\u8bf7\u626b\u4e8c\u7ef4\u7801\u7f34\u8d39\u540e\u51fa\u573a");
                carEnexResponse.setSay("\u8bf7\u626b\u7801\u7f34\u8d39");
            }
        }
        boolean setExitCache = true;
        if (carEnexResponse.getOpenFlag().equals(FlowCondition.NO)) {
            CarExitRequest cacheExit = this.cacheHandle.getExit(parkCode, inandoutCode);
            if (cacheExit != null) {
                String cachePlateNum = cacheExit.getPlateNum();
                if (DataCommonConstants.isNoPlate((String)exitRequest.getPlateNum()) && !DataCommonConstants.isNoPlate((String)cachePlateNum)) {
                    setExitCache = false;
                }
            }
            if (setExitCache) {
                this.cacheHandle.setExit(parkCode, inandoutCode, exitRequest, queryOrderFeeResponse);
            }
        } else {
            setExitCache = false;
        }
        this.asyncHandle(resultCode, exitRequest, carEnexResponse, parkCode, inandoutCode, plateNum, parkId, paramHolder, para, setExitCache, queryOrderFeeResponse, inandoutName, parkTime);
        if (StringUtils.isNotBlank((CharSequence)exitRequest.getOrderNum()) && carEnexResponse.getOpenFlag().equals(FlowCondition.YES)) {
            return this.normalExit(baseRequest, paramHolder, carEnexResponse);
        }
        return P2cBaseResponse.success(baseRequest, (Object)carEnexResponse);
    }

    private void asyncHandle(FlowCondition.ResultCode resultCode, CarExitRequest exitRequest, CarEnexResponse carEnexResponse, String parkCode, String channelCode, String plateNum, Long parkId, ReportParamHolder paramHolder, Map<String, Object> para, boolean setExitCache, QueryOrderFeeResponse queryOrderFeeResponse, String channelName, Long parkTime) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            if (setExitCache) {
                this.rabbitSender.sendMessage("aisle.delayed.exchange", "aisle.need.pay.routing", (Object)exitRequest, Long.valueOf((long)this.aisleExceptionExitTime.intValue() * 1000L));
                log.info("[\u7aef\u4e91-\u51fa\u53e3] \u5f85\u652f\u4ed8\u8ba2\u5355\u8fdf\u5ef6\u6d88\u606f\u53d1\u9001, [{}]", (Object)exitRequest);
                ObjectResponse parkConfig = this.parkService.getParkConfig(exitRequest.getParkId());
                if (ObjectResponse.isSuccess((Response)parkConfig)) {
                    AisleInfoVo aisleInfoVo = AisleInfoVo.builder().aisleCode(channelCode).aisleType(Integer.valueOf(2)).parkCode(parkCode).parkId(exitRequest.getParkId()).orderNum(exitRequest.getOrderNum()).build();
                    if (Objects.nonNull(((ParkConfig)parkConfig.getData()).getCarenexTimelong()) && ((ParkConfig)parkConfig.getData()).getCarenexTimelong() > 0) {
                        this.rabbitSender.sendMessage("aisle.delayed.exchange", "aisle.duration.alarm.routing", (Object)aisleInfoVo, Long.valueOf((long)(((ParkConfig)parkConfig.getData()).getCarenexTimelong() * 60) * 1000L));
                    }
                }
                ExitIdentify exitIdentify = ExitIdentify.builder().parkId(parkId).parkCode(parkCode).plateNum(exitRequest.getPlateNum()).type(exitRequest.getType()).parkTime(parkTime).channelCode(channelCode).channelName(channelName).reasonType(resultCode.getCode()).timestamp(exitRequest.getExitTime()).build();
                if (queryOrderFeeResponse != null) {
                    exitIdentify.setOrderNum(queryOrderFeeResponse.getOrderNum());
                    exitIdentify.setTotalAmount(queryOrderFeeResponse.getTotalAmount());
                    exitIdentify.setPaidAmount(queryOrderFeeResponse.getPaidAmount());
                    exitIdentify.setDiscountAmount(queryOrderFeeResponse.getDiscountAmount());
                    exitIdentify.setDiscountPrice(queryOrderFeeResponse.getDiscountPrice());
                    exitIdentify.setUnpayPrice(queryOrderFeeResponse.getUnpayPrice());
                    exitIdentify.setQueryTime(queryOrderFeeResponse.getQueryTime());
                    exitIdentify.setEnterTime(queryOrderFeeResponse.getEnterTime());
                }
                if (ShowSayConstants.QR_RESULT_LIST.contains((Object)resultCode)) {
                    exitIdentify.setQrCodeUrl(this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                }
                this.exitIdentifyHandler.exitIdentify(exitIdentify);
            }
            this.carOrderExitService.sendWebsocketMessage(exitRequest, FlowCondition.ResultCode.\u65e0\u5165\u573a\u8bb0\u5f55.equals((Object)resultCode) ? "6" : (carEnexResponse.getOpenFlag().equals(FlowCondition.YES) ? "2" : "1"), FlowCondition.YES, NumberUtils.parseDouble(para.get("fee")) > 0.0 ? FlowCondition.NO : FlowCondition.YES);
            String serialNumber = this.cacheHandle.getChannelRobot(parkCode, channelCode);
            if (serialNumber != null) {
                RobotHintRequest robotHintRequest;
                if (ShowSayConstants.PAY_LIST.contains((Object)resultCode)) {
                    ShowPayInfoRequest showPayInfoRequest = new ShowPayInfoRequest();
                    showPayInfoRequest.setOrderNum(exitRequest.getOrderNum());
                    showPayInfoRequest.setNoticeMsg("\u8bf7\u4f7f\u7528\u5fae\u4fe1\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8");
                    showPayInfoRequest.setShow(plateNum + "/" + para.get("fee") + "\u5143/" + DateTools.secondToSecondsTime((int)NumberUtils.parseInteger(para.get("parkTime"))) + "/" + PlateTypeEnum.getName((Integer)exitRequest.getType()));
                    showPayInfoRequest.setQrCodeUrl(this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                    String thirdPayUrl = this.commonShowHandle.getThirdPayUrl(parkId, exitRequest.getParkCode(), exitRequest.getInandoutCode(), exitRequest.getOrderNum(), plateNum, para);
                    if (!TextUtils.isEmpty((CharSequence)thirdPayUrl)) {
                        showPayInfoRequest.setQrCodeUrl(thirdPayUrl);
                    }
                    this.showPayInfoService.executeDown(parkId, serialNumber, showPayInfoRequest);
                    robotHintRequest = new RobotHintRequest();
                    robotHintRequest.setPlateNum(exitRequest.getPlateNum());
                    robotHintRequest.setShow("");
                    String say = carEnexResponse.getSay();
                    robotHintRequest.setSay(say);
                    this.robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
                } else {
                    String show = carEnexResponse.getShow();
                    String say = carEnexResponse.getSay();
                    robotHintRequest = new RobotHintRequest();
                    robotHintRequest.setPlateNum(exitRequest.getPlateNum());
                    robotHintRequest.setShow(show);
                    robotHintRequest.setSay(say);
                    this.robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
                }
            }
            String itcSn = this.itcCacheHandle.getSerialNumber(parkCode, channelCode);
            log.debug("\u5bf9\u8bb2\u7acb\u67f1SN[{}]", (Object)itcSn);
            if (itcSn != null) {
                ParkInoutdevice channel = paramHolder.getParkChannel();
                HintRequest itcHintRequest = HintRequest.builder().scene(Integer.valueOf(this.showSayBaseHandle.getSceneByResultCode(resultCode, 2))).plateNum(exitRequest.getPlateNum()).type(this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), para)).freeSpace(this.showSayBaseHandle.getFreeSpace(parkId, channel.getId(), para)).remainDaysMc(this.showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), exitRequest.getPlateNum(), para)).unpayPrice(para.get("fee") == null ? null : Integer.valueOf((int)(Float.parseFloat((String)para.get("fee")) * 100.0f))).parkTime((Long)para.get("parkTime")).build();
                if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(itcHintRequest.getType())) {
                    itcHintRequest.setVipTypeName((String)para.get("carDesc"));
                }
                if (ShowSayConstants.QR_RESULT_LIST.contains((Object)resultCode)) {
                    itcHintRequest.setQrCodeUrl(this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                }
                log.debug("\u5bf9\u8bb2\u7acb\u67f1\u4e0b\u53d1[{}]", (Object)itcHintRequest);
                this.itcHintService.execute(parkId, itcSn, itcHintRequest);
            }
        }));
    }

    protected void setCustomShowSay(Long parkId, CarExitRequest exitRequest, CarEnexResponse carEnexResponse, Map<String, Object> para, FlowCondition.ResultCode resultCode) {
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, exitRequest.getInandoutCode());
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        Integer ledLcdSource = channel.getLedLcdSource();
        carEnexResponse.setShowDeviceType(ledLcdSource);
        para.put("regionId", ((ParkInoutdevice)channelResp.getData()).getRegionId());
        para.put("orderNum", exitRequest.getOrderNum());
        String show = this.commonShowHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para, ledLcdSource);
        String say = this.commonSayHandle.exit(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para, ledLcdSource);
        if (ledLcdSource == 2) {
            if (ShowSayConstants.QR_RESULT_LIST.contains((Object)resultCode)) {
                carEnexResponse.setQrCodeUrl(this.commonShowHandle.replacePara(this.exitPayUrl, new String[]{exitRequest.getParkCode(), exitRequest.getInandoutCode()}));
                String thirdPayUrl = this.commonShowHandle.getThirdPayUrl(parkId, exitRequest.getParkCode(), exitRequest.getInandoutCode(), exitRequest.getOrderNum(), exitRequest.getPlateNum(), para);
                if (!TextUtils.isEmpty((CharSequence)thirdPayUrl)) {
                    carEnexResponse.setQrCodeUrl(thirdPayUrl);
                }
            }
        } else {
            carEnexResponse.setShowTypeByShow(show);
            if (carEnexResponse.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal() || carEnexResponse.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                show = this.commonShowHandle.replacePara(show, new String[]{exitRequest.getParkCode(), exitRequest.getInandoutCode()});
                String thirdPayUrl = this.commonShowHandle.getThirdPayUrl(parkId, exitRequest.getParkCode(), exitRequest.getInandoutCode(), exitRequest.getOrderNum(), exitRequest.getPlateNum(), para);
                if (!TextUtils.isEmpty((CharSequence)thirdPayUrl)) {
                    if (carEnexResponse.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                        String[] strings = show.split("\\|");
                        strings[1] = thirdPayUrl;
                        show = StringUtils.joinWith((String)"|", (Object[])strings);
                    } else {
                        show = thirdPayUrl;
                    }
                }
                if (carEnexResponse.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal()) {
                    String extendShow = this.ledShowHandle.generate4LineContent(parkId, channel.getId(), exitRequest.getPlateNum(), exitRequest.getType(), resultCode, para, LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
                    carEnexResponse.setExtendShow(extendShow);
                }
            }
        }
        carEnexResponse.setShow(show);
        carEnexResponse.setSay(say);
    }

    private Map<String, Object> autoPay(QueryOrderFeeResponse queryOrderFeeResponse, String parkCode, Long parkId, String inandoutCode, Long channelId, String channelName, Long enterTime, Integer type, String plateColor) {
        ThirdAutoPayRequest autopayRequest = new ThirdAutoPayRequest();
        autopayRequest.setOrderNum(queryOrderFeeResponse.getOrderNum());
        autopayRequest.setPlateNum(queryOrderFeeResponse.getPlateNum());
        String unpayPrice = queryOrderFeeResponse.getUnpayPrice();
        String discountPrice = queryOrderFeeResponse.getDiscountPrice();
        autopayRequest.setTotalPrice(String.valueOf(NumberUtils.toFloat((String)unpayPrice) + NumberUtils.toFloat((String)discountPrice)));
        autopayRequest.setUnpayPrice(unpayPrice);
        autopayRequest.setDiscountPrice(discountPrice);
        autopayRequest.setParkTime(Integer.valueOf(queryOrderFeeResponse.getParkTime().intValue()));
        autopayRequest.setPayTime(queryOrderFeeResponse.getQueryTime());
        autopayRequest.setChannelCode(inandoutCode);
        autopayRequest.setChannelId(channelId);
        autopayRequest.setParkId(parkId);
        autopayRequest.setParkCode(parkCode);
        autopayRequest.setEnterTime(enterTime);
        autopayRequest.setType(type);
        autopayRequest.setChannelName(channelName);
        autopayRequest.setPlateColor(plateColor);
        autopayRequest.setTotalAmount(queryOrderFeeResponse.getTotalAmount());
        ObjectResponse<Map<String, Object>> objectResponse = this.autopayService.report(parkCode, parkId, autopayRequest);
        return (Map)objectResponse.getData();
    }

    protected void saveDiscountPay(String inandoutName, String inandoutCode, QueryOrderFeeResponse queryOrderFeeResponse, double unpayPrice, double discountPrice) {
        OrderPay orderPay = new OrderPay();
        orderPay.setPayStatus(Integer.valueOf(2));
        orderPay.setOrderNum(queryOrderFeeResponse.getOrderNum());
        orderPay.setChannelId(inandoutCode);
        orderPay.setPayWay(Integer.valueOf(10));
        orderPay.setTradeNo(CodeTools.GenerateTradeNo());
        orderPay.setLastPayTime(queryOrderFeeResponse.getPayTime());
        orderPay.setTotalPrice(String.valueOf(unpayPrice + discountPrice));
        orderPay.setPaidPrice(queryOrderFeeResponse.getUnpayPrice());
        orderPay.setPayTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        orderPay.setOrderTime(queryOrderFeeResponse.getQueryTime());
        orderPay.setPayTerminal(inandoutName);
        orderPay.setPayChannel(Integer.valueOf(1));
        orderPay.setDiscountPrice(queryOrderFeeResponse.getDiscountPrice());
        ObjectResponse orderPayResponse = this.orderPayService.addOrderPay(orderPay);
        if (orderPayResponse == null || !"200".equals(orderPayResponse.getCode())) {
            log.error("[\u7aef\u4e91-\u51fa\u573a\u4e8b\u4ef6]\u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u5931\u8d25,\u53c2\u6570=[{}],\u54cd\u5e94=[{}]", (Object)orderPay, (Object)JsonUtils.toString((Object)orderPayResponse));
        } else {
            log.info("[\u7aef\u4e91-\u51fa\u573a\u4e8b\u4ef6]\u4fdd\u5b58\u4ea4\u6613\u8bb0\u5f55\u6210\u529f,\u53c2\u6570=[{}],\u54cd\u5e94=[{}]", (Object)orderPay, (Object)JsonUtils.toString((Object)orderPayResponse));
        }
    }

    public boolean enterChargeStoreCard(String orderNum, Long parkId, QueryOrderFeeResponse queryOrderFeeResponse, String channelCode) {
        ObjectResponse objectResponse = this.orderService.chargeStoreCardComplete(queryOrderFeeResponse, orderNum, parkId, channelCode);
        return null != objectResponse && "200".equals(objectResponse.getCode());
    }

    public void addExitRecord(CarExitRequest exitRequest) {
        ExitRecord record = new ExitRecord();
        BeanUtils.copyProperties((Object)exitRequest, (Object)record);
        record.setExitNo(exitRequest.getInandoutName());
        record.setImage(exitRequest.getMaxImage());
        record.setSmallImage(exitRequest.getSmallImage());
        this.exitRecordService.saveRecordAsync(record);
    }
}

