/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl.enter;

import com.google.common.collect.Maps;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryNotPayResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.p2c.impl.OfflineRecordServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.flow.p2c.impl.CarEnterFlowProcessImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.park.service.report.p2c.impl.enter.CarEnterBaseHandler;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class CarEnterHandler
extends CarEnterBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(CarEnterHandler.class);
    @Autowired
    private CarEnterFlowProcessImpl carEnterFlowProcess;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OfflineRecordServiceImpl offlineRecordService;
    @Autowired
    private RabbitSender rabbitSender;
    private static final String OFFLINE_RECORDS_PREFIX = "offline:record:";
    private static final Long OFFSET = 10L;
    private static final Long SYS_START_TIME = 1546272000L;
    @Value(value="${custom.repeatEx.enable:false}")
    private boolean customRepeatExEnable;
    @Value(value="${custom.repeatEx.parkCodes:P}")
    private String customRepeatExParkCodes;
    @Value(value="${custom.repeatEx.showDevice:1}")
    private Integer customRepeatExShowDevice;

    public CarEnexResponse execute(CarEnterRequest enterRequest, String deviceNo, String version) {
        String orderNum;
        CarEnexResponse carEnexResponse = new CarEnexResponse();
        Long parkId = enterRequest.getParkId();
        String parkCode = enterRequest.getParkCode();
        Integer triggerType = enterRequest.getTriggerType();
        String channelCode = enterRequest.getInandoutCode();
        Long enterTime = enterRequest.getEnterTime();
        long now = DateTools.unixTimestamp();
        if (now + OFFSET < enterTime) {
            log.warn("alarmType[{}],keyword1[{}],keyword2[SN:{}, \u4e0a\u62a5\u5165\u573a\u65f6\u95f4:{}]", new Object[]{"\u7aef\u4e91\u76f8\u673a\u65f6\u95f4\u504f\u5927", parkCode, deviceNo, enterTime});
            enterRequest.setEnterTime(Long.valueOf(now));
        }
        if (SYS_START_TIME > enterTime) {
            log.warn("alarmType[{}],keyword1[{}],keyword2[SN:{}, \u4e0a\u62a5\u5165\u573a\u65f6\u95f4:{}]", new Object[]{"\u7aef\u4e91\u76f8\u673a\u65f6\u95f4\u504f\u5c0f", parkCode, deviceNo, enterTime});
            enterRequest.setEnterTime(Long.valueOf(now));
        }
        ReportParamHolder paramHolder = new ReportParamHolder(enterRequest.getParkId(), enterRequest.getParkCode(), enterRequest.getInandoutCode(), deviceNo, version, enterRequest.getPlateNum(), 1, null);
        if (triggerType.equals(TriggerTypeEnum.\u8f6f\u89e6\u53d1.getVal())) {
            this.redisUtils.releaseLock("softTrigger:" + deviceNo);
            String orderNum2 = this.dealSoftTrigger(enterRequest);
            if (enterRequest.getProperty() == 2 || enterRequest.getOpenFlag().equals(FlowCondition.YES)) {
                this.cacheHandle.removeEntrace(parkCode, channelCode);
            }
            carEnexResponse.setOrderNum(orderNum2);
            if (enterRequest.getOpenFlag().equals(FlowCondition.NO)) {
                return carEnexResponse;
            }
        }
        if (Integer.valueOf(0).equals(enterRequest.getShamFlag())) {
            ParkConfig parkConfig = paramHolder.getParkConfig();
            Integer enableShamPlate = parkConfig.getEnableShamPlate();
            if (Integer.valueOf(1).equals(enableShamPlate)) {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, null, FlowCondition.ResultCode.\u865a\u5047\u8f66\u724c);
                this.dealShamePlate(enterRequest, paramHolder);
                return carEnexResponse;
            }
        }
        if (enterRequest.getProperty() == 2) {
            carEnexResponse.setOpenFlag(Integer.valueOf(0));
            carEnexResponse.setShow(null);
            carEnexResponse.setSay(null);
            Park parkInfo = paramHolder.getParkInfo();
            if (Integer.valueOf(1).equals(parkInfo.getIsInterior())) {
                this.cacheHandle.cacheEnterRecords(parkCode, enterRequest.getPlateNum(), enterRequest);
                if (this.redisUtils.tryLock(OFFLINE_RECORDS_PREFIX + parkCode + "_" + enterRequest.getPlateNum(), parkCode, 4000L)) {
                    this.offlineRecordService.send(parkId, parkCode, enterRequest.getPlateNum());
                    this.rabbitSender.sendMessage(MqConstants.Exchange.OFFLINE_RECORDS_DELAYED_EXCHANGE, "offline.records.routing", (Object)(parkCode + "_" + enterRequest.getPlateNum()), Long.valueOf(20000L));
                }
            } else {
                String orderNum3 = this.normalEnter(enterRequest, paramHolder, parkCode, channelCode);
                carEnexResponse.setOrderNum(orderNum3);
            }
            return carEnexResponse;
        }
        if (FlowCondition.YES.equals(enterRequest.getOpenFlag())) {
            String robotSn = this.cacheHandle.getChannelRobot(parkCode, channelCode);
            String itcSn = this.itcCacheHandle.getSerialNumber(parkCode, channelCode);
            if (robotSn != null || itcSn != null) {
                this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                    FlowCondition.ResultCode resultCode;
                    ParkInoutdevice channel = paramHolder.getParkChannel();
                    ObjectResponse plateTypeDtoObjectResponse = this.orderService.getPlateType(parkId, enterRequest.getPlateNum(), channel.getRegionId());
                    PlateTypeDto plateTypeDto = (PlateTypeDto)plateTypeDtoObjectResponse.getData();
                    enterRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
                    HashMap para = Maps.newHashMap();
                    PlateTypeEnum plateTypeEnum = plateTypeDto.getPlateTypeEnum();
                    switch (plateTypeEnum) {
                        case VIP\u8f66\u8f86: {
                            String carDesc = plateTypeDto.getCarDesc();
                            if (carDesc != null) {
                                para.put("carDesc", carDesc);
                            }
                            resultCode = FlowCondition.ResultCode.VIP\u8f66\u8f86;
                            break;
                        }
                        case \u6708\u5361\u8f66: {
                            resultCode = FlowCondition.ResultCode.\u6708\u5361\u8f66;
                            break;
                        }
                        default: {
                            resultCode = FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165;
                        }
                    }
                    para.put("regionId", channel.getRegionId());
                    para.put("enexType", 1);
                    para.put("channelCode", channel.getInandoutCode());
                    String show = null;
                    String say = null;
                    if (robotSn != null) {
                        show = this.commonShowHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                        say = this.commonSayHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                    }
                    this.downOtherDeviceHint(enterRequest, show, say, para, resultCode);
                }));
            }
            String orderNum4 = this.normalEnter(enterRequest, paramHolder, parkCode, channelCode);
            carEnexResponse.setOrderNum(orderNum4);
            this.spaceDown(enterRequest, carEnexResponse, paramHolder);
            return carEnexResponse;
        }
        if (this.customRepeatExEnable && this.customRepeatExParkCodes.contains(parkCode)) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setParkId(parkId);
            orderInfo.setPlateNum(enterRequest.getPlateNum());
            ObjectResponse infoObjectResponse = this.orderService.findByOrderInfo(orderInfo);
            if (ObjectResponse.isSuccess((Response)infoObjectResponse) && ((OrderInfo)infoObjectResponse.getData()).getServiceStatus() == 1) {
                log.info("[\u5b9a\u5236\u529f\u80fd-\u91cd\u590d\u5165\u573a] {}", (Object)enterRequest);
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u6b64\u8f66\u5df2\u5165\u573a/\u8bf7\u52ff\u91cd\u590d\u5165\u573a/\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                carEnexResponse.setSay("\u6b64\u8f66\u5df2\u5165\u573a \u8bf7\u52ff\u91cd\u590d\u5165\u573a");
                carEnexResponse.setShowDeviceType(this.customRepeatExShowDevice);
                return carEnexResponse;
            }
        }
        FlowCondition.FlowRet flowRet = this.carEnterFlowProcess.flowHandle(enterRequest, paramHolder);
        FlowCondition.ResultCode resultCode = flowRet.getResultCode();
        log.info("FlowCondition.ResultCode enter > {} {}", (Object)resultCode, (Object)enterRequest.getPlateNum());
        Map<Object, Object> param = flowRet.getPara() == null ? new HashMap() : flowRet.getPara();
        switch (resultCode) {
            case \u5165\u573a\u9650\u5236: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.carOrderEnterService.sendWebsocketMessage(enterRequest, FlowCondition.NO)));
                return carEnexResponse;
            }
            case \u6708\u5361\u8f66: {
                enterRequest.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u6708\u79df\u8f66");
                carEnexResponse.setSay("\u6b22\u8fce\u5149\u4e34");
                break;
            }
            case \u8fc7\u671f\u5361: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                Boolean isMonth = (Boolean)param.get("isMonth");
                if (isMonth != null && isMonth.booleanValue()) {
                    enterRequest.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
                } else {
                    enterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
                }
                this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            }
            case \u5185\u90e8\u8f66\u8f86: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                enterRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u6b22\u8fce\u5149\u4e34");
                carEnexResponse.setSay("\u6b22\u8fce\u5149\u4e34");
            }
            case VIP\u8f66\u8f86: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                enterRequest.setType(PlateTypeEnum.VIP\u8f66\u8f86.getType());
                this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            }
            case \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: {
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("\u9102")) {
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "\u3001\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    break;
                }
                enterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u6b22\u8fce\u5149\u4e34");
                carEnexResponse.setSay("\u6b22\u8fce\u5149\u4e34");
                break;
            }
            case \u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165: {
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("\u9102")) {
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "\u3001\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    break;
                }
                enterRequest.setType(PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType());
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u6b22\u8fce\u5149\u4e34");
                carEnexResponse.setSay("\u6b22\u8fce\u5149\u4e34");
                break;
            }
            case \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: {
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("\u9102")) {
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "\u3001\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    break;
                }
                if (DingZhiFuncConstants.DZ004_PARKS.contains(parkCode) && enterRequest.getPlateColor().contains("\u7eff")) {
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165;
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u7981\u6b62\u901a\u884c");
                carEnexResponse.setSay("\u4e34\u65f6\u8f66\u3001\u7981\u6b62\u901a\u884c");
                break;
            }
            case \u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165: {
                if (DingZhiFuncConstants.DZ002_PARKS.contains(parkCode) && enterRequest.getPlateNum().contains("\u9102")) {
                    carEnexResponse.setOpenFlag(FlowCondition.NO);
                    carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    carEnexResponse.setSay(enterRequest.getPlateNum() + "\u3001\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4");
                    break;
                }
                enterRequest.setType(PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType());
                if (DingZhiFuncConstants.DZ004_PARKS.contains(parkCode) && enterRequest.getPlateColor().contains("\u7eff")) {
                    carEnexResponse.setOpenFlag(FlowCondition.YES);
                    resultCode = FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165;
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u7981\u6b62\u901a\u884c");
                carEnexResponse.setSay("\u4e34\u65f6\u8f66\u3001\u7981\u6b62\u901a\u884c");
                break;
            }
            case \u9ed1\u540d\u5355\u8f66: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    Integer isShow = (Integer)param.get("isShow");
                    if (isShow != null && isShow == 0) break;
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow(enterRequest.getPlateNum() + "/\u7981\u6b62\u901a\u884c");
                carEnexResponse.setSay("\u9650\u884c\u8f66\u8f86 \u3001\u7981\u6b62\u901a\u884c");
                break;
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow("\u8bf7\u626b\u4e8c\u7ef4\u7801\u8fdb\u573a");
                carEnexResponse.setSay("\u8bf7\u626b\u7801\u8fdb\u573a");
                break;
            }
            case \u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (param.get("type") != null) {
                    enterRequest.setType((Integer)param.get("type"));
                }
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow("\u8f66\u4f4d\u5df2\u6ee1/\u7981\u6b62\u901a\u884c");
                carEnexResponse.setSay("\u8f66\u4f4d\u5df2\u6ee1 \u3001\u7981\u6b62\u901a\u884c");
                break;
            }
            case \u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow("\u9ec4\u724c\u8f66/\u7981\u6b62\u901a\u884c");
                carEnexResponse.setSay("\u9ec4\u724c\u8f66 \u3001\u7981\u6b62\u901a\u884c");
                break;
            }
            case \u8bbf\u5ba2\u8f66: {
                carEnexResponse.setOpenFlag(FlowCondition.YES);
                enterRequest.setType(PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
                this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            }
            case \u6b20\u8d39\u8865\u7f34: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                QueryNotPayResponse queryNotPayResponse = (QueryNotPayResponse)param.get("notPayFee");
                AssertTools.notNull((Object)queryNotPayResponse, (String)"400", (String)"\u6b20\u8d39\u8bb0\u5f55\u4e3a\u7a7a");
                QueryOrderFeeResponse queryOrderFeeResponse = QueryOrderFeeResponse.buildEmptyOrderFee((String)enterRequest.getPlateNum(), (String)paramHolder.getParkInfo().getParkName(), (Integer)paramHolder.getParkConfig().getIsfreeAfterpay(Integer.valueOf(15)), (Integer)enterRequest.getCarType(), (String)enterRequest.getOrderNum());
                BigDecimal sumPrice = new BigDecimal(queryOrderFeeResponse.getUnpayPrice()).add(new BigDecimal(queryNotPayResponse.getTotalNotPayPrice()));
                queryOrderFeeResponse.setSumPrice(sumPrice.toString());
                queryOrderFeeResponse.setTotalNotPayPrice(queryNotPayResponse.getTotalNotPayPrice());
                queryOrderFeeResponse.setNotPayDetails(queryNotPayResponse.getNotPayDetails());
                param.put("fee", sumPrice.toString());
                param.put("parkTime", queryOrderFeeResponse.getParkTime());
                param.put("orderFee", queryOrderFeeResponse);
                this.cacheHandle.setChannelFee(parkCode, enterRequest.getInandoutCode(), queryOrderFeeResponse);
                this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                break;
            }
            default: {
                carEnexResponse.setOpenFlag(FlowCondition.NO);
                if (P2cVersionEnum.getIndex((String)version) >= P2cVersionEnum.\u7248\u672c3.getIndex()) {
                    this.setCustomShowSay(enterRequest, paramHolder, carEnexResponse, param, resultCode);
                    break;
                }
                carEnexResponse.setShow("\u65e0\u724c\u8f66/\u7981\u6b62\u901a\u884c");
                carEnexResponse.setSay("\u7981\u6b62\u901a\u884c");
            }
        }
        String show = carEnexResponse.getShow();
        String say = carEnexResponse.getSay();
        this.downOtherDeviceHint(enterRequest, show, say, param, resultCode);
        if (carEnexResponse.getOpenFlag().equals(FlowCondition.YES)) {
            orderNum = this.normalEnter(enterRequest, paramHolder, parkCode, channelCode);
            carEnexResponse.setOrderNum(orderNum);
        } else {
            if (NumberUtils.toPrimitive((Integer)paramHolder.getParkConfig().getDeniedAddOrder()) == 1) {
                if (!DataCommonConstants.isNoPlate((String)enterRequest.getPlateNum())) {
                    orderNum = this.normalEnter(enterRequest, paramHolder, parkCode, channelCode);
                    if (StringUtils.isNotBlank((CharSequence)orderNum)) {
                        enterRequest.setAddedOrder(true);
                        enterRequest.setOrderNum(orderNum);
                    }
                    log.info("[\u7aef\u4e91-\u5165\u573a\u4e8b\u4ef6] \u65e0\u6743\u9650\u8f66\u8f86\u4fdd\u5b58\u5165\u573a\u8bb0\u5f55, \u53c2\u6570[{}]", (Object)enterRequest);
                }
            } else {
                log.info("[\u7aef\u4e91-\u5165\u573a\u4e8b\u4ef6] \u5355\u72ec\u4fdd\u5b58\u5165\u573a\u8bb0\u5f55\u81f3\u7f13\u5b58, \u53c2\u6570[{}]", (Object)enterRequest);
                carEnexResponse.setOrderNum(enterRequest.getOrderNum());
            }
            this.cacheHandle.setEntrance(parkCode, channelCode, enterRequest);
        }
        if (carEnexResponse.getOpenFlag().equals(FlowCondition.NO)) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> this.carOrderEnterService.sendWebsocketMessage(enterRequest, carEnexResponse.getOpenFlag())));
        }
        this.spaceDown(enterRequest, carEnexResponse, paramHolder);
        return carEnexResponse;
    }
}

