/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl.enter;

import com.alibaba.fastjson.TypeReference;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.ShamPlateService;
import com.icetech.park.domain.dto.TagsDto;
import com.icetech.park.domain.entity.ShamPlate;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.mongo.document.EnterRecord;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.down.p2c.impl.FreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.down.p2r.impl.HintServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.handle.showsay.ShowSayConstants;
import com.icetech.park.service.order.impl.enter.CarOrderEnterServiceImpl;
import com.icetech.park.service.record.EnterRecordService;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CarEnterBaseHandler
extends FlowCondition {
    private static final Logger log = LoggerFactory.getLogger(CarEnterBaseHandler.class);
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected CommonShowHandle commonShowHandle;
    @Autowired
    protected CommonSayHandle commonSayHandle;
    @Autowired
    protected HintServiceImpl robotHintService;
    @Autowired
    protected CarOrderEnterServiceImpl carOrderEnterService;
    @Autowired
    protected ChannelRulesServiceImpl channelRulesService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected FreeSpaceServiceImpl freeSpaceService;
    @Autowired
    protected ParkService parkService;
    @Value(value="${web.url}")
    private String webUrl;
    @Resource
    private EnterRecordService enterRecordService;
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    protected ItcCacheHandle itcCacheHandle;
    @Autowired
    protected ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    protected ItcHintServiceImpl itcHintService;
    @Autowired
    private SoftTriggerServiceImpl softTriggerService;
    @Autowired
    private ShamPlateService shamPlateService;

    public void addEnterRecord(CarEnterRequest enterRequest) {
        EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties((Object)enterRequest, (Object)record);
        record.setChannelId(enterRequest.getInandoutCode());
        record.setEnterNo(enterRequest.getInandoutName());
        record.setImage(enterRequest.getMaxImage());
        this.enterRecordService.saveRecordAsync(record);
    }

    protected String dealSoftTrigger(CarEnterRequest enterRequest) {
        String triggerNo = enterRequest.getTriggerNo();
        enterRequest.setOrderNum(enterRequest.getOrderNum());
        this.cacheHandle.setSoftImage(triggerNo, enterRequest.getMaxImage());
        String messageId = (String)this.redisUtils.get("messageId:triggerNo:" + triggerNo, String.class);
        if (messageId != null) {
            SendInfoRecord sendInfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, (TypeReference)new TypeReference<SendInfoRecord<SoftTriggerRequest>>(){});
            this.softTriggerService.notify(triggerNo, enterRequest, (SendInfoRecord<SoftTriggerRequest>)sendInfoRecord);
        }
        log.info("[\u7aef\u4e91-\u5165\u573a\u4e8b\u4ef6] \u8f6f\u89e6\u53d1\u63a5\u53e3\u8fd4\u56de\uff0ctriggerNo\uff1a{}\uff0c\u54cd\u5e94\u7684orderNum\u4e3a\uff1a{}", (Object)triggerNo, (Object)enterRequest.getOrderNum());
        return enterRequest.getOrderNum();
    }

    protected void dealShamePlate(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        if (DataCommonConstants.isNoPlate((String)enterRequest.getPlateNum())) {
            return;
        }
        Long parkId = enterRequest.getParkId();
        String channelCode = enterRequest.getInandoutCode();
        String parkCode = enterRequest.getParkCode();
        ShamPlate shamPlate = new ShamPlate();
        shamPlate.setParkId(parkId);
        shamPlate.setPlateNum(enterRequest.getPlateNum());
        ObjectResponse objectResponse = this.orderService.getPlateType(parkId, enterRequest.getPlateNum(), paramHolder.getParkChannel().getRegionId());
        shamPlate.setType(((PlateTypeDto)objectResponse.getData()).getPlateTypeEnum().getType());
        enterRequest.setType(((PlateTypeDto)objectResponse.getData()).getPlateTypeEnum().getType());
        shamPlate.setExType(Integer.valueOf(1));
        shamPlate.setCarImage(enterRequest.getMaxImage());
        shamPlate.setAlarmTime(new Date(enterRequest.getEnterTime() * 1000L));
        shamPlate.setChannelCode(enterRequest.getInandoutCode());
        shamPlate.setChannelName(enterRequest.getInandoutName());
        shamPlate.setOrderNum(enterRequest.getOrderNum());
        CarEnterRequest lastEntrance = this.cacheHandle.getEntrance(parkCode, channelCode);
        if (lastEntrance != null && !enterRequest.getPlateNum().equals(lastEntrance.getPlateNum())) {
            shamPlate.setRelCarImage(lastEntrance.getMaxImage());
            shamPlate.setRelPlateNum(lastEntrance.getPlateNum());
        }
        if (NumberUtils.toPrimitive((Integer)paramHolder.getParkConfig().getDeniedAddOrder()) == 1) {
            ArrayList<TagsDto> tagsDtos = new ArrayList<TagsDto>();
            TagsDto tagsDto = TagsDto.builder().tagId(Integer.valueOf(OrderTags.TagIdEnum.SHAM_PLATE.getType())).build();
            tagsDtos.add(tagsDto);
            enterRequest.setTags(tagsDtos);
            String orderNum = this.normalEnter(enterRequest, paramHolder, enterRequest.getParkCode(), channelCode);
            if (StringUtils.isNotBlank((CharSequence)orderNum)) {
                enterRequest.setAddedOrder(true);
            }
        }
        this.shamPlateService.addShamPlate(shamPlate);
    }

    @Async
    protected void downOtherDeviceHint(CarEnterRequest enterRequest, String show, String say, Map<String, Object> param, FlowCondition.ResultCode resultCode) {
        String itcSn;
        String channelCode;
        Long parkId = enterRequest.getParkId();
        String parkCode = enterRequest.getParkCode();
        String serialNumber = this.cacheHandle.getChannelRobot(parkCode, channelCode = enterRequest.getInandoutCode());
        if (serialNumber != null) {
            RobotHintRequest robotHintRequest = new RobotHintRequest();
            robotHintRequest.setPlateNum(enterRequest.getPlateNum());
            robotHintRequest.setShow(show);
            robotHintRequest.setSay(say);
            this.robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
        }
        if ((itcSn = this.itcCacheHandle.getSerialNumber(parkCode, channelCode)) != null) {
            ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, channelCode);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            HintRequest itcHintRequest = HintRequest.builder().scene(Integer.valueOf(this.showSayBaseHandle.getSceneByResultCode(resultCode, 1))).plateNum(enterRequest.getPlateNum()).type(this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), param)).freeSpace(this.showSayBaseHandle.getFreeSpace(parkId, channel.getId(), param)).remainDaysMc(this.showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), enterRequest.getPlateNum(), param)).build();
            if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(itcHintRequest.getType())) {
                itcHintRequest.setVipTypeName((String)param.get("carDesc"));
            }
            if (HintRequest.Scene.NO_PLATE_ENTER.getVal() == itcHintRequest.getScene().intValue() || HintRequest.Scene.NEED_PAY_EXIT.getVal() == itcHintRequest.getScene().intValue()) {
                itcHintRequest.setQrCodeUrl(this.webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            this.itcHintService.execute(parkId, itcSn, itcHintRequest);
        }
    }

    @Async
    protected void spaceDown(CarEnterRequest enterRequest, CarEnexResponse carEnexResponse, ReportParamHolder paramHolder) {
        String parkCode = enterRequest.getParkCode();
        Integer triggerType = enterRequest.getTriggerType();
        if (paramHolder.getVersionIndex() < P2cVersionEnum.\u7248\u672c3.getIndex()) {
            String specialParkCode = "P1576060397,P1562641618";
            String ledSpecialParkCode = "P1574734634";
            if ((specialParkCode.contains(parkCode) || ledSpecialParkCode.contains(parkCode)) && !triggerType.equals(TriggerTypeEnum.\u8f6f\u89e6\u53d1.getVal())) {
                ParkFreespace parkFreespace;
                String show = carEnexResponse.getShow();
                if (enterRequest.getOpenFlag().equals(FlowCondition.YES)) {
                    show = enterRequest.getPlateNum();
                }
                if ((parkFreespace = paramHolder.getParkFreeSpace()) != null) {
                    show = LedShowHandle.complement4Rows(show, "" + parkFreespace.getFreeSpace());
                    carEnexResponse.setShow(show);
                }
            }
        }
    }

    public String normalEnter(CarEnterRequest enterRequest, ReportParamHolder paramHolder, String parkCode, String channelId) {
        enterRequest.setEnterWay(Integer.valueOf(1));
        ObjectResponse<CarEnterResult> objectResponse = this.carOrderEnterService.enter(enterRequest, paramHolder);
        if (objectResponse != null && objectResponse.getCode().equals("200")) {
            this.cacheHandle.removeEntrace(parkCode, channelId);
            CarEnterResult data = (CarEnterResult)objectResponse.getData();
            return data.getOrderNum();
        }
        return null;
    }

    protected void setCustomShowSay(CarEnterRequest enterRequest, ReportParamHolder paramHolder, CarEnexResponse carEnexResponse, Map<String, Object> para, FlowCondition.ResultCode resultCode) {
        Long parkId = enterRequest.getParkId();
        ParkInoutdevice parkChannel = paramHolder.getParkChannel();
        Integer ledLcdSource = parkChannel.getLedLcdSource();
        carEnexResponse.setShowDeviceType(ledLcdSource);
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        ParkInoutdevice channel = paramHolder.getParkChannel();
        para.put("regionId", channel.getRegionId());
        para.put("enexType", 1);
        para.put("channelCode", enterRequest.getInandoutCode());
        String show = this.commonShowHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), resultCode, para, ledLcdSource);
        String say = this.commonSayHandle.enter(parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), resultCode, para, ledLcdSource);
        carEnexResponse.setShow(show);
        carEnexResponse.setSay(say);
        if (ledLcdSource == 2) {
            if (ShowSayConstants.ENTER_QR_RESULT_LIST.contains((Object)resultCode)) {
                String qrCodeUr = this.webUrl + "/noplate/enter/index?parkCode=" + enterRequest.getParkCode() + "&channelId=" + enterRequest.getInandoutCode();
                carEnexResponse.setQrCodeUrl(qrCodeUr);
            }
        } else {
            carEnexResponse.setShowTypeByShow(show);
            if (carEnexResponse.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal() || carEnexResponse.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                show = this.commonShowHandle.replacePara(show, new String[]{enterRequest.getParkCode(), enterRequest.getInandoutCode()});
                carEnexResponse.setShow(show);
                if (carEnexResponse.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal()) {
                    String extendShow = this.ledShowHandle.generate4LineContent(parkId, channel.getId(), enterRequest.getPlateNum(), enterRequest.getType(), resultCode, para, LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type);
                    carEnexResponse.setExtendShow(extendShow);
                }
            }
        }
    }
}

