/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.alibaba.fastjson.JSONObject;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.oss.OssService;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.CallService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cUploadFileServiceImpl")
public class UploadFileServiceImpl
extends AbstractService
implements CallService<JSONObject, Object> {
    private static final Logger log = LoggerFactory.getLogger(UploadFileServiceImpl.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    @Override
    public P2cBaseResponse<Object> execute(TokenDeviceVo deviceToken, P2cBaseRequest<JSONObject> baseRequest) {
        JSONObject bizContent = (JSONObject)baseRequest.getBizContent();
        Integer fileStatus = bizContent.getInteger("fileStatus");
        if (fileStatus == 1) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                String fileName = bizContent.getString("fileName");
                this.ossService.uploadBase64(bizContent.getString("base64Str"), fileName);
                log.info("<\u7aef\u4e91-\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3> \u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\uff0c\u6587\u4ef6\u540d\uff1a{}", (Object)fileName);
            }));
        }
        return P2cBaseResponse.success(baseRequest);
    }
}

