/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.constants.BatchSendConstants;
import com.icetech.cloudcenter.domain.request.p2c.TaskProgressRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.dao.BatchsendTaskDao;
import com.icetech.park.dao.BatchsendTaskSubDao;
import com.icetech.park.domain.entity.BatchsendTask;
import com.icetech.park.domain.entity.BatchsendTaskSub;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.BatchDownUtils;
import com.icetech.park.service.report.CallService;
import com.icetech.third.utils.RedisUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cTaskProgressServiceImpl")
public class TaskProgressServiceImpl
extends AbstractService
implements CallService<TaskProgressRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(TaskProgressServiceImpl.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private BatchsendTaskDao batchsendTaskDao;
    @Autowired
    private BatchsendTaskSubDao batchsendTaskSubDao;
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private MonthCarService monthCarService;
    @Autowired
    private VipCarService vipCarService;

    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<TaskProgressRequest> baseRequest) {
        int failEndIndex;
        int failStartIndex;
        List failIdList;
        String ids;
        ObjectResponse recordIdList;
        TaskProgressRequest taskProgressRequest = (TaskProgressRequest)baseRequest.getBizContent();
        this.verifyParams(taskProgressRequest);
        String subTaskId = taskProgressRequest.getSubTaskId();
        String subTaskKey = "batchdown:task:sub:" + subTaskId;
        Integer totalNum = (Integer)this.redisUtils.hGet(subTaskKey, "totalNum", Integer.class);
        Integer successNum = (Integer)this.redisUtils.hGet(subTaskKey, "successNum", Integer.class);
        Integer failNum = (Integer)this.redisUtils.hGet(subTaskKey, "failNum", Integer.class);
        Integer currDataType = (Integer)this.redisUtils.hGet(subTaskKey, "serviceType", Integer.class);
        Integer thisNum = taskProgressRequest.getThisNum();
        Integer thisFailNum = taskProgressRequest.getThisFailNum();
        Integer doneNum = taskProgressRequest.getDoneNum();
        int successNumNew = successNum + (thisNum - thisFailNum);
        int failNumNew = failNum + taskProgressRequest.getThisFailNum();
        if (successNumNew > totalNum) {
            successNumNew = totalNum;
            failNumNew = 0;
        } else if (failNumNew + successNumNew > totalNum) {
            failNumNew = totalNum - successNumNew;
        }
        this.redisUtils.hPut(subTaskKey, "successNum", (Object)successNumNew);
        this.redisUtils.hPut(subTaskKey, "failNum", (Object)failNumNew);
        String reason = (String)this.redisUtils.hGet(subTaskKey, "reason", String.class);
        String failIds = (String)this.redisUtils.hGet(subTaskKey, "failIds", String.class);
        String taskId = (String)this.redisUtils.hGet(subTaskKey, "taskId", String.class);
        String thisFailReason = taskProgressRequest.getThisFailReason();
        if (StringUtils.isNotBlank((CharSequence)thisFailReason)) {
            this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownUtils.convertMsgAndGetNewMsg(reason, thisFailReason));
        }
        Integer cmdType = BatchSendConstants.convert2BatchBizOpenType((int)currDataType);
        String dataListKey = "batchdown:task:data:" + subTaskId + ":" + cmdType;
        int startIndex = doneNum - thisNum;
        int endIndex = doneNum - 1;
        List idLongList = this.redisUtils.lRange(dataListKey, (long)startIndex, (long)endIndex, Long.class);
        if (201 == currDataType) {
            recordIdList = this.monthCarService.getRecordIdListByIds(idLongList);
            if (ObjectResponse.isSuccess((Response)recordIdList)) {
                idLongList = (List)recordIdList.getData();
            }
        } else if (203 == currDataType && ObjectResponse.isSuccess((Response)(recordIdList = this.vipCarService.getRecordIdListByIds(idLongList)))) {
            idLongList = (List)recordIdList.getData();
        }
        this.sendInfoService.updateSuccessByServiceIds(idLongList, cmdType, TextConstant.getSuccessDefaultMessage((String)"1"));
        log.info("[\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1\u5904\u7406\u8fdb\u5ea6\u63a5\u53e3]\u4e1a\u52a1\u7c7b\u578b[{}],id\u96c6\u5408[{}]", (Object)cmdType, (Object)idLongList);
        if (thisFailNum > 0 && StringUtils.isNotBlank((CharSequence)(ids = (failIdList = this.redisUtils.lRange(dataListKey, (long)(failStartIndex = doneNum - thisFailNum), (long)(failEndIndex = doneNum - 1), Long.class)).stream().map(String::valueOf).collect(Collectors.joining(","))))) {
            if (StringUtils.isNotBlank((CharSequence)failIds)) {
                if (failIds.split(",").length + failIdList.size() <= totalNum) {
                    this.redisUtils.hPut(subTaskKey, "failIds", (Object)(failIds + "," + ids));
                }
            } else {
                this.redisUtils.hPut(subTaskKey, "failIds", (Object)ids);
            }
        }
        if (totalNum.equals(successNumNew) || taskProgressRequest.getIsEnd() == 1) {
            log.info("[\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1\u5904\u7406\u8fdb\u5ea6\u63a5\u53e3]\u5b50\u4efb\u52a1\u5904\u7406\u7ed3\u675f[{}]", (Object)subTaskId);
            this.redisUtils.hPut(subTaskKey, "status", (Object)3);
            if (failNumNew == 0) {
                this.redisUtils.hDelete(subTaskKey, new String[]{"reason"});
            }
            BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
            batchsendTaskSub.setId(Integer.valueOf(Integer.parseInt(subTaskId)));
            batchsendTaskSub.setStatus(Integer.valueOf(3));
            batchsendTaskSub.setSuccessNum(Integer.valueOf(successNumNew));
            batchsendTaskSub.setFailNum(Integer.valueOf(failNumNew));
            batchsendTaskSub.setTotalNum(totalNum);
            this.batchsendTaskSubDao.updateById(batchsendTaskSub);
            this.dealOtherSubTask(deviceToken.getParkId(), currDataType, taskId, dataListKey);
        } else {
            this.redisUtils.hPut(subTaskKey, "status", (Object)2);
            this.redisUtils.hDelete(subTaskKey, new String[]{"reason"});
        }
        return P2cBaseResponse.success(baseRequest);
    }

    private void dealOtherSubTask(Long parkId, Integer currDataType, String taskId, String dataListKey) {
        String taskIdKey = "batchdown:task:" + taskId;
        List subTaskList = this.redisUtils.lRange(taskIdKey, 0L, this.redisUtils.lLen(taskIdKey).longValue(), Integer.class);
        if (subTaskList != null && subTaskList.size() > 0) {
            boolean isAllDataTypeOK = true;
            boolean isAllOk = true;
            for (int i = 0; i < subTaskList.size(); ++i) {
                Integer subT = (Integer)subTaskList.get(i);
                Integer status = (Integer)this.redisUtils.hGet("batchdown:task:sub:" + subT, "status", Integer.class);
                Integer dataType = (Integer)this.redisUtils.hGet("batchdown:task:sub:" + subT, "serviceType", Integer.class);
                if (status == 3) continue;
                isAllOk = false;
                if (!currDataType.equals(dataType)) break;
                isAllDataTypeOK = false;
                break;
            }
            if (isAllOk) {
                BatchsendTask batchsendTask = new BatchsendTask();
                batchsendTask.setTaskId(taskId);
                batchsendTask = this.batchsendTaskDao.selectOneByEntity(batchsendTask);
                batchsendTask.setStatus(Integer.valueOf(3));
                this.batchsendTaskDao.updateById(batchsendTask);
                this.redisUtils.expire(dataListKey, 120L);
                log.info("[\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1\u5904\u7406\u8fdb\u5ea6\u63a5\u53e3]\u6240\u6709\u4e0b\u53d1\u4e1a\u52a1\u90fd\u5df2\u7ed3\u675f[{}]", (Object)taskId);
            }
            if (isAllDataTypeOK) {
                this.redisUtils.remove("batchdown:open:" + parkId + ":" + BatchSendConstants.convert2BatchBizOpenType((int)currDataType));
                log.info("[\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1\u5904\u7406\u8fdb\u5ea6\u63a5\u53e3]\u6240\u6709\u4e0b\u53d1\u4e1a\u52a1\u90fd\u5df2\u7ed3\u675f[{}],dataType[{}]", (Object)taskId, (Object)currDataType);
            }
        }
    }
}

