/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteExitRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.dao.RemotePayDao;
import com.icetech.park.domain.entity.RemotePay;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.report.CallService;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cRemoteExitServiceImpl")
public class RemoteExitServiceImpl
extends AbstractService
implements CallService<RemoteExitRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(RemoteExitServiceImpl.class);
    @Autowired
    private CarOrderExitService carOrderExitService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private HintServiceImpl hintService;
    @Autowired
    private RemotePayDao remotePayDao;
    private static final String specialParkCode = "P1562641618";
    private static final String EXIT_MONEY_OPEN = "exit_money_open";
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ItcHintServiceImpl itcHintService;
    @Autowired
    private com.icetech.park.service.down.p2r.impl.HintServiceImpl robotHintService;
    @Autowired
    private CommonSayHandle commonSayHandle;
    @Autowired
    private CommonShowHandle commonShowHandle;
    @Autowired
    private RedisUtils redisUtils;
    private static final String REDIS_KEY_LOCK_PREFIX = "camera:report:remotexit:";
    private static final long REDIS_KEY_LOCK_TIMEOUT = 10000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RemoteExitRequest> baseRequest) {
        Long parkId = deviceToken.getParkId();
        String parkCode = deviceToken.getParkCode();
        String inandoutCode = deviceToken.getInandoutCode();
        String inandoutName = deviceToken.getInandoutName();
        String sn = deviceToken.getDeviceNo();
        RemoteExitRequest remoteExitRequest = (RemoteExitRequest)baseRequest.getBizContent();
        this.verifyParams(remoteExitRequest);
        remoteExitRequest.setParkId(parkId);
        remoteExitRequest.setParkCode(parkCode);
        remoteExitRequest.setInandoutCode(inandoutCode);
        remoteExitRequest.setInandoutName(inandoutName);
        String lockKey = REDIS_KEY_LOCK_PREFIX + deviceToken.getInandoutCode();
        boolean lock = this.redisUtils.tryLock(lockKey, baseRequest.getMessageId(), 10000L);
        if (!lock) {
            P2cBaseResponse p2cBaseResponse = new P2cBaseResponse();
            p2cBaseResponse.setMessageId(baseRequest.getMessageId());
            p2cBaseResponse.setCmd(baseRequest.getCmd() + "_resp");
            p2cBaseResponse.setCode(CodeEnum.\u8bf7\u6c42\u91cd\u590d.getCode());
            p2cBaseResponse.setMsg("\u6b63\u5728\u5904\u7406\u4e2d");
            return p2cBaseResponse;
        }
        try {
            String plateNum = remoteExitRequest.getPlateNum();
            CarExitRequest cacheExit = this.cacheHandle.getExit(parkCode, inandoutCode);
            boolean hasCache = cacheExit != null;
            CarExitRequest carExitRequest = cacheExit = hasCache ? cacheExit : new CarExitRequest();
            if (StringUtils.isBlank((CharSequence)remoteExitRequest.getMaxImage())) {
                String cacheMaxImage = hasCache ? cacheExit.getMaxImage() : null;
                remoteExitRequest.setMaxImage(cacheMaxImage == null ? remoteExitRequest.getRealImage() : cacheExit.getMaxImage());
            }
            remoteExitRequest.setOrderNum(cacheExit.getOrderNum());
            OrderInfo orderInfo = null;
            boolean currPlateNum = true;
            if (DataCommonConstants.isNoPlate((String)plateNum) && hasCache && !DataCommonConstants.isNoPlate((String)cacheExit.getPlateNum())) {
                plateNum = cacheExit.getPlateNum();
                currPlateNum = false;
            }
            if (!DataCommonConstants.isNoPlate((String)plateNum) && (orderInfo = this.findOrder(parkCode, parkId, inandoutCode, plateNum, cacheExit, hasCache)) != null) {
                remoteExitRequest.setOrderNum(orderInfo.getOrderNum());
                remoteExitRequest.setPlateNum(orderInfo.getPlateNum());
                remoteExitRequest.setType(orderInfo.getType());
                this.carExit(parkId, parkCode, inandoutCode, remoteExitRequest, plateNum, orderInfo, currPlateNum, cacheExit, inandoutName, sn);
            }
            this.cacheHandle.removeExit(parkCode, inandoutCode);
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            openingDtoRequest.setRecordType(Integer.valueOf(2));
            openingDtoRequest.setParkCode(parkCode);
            openingDtoRequest.setPlateNum(plateNum);
            openingDtoRequest.setExecuteTime(remoteExitRequest.getOpenTime());
            openingDtoRequest.setImgUrl((cacheExit.getMaxImage() == null ? "" : cacheExit.getMaxImage() + ",") + remoteExitRequest.getRealImage());
            openingDtoRequest.setAisleCode(inandoutCode);
            int oddStatus = OrderOddStatusEnum.\u5176\u4ed6.getVal();
            if (!EXIT_MONEY_OPEN.equals(remoteExitRequest.getRemoteCode()) && orderInfo != null && NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 1) {
                oddStatus = OrderOddStatusEnum.\u672a\u627e\u5230\u5165\u573a\u8bb0\u5f55.getVal();
            }
            if (orderInfo == null && hasCache) {
                oddStatus = OrderOddStatusEnum.\u672a\u627e\u5230\u5165\u573a\u8bb0\u5f55.getVal();
            }
            openingDtoRequest.setReasonType(Integer.valueOf(oddStatus));
            openingDtoRequest.setSourcegate(Integer.valueOf(3));
            openingDtoRequest.setOrderNum(orderInfo == null ? null : orderInfo.getOrderNum());
            ObjectResponse objectResponse = this.parkService.saveOpeningRecord(openingDtoRequest);
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                log.info("<\u9065\u63a7\u5668\u51fa\u573a\u5f00\u95f8> \u4fdd\u5b58\u5f00\u95f8\u8bb0\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)objectResponse.getMsg());
            }
            P2cBaseResponse p2cBaseResponse = P2cBaseResponse.success(baseRequest);
            return p2cBaseResponse;
        }
        finally {
            this.redisUtils.releaseLock(lockKey);
        }
    }

    private OrderInfo findOrder(String parkCode, Long parkId, String inandoutCode, String plateNum, CarExitRequest cacheExit, boolean hasCache) {
        OrderInfo orderInfo = null;
        ObjectResponse inPark = this.orderService.findInPark(plateNum, parkCode);
        if (ObjectResponse.isSuccess((Response)inPark)) {
            orderInfo = (OrderInfo)inPark.getData();
        } else if (hasCache) {
            ObjectResponse infoObjectResponse = this.orderService.findByOrderNum(cacheExit.getOrderNum());
            if (ObjectResponse.isSuccess((Response)infoObjectResponse)) {
                orderInfo = (OrderInfo)infoObjectResponse.getData();
            }
        } else {
            inPark = this.orderService.fuzzyPlate(parkId, inandoutCode, plateNum);
            if (ObjectResponse.isSuccess((Response)inPark)) {
                orderInfo = (OrderInfo)inPark.getData();
                log.info("\u79bb\u573a\u8f66\u724c\uff1a{}, \u6a21\u7cca\u5339\u914d\u5230\u8f66\u724c\uff1a{}", (Object)plateNum, (Object)orderInfo.getPlateNum());
            }
        }
        return orderInfo;
    }

    private void carExit(Long parkId, String parkCode, String inandoutCode, RemoteExitRequest remoteExitRequest, String plateNum, OrderInfo orderInfo, boolean currPlateNum, CarExitRequest cacheExit, String inandoutName, String sn) {
        float unpayPrice;
        if (orderInfo == null) {
            throw new ResponseBodyException("400", "\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryOrderFeeResponse orderFee = this.cacheHandle.getChannelFee(parkCode, inandoutCode);
        log.info("<\u7f13\u5b58\u83b7\u53d6\u8d39\u7528>\u8f66\u573a\uff1a{}\uff0c\u8f66\u724c\u53f7\uff1a{}\uff0c\u8d39\u7528\uff1a{}", new Object[]{parkCode, plateNum, orderFee});
        if (orderFee == null || !orderFee.getPlateNum().equals(plateNum)) {
            log.info("<\u91cd\u65b0\u8ba1\u8d39>\u8f66\u573a\uff1a{}\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)parkCode, (Object)plateNum);
            QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
            queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
            queryOrderFeeRequest.setParkCode(parkCode);
            queryOrderFeeRequest.setPlateNum(plateNum);
            ObjectResponse queryOrderFeeResponseObjectResponse = this.orderService.p2cQueryFee(queryOrderFeeRequest);
            if (ObjectResponse.isSuccess((Response)queryOrderFeeResponseObjectResponse)) {
                orderFee = (QueryOrderFeeResponse)queryOrderFeeResponseObjectResponse.getData();
            }
        }
        boolean isException = false;
        Integer oddStatus = OrderOddStatusEnum.\u5176\u4ed6.getVal();
        if (orderFee != null && (unpayPrice = Float.parseFloat(orderFee.getUnpayPrice())) > 0.0f) {
            if (EXIT_MONEY_OPEN.equals(remoteExitRequest.getRemoteCode())) {
                OrderPay orderPay = new OrderPay();
                orderPay.setParkId(parkId);
                orderPay.setOrderNum(orderInfo.getOrderNum());
                orderPay.setTradeNo(CodeTools.GenerateTradeNo());
                orderPay.setPayDate(new Date());
                orderPay.setPayTime(Long.valueOf(DateTools.unixTimestamp()));
                orderPay.setOrderTime(Long.valueOf(cacheExit != null && cacheExit.getExitTime() != null ? cacheExit.getExitTime() : DateTools.unixTimestamp()));
                orderPay.setTotalPrice(NumberUtils.decimalAdd((Object)orderFee.getUnpayPrice(), (Object[])new Object[]{orderFee.getDiscountPrice()}).toString());
                orderPay.setPaidPrice(orderFee.getUnpayPrice());
                orderPay.setDiscountPrice(orderFee.getDiscountPrice());
                orderPay.setPayChannel(Integer.valueOf(10));
                orderPay.setPayTerminal(inandoutName);
                orderPay.setPayWay(Integer.valueOf(1));
                orderPay.setChannelId(inandoutCode);
                orderPay.setIsSync(Integer.valueOf(0));
                orderPay.setPayStatus(Integer.valueOf(2));
                ObjectResponse objectResponse = this.orderPayService.addOrderPay(orderPay);
                if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                    log.info("<\u9065\u63a7\u5668\u51fa\u53e3\u5f00\u95f8> \u4fdd\u5b58\u73b0\u91d1\u4ea4\u6613\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\uff1a{}", (Object)orderPay, (Object)objectResponse);
                }
                RemotePay remotePay = new RemotePay();
                BeanUtils.copyProperties((Object)orderPay, (Object)remotePay);
                this.remotePayDao.insert(remotePay);
            } else {
                isException = true;
                if (NumberUtils.toPrimitive((Integer)orderInfo.getNoneEnterFlag()) == 1) {
                    oddStatus = OrderOddStatusEnum.\u672a\u627e\u5230\u5165\u573a\u8bb0\u5f55.getVal();
                }
            }
        }
        CarExitRequest carExitRequest = new CarExitRequest();
        if (currPlateNum) {
            BeanUtils.copyProperties((Object)remoteExitRequest, (Object)carExitRequest);
            carExitRequest.setExitTime(remoteExitRequest.getOpenTime());
        } else if (cacheExit != null && cacheExit.getPlateNum() != null) {
            BeanUtils.copyProperties((Object)cacheExit, (Object)carExitRequest);
        } else {
            BeanUtils.copyProperties((Object)remoteExitRequest, (Object)carExitRequest);
            carExitRequest.setExitTime(remoteExitRequest.getOpenTime());
        }
        if (isException) {
            carExitRequest.setTotalAmount(orderFee.getTotalAmount());
            carExitRequest.setPaidAmount(orderFee.getPaidAmount());
            carExitRequest.setDiscountAmount(orderFee.getDiscountAmount());
        }
        this.normalExit(carExitRequest, parkCode, inandoutCode, isException, cacheExit, oddStatus);
        String robotSerialNumber = this.cacheHandle.getChannelRobot(parkCode, inandoutCode);
        String itcSn = this.itcCacheHandle.getSerialNumber(parkCode, inandoutCode);
        if (robotSerialNumber != null || itcSn != null) {
            TokenDeviceVo robotDeviceInfo = this.cacheHandle.getRobotDeviceInfo(robotSerialNumber);
            ObjectResponse plateTypeDtoObjectResponse = this.orderService.getPlateType(parkId, plateNum, robotDeviceInfo == null ? null : robotDeviceInfo.getRegionId());
            PlateTypeDto plateTypeDto = (PlateTypeDto)plateTypeDtoObjectResponse.getData();
            remoteExitRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
            FlowCondition.ResultCode resultCode = plateTypeDto.getPlateTypeEnum().equals((Object)PlateTypeEnum.\u6708\u5361\u8f66) ? FlowCondition.ResultCode.\u6708\u5361\u8f66 : FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39;
            TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(sn);
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("orderNum", orderInfo.getOrderNum());
            if (tokenDeviceVo != null) {
                para.put("regionId", tokenDeviceVo.getRegionId());
            }
            ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, inandoutCode);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            if (robotSerialNumber != null) {
                String show = this.commonShowHandle.exit(parkId, channel.getId(), plateNum, orderInfo.getType(), resultCode, para);
                String say = this.commonSayHandle.exit(parkId, channel.getId(), plateNum, orderInfo.getType(), resultCode, para);
                RobotHintRequest robotHintRequest = new RobotHintRequest();
                robotHintRequest.setPlateNum(plateNum);
                robotHintRequest.setShow(show);
                robotHintRequest.setSay(say);
                this.robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
            }
            if (itcSn != null) {
                HintRequest itcHintRequest = HintRequest.builder().scene(Integer.valueOf(this.showSayBaseHandle.getSceneByResultCode(resultCode, 2))).plateNum(plateNum).type(this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), plateNum, remoteExitRequest.getType(), para)).freeSpace(this.showSayBaseHandle.getFreeSpace(parkId, channel.getId(), para)).remainDaysMc(this.showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), plateNum, para)).unpayPrice(para.get("fee") == null ? null : Integer.valueOf((int)(Float.parseFloat((String)para.get("fee")) * 100.0f))).parkTime(Long.valueOf(para.get("parkTime") == null ? remoteExitRequest.getOpenTime() - orderInfo.getEnterTime() : (Long)para.get("parkTime"))).build();
                if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(itcHintRequest.getType())) {
                    itcHintRequest.setVipTypeName((String)para.get("carDesc"));
                }
                this.itcHintService.execute(parkId, itcSn, itcHintRequest);
            }
        }
    }

    private void showFreeSpace(Long parkId, String parkCode, String plateNum) {
        if (specialParkCode.contains(parkCode)) {
            log.info("\u8fdb\u5165\u5b9a\u5236\u8f66\u573a\uff0cparkId\uff1a{}", (Object)parkId);
            ObjectResponse parkFreespaceObjectResponse = this.parkService.getParkSpace(parkId);
            log.info("\u67e5\u8be2\u7a7a\u8f66\u4f4d\uff0cparkFreespaceObjectResponse\uff1a{}", (Object)parkFreespaceObjectResponse);
            if (ObjectResponse.isSuccess((Response)parkFreespaceObjectResponse)) {
                String show = LedShowHandle.complement4Rows("" + ((ParkFreespace)parkFreespaceObjectResponse.getData()).getFreeSpace());
                com.icetech.cloudcenter.domain.request.p2c.HintRequest hintRequest = new com.icetech.cloudcenter.domain.request.p2c.HintRequest();
                hintRequest.setShow(show);
                hintRequest.setPlateNum(plateNum);
                ObjectResponse<Void> response = this.hintService.executeSendEnter(parkId, parkCode, hintRequest);
                if (!ObjectResponse.isSuccess(response)) {
                    log.info("\u79bb\u573a\u66f4\u65b0\u5165\u53e3\u5c4f\u663e\u7684\u7a7a\u8f66\u4f4d\u5931\u8d25\uff0c\u79bb\u573a\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                }
            }
        }
    }

    public void normalExit(CarExitRequest exitRequest, String parkCode, String channelId, boolean isException, CarExitRequest cacheExit, Integer oddStatus) {
        ObjectResponse objectResponse;
        exitRequest.setOpenFlag(Integer.valueOf(1));
        exitRequest.setExitWay(Integer.valueOf(2));
        if (cacheExit != null && cacheExit.getExitTime() != null) {
            exitRequest.setExitTime(cacheExit.getExitTime());
        }
        if (ObjectResponse.isSuccess((Response)(objectResponse = isException ? this.carOrderExitService.exceptionExit(exitRequest, oddStatus) : this.carOrderExitService.exit(exitRequest)))) {
            this.cacheHandle.removeExit(parkCode, channelId);
            this.cacheHandle.removeChannelFee(parkCode, channelId);
            this.showFreeSpace(exitRequest.getParkId(), parkCode, exitRequest.getPlateNum());
        } else {
            log.info("<\u9065\u63a7\u5668\u51fa\u53e3\u5f00\u95f8> \u79bb\u573a\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\uff1a{}", (Object)exitRequest, (Object)objectResponse);
        }
    }
}

