/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteEnterRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.report.CallService;
import com.icetech.third.utils.RedisUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cRemoteEnterServiceImpl")
public class RemoteEnterServiceImpl
extends AbstractService
implements CallService<RemoteEnterRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(RemoteEnterServiceImpl.class);
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private HintServiceImpl hintService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ItcHintServiceImpl itcHintService;
    @Autowired
    private RedisUtils redisUtils;
    private static final String REDIS_KEY_LOCK_PREFIX = "camera:report:remotenter:";
    private static final long REDIS_KEY_LOCK_TIMEOUT = 10000L;
    @Autowired
    private com.icetech.park.service.down.p2r.impl.HintServiceImpl robotHintService;
    @Autowired
    private CommonSayHandle commonSayHandle;
    @Autowired
    private CommonShowHandle commonShowHandle;
    @Autowired
    private OrderService orderService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P2cBaseResponse<Void> execute(TokenDeviceVo deviceToken, P2cBaseRequest<RemoteEnterRequest> baseRequest) {
        Long parkId = deviceToken.getParkId();
        String parkCode = deviceToken.getParkCode();
        String serialNumber = deviceToken.getDeviceNo();
        String inandoutCode = deviceToken.getInandoutCode();
        String inandoutName = deviceToken.getInandoutName();
        RemoteEnterRequest remoteEnterRequest = (RemoteEnterRequest)baseRequest.getBizContent();
        this.verifyParams(remoteEnterRequest);
        String lockKey = REDIS_KEY_LOCK_PREFIX + deviceToken.getInandoutCode();
        boolean lock = this.redisUtils.tryLock(lockKey, baseRequest.getMessageId(), 10000L);
        if (!lock) {
            P2cBaseResponse p2cBaseResponse = new P2cBaseResponse();
            p2cBaseResponse.setMessageId(baseRequest.getMessageId());
            p2cBaseResponse.setCmd(baseRequest.getCmd() + "_resp");
            p2cBaseResponse.setCode(CodeEnum.\u8bf7\u6c42\u91cd\u590d.getCode());
            p2cBaseResponse.setMsg("\u6b63\u5728\u5904\u7406\u4e2d");
            return p2cBaseResponse;
        }
        try {
            String specialParkCode;
            remoteEnterRequest.setParkId(parkId);
            remoteEnterRequest.setParkCode(parkCode);
            remoteEnterRequest.setInandoutCode(inandoutCode);
            remoteEnterRequest.setInandoutName(inandoutName);
            String plateNum = remoteEnterRequest.getPlateNum();
            CarEnterRequest entrace = this.cacheHandle.getEntrance(parkCode, inandoutCode);
            boolean hasCache = entrace != null;
            entrace = hasCache ? entrace : new CarEnterRequest();
            String orderNum = entrace.getOrderNum();
            if (StringUtils.isBlank((CharSequence)remoteEnterRequest.getMaxImage())) {
                String cacheMaxImage = entrace.getMaxImage();
                remoteEnterRequest.setMaxImage(cacheMaxImage == null ? remoteEnterRequest.getRealImage() : cacheMaxImage);
            }
            remoteEnterRequest.setOrderNum(entrace.getOrderNum());
            if (!DataCommonConstants.isNoPlate((String)plateNum)) {
                CarEnterRequest carEnterRequest = new CarEnterRequest();
                BeanUtils.copyProperties((Object)remoteEnterRequest, (Object)carEnterRequest);
                carEnterRequest.setEnterTime(remoteEnterRequest.getOpenTime());
                orderNum = this.normalEnter(carEnterRequest, parkCode, inandoutCode);
            } else {
                String cachePlateNum;
                boolean isCachePlateValid = false;
                if (hasCache && !DataCommonConstants.isNoPlate((String)(cachePlateNum = entrace.getPlateNum()))) {
                    isCachePlateValid = true;
                    plateNum = entrace.getPlateNum();
                    orderNum = this.normalEnter(entrace, parkCode, inandoutCode);
                }
                if (!isCachePlateValid) {
                    CarEnterRequest carEnterRequest = new CarEnterRequest();
                    BeanUtils.copyProperties((Object)remoteEnterRequest, (Object)carEnterRequest);
                    carEnterRequest.setEnterTime(remoteEnterRequest.getOpenTime());
                    orderNum = this.normalEnter(carEnterRequest, parkCode, inandoutCode);
                }
            }
            this.cacheHandle.removeEntrace(parkCode, inandoutCode);
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            openingDtoRequest.setRecordType(Integer.valueOf(1));
            openingDtoRequest.setParkCode(parkCode);
            openingDtoRequest.setPlateNum(plateNum);
            openingDtoRequest.setExecuteTime(remoteEnterRequest.getOpenTime());
            openingDtoRequest.setImgUrl((entrace.getMaxImage() == null ? "" : entrace.getMaxImage() + ",") + remoteEnterRequest.getRealImage());
            openingDtoRequest.setAisleCode(inandoutCode);
            openingDtoRequest.setReasonType(Integer.valueOf(99));
            openingDtoRequest.setSourcegate(Integer.valueOf(3));
            openingDtoRequest.setOrderNum(orderNum);
            ObjectResponse objectResponse = this.parkService.saveOpeningRecord(openingDtoRequest);
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                log.info("<\u9065\u63a7\u5668\u5165\u573a\u5f00\u95f8> \u4fdd\u5b58\u5f00\u95f8\u8bb0\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)objectResponse.getMsg());
            }
            if ((specialParkCode = "P1562641618").contains(parkCode)) {
                String show = DataCommonConstants.isNoPlate((String)plateNum) ? null : plateNum;
                ObjectResponse parkFreespaceObjectResponse = this.parkService.getParkSpace(parkId);
                if (ObjectResponse.isSuccess((Response)parkFreespaceObjectResponse)) {
                    show = LedShowHandle.complement4Rows(show == null ? "\u6b22\u8fce\u5149\u4e34" : show + "/\u6b22\u8fce\u5149\u4e34", "" + ((ParkFreespace)parkFreespaceObjectResponse.getData()).getFreeSpace());
                    com.icetech.cloudcenter.domain.request.p2c.HintRequest hintRequest = new com.icetech.cloudcenter.domain.request.p2c.HintRequest();
                    hintRequest.setShow(show);
                    hintRequest.setPlateNum(plateNum);
                    this.hintService.showAndSay(parkId, parkCode, serialNumber, hintRequest);
                    log.info("<\u9065\u63a7\u5668\u5165\u573a\u5f00\u95f8> \u5c4f\u663e\u66f4\u65b0\u4e3a\uff1a{}", (Object)show);
                }
            }
            String robotSerialNumber = this.cacheHandle.getChannelRobot(parkCode, inandoutCode);
            String itcSn = this.itcCacheHandle.getSerialNumber(parkCode, inandoutCode);
            if (robotSerialNumber != null || itcSn != null) {
                FlowCondition.ResultCode resultCode;
                ObjectResponse plateTypeDtoObjectResponse = this.orderService.getPlateType(parkId, plateNum, deviceToken.getRegionId());
                PlateTypeDto plateTypeDto = (PlateTypeDto)plateTypeDtoObjectResponse.getData();
                remoteEnterRequest.setType(plateTypeDto.getPlateTypeEnum().getType());
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("regionId", deviceToken.getRegionId());
                para.put("channelCode", inandoutCode);
                para.put("enexType", 1);
                if (plateTypeDto.getPlateTypeEnum().equals((Object)PlateTypeEnum.VIP\u8f66\u8f86)) {
                    String carDesc = plateTypeDto.getCarDesc();
                    if (carDesc != null) {
                        para.put("carDesc", carDesc);
                    }
                    resultCode = FlowCondition.ResultCode.VIP\u8f66\u8f86;
                } else {
                    resultCode = plateTypeDto.getPlateTypeEnum().equals((Object)PlateTypeEnum.\u6708\u5361\u8f66) ? FlowCondition.ResultCode.\u6708\u5361\u8f66 : (plateTypeDto.getPlateTypeEnum().equals((Object)PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86) ? FlowCondition.ResultCode.\u8bbf\u5ba2\u8f66 : FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                }
                ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, inandoutCode);
                ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
                if (robotSerialNumber != null) {
                    String show = this.commonShowHandle.enter(parkId, channel.getId(), plateNum, plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                    String say = this.commonSayHandle.enter(parkId, channel.getId(), plateNum, plateTypeDto.getPlateTypeEnum().getType(), resultCode, para);
                    RobotHintRequest robotHintRequest = new RobotHintRequest();
                    robotHintRequest.setPlateNum(plateNum);
                    robotHintRequest.setShow(show);
                    robotHintRequest.setSay(say);
                    this.robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
                }
                if (itcSn != null) {
                    HintRequest itcHintRequest = HintRequest.builder().scene(Integer.valueOf(this.showSayBaseHandle.getSceneByResultCode(resultCode, 1))).plateNum(plateNum).type(this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channel.getId(), plateNum, remoteEnterRequest.getType(), para)).freeSpace(this.showSayBaseHandle.getFreeSpace(parkId, channel.getId(), para)).remainDaysMc(this.showSayBaseHandle.getMonthCarRemainDays(parkId, channel.getId(), plateNum, para)).build();
                    if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(itcHintRequest.getType())) {
                        itcHintRequest.setVipTypeName((String)para.get("carDesc"));
                    }
                    this.itcHintService.execute(parkId, itcSn, itcHintRequest);
                }
            }
            P2cBaseResponse p2cBaseResponse = P2cBaseResponse.success(baseRequest);
            return p2cBaseResponse;
        }
        finally {
            this.redisUtils.releaseLock(lockKey);
        }
    }

    public String normalEnter(CarEnterRequest enterRequest, String parkCode, String channelId) {
        enterRequest.setEnterWay(Integer.valueOf(2));
        enterRequest.setOpenFlag(Integer.valueOf(1));
        ObjectResponse objectResponse = this.carOrderEnterService.enter(enterRequest);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            this.cacheHandle.removeEntrace(parkCode, channelId);
            CarEnterResult data = (CarEnterResult)objectResponse.getData();
            return data.getOrderNum();
        }
        log.info("<\u9065\u63a7\u5668\u5165\u573a\u5f00\u95f8> \u5165\u573a\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\uff1a{}", (Object)enterRequest, (Object)objectResponse);
        return null;
    }
}

