/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.report.p2c.impl;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.RegisterDeviceRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.RegisterDeviceResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.DeviceUpgradeHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cRegisterDeviceServiceImpl")
public class RegisterDeviceServiceImpl
extends AbstractService {
    private static final Logger log = LoggerFactory.getLogger(RegisterDeviceServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private DeviceUpgradeHandle deviceUpgradeHandle;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    private static Long INIT_TIME = 30L;

    public P2cBaseResponse<RegisterDeviceResponse> execute(RegisterDeviceRequest registerDeviceRequest) {
        P2cBaseResponse p2CBaseResponse = new P2cBaseResponse();
        p2CBaseResponse.setCmd(registerDeviceRequest.getCmd() + "_resp");
        p2CBaseResponse.setMessageId(registerDeviceRequest.getMessageId());
        try {
            this.verifyParams(registerDeviceRequest);
        }
        catch (ResponseBodyException e) {
            p2CBaseResponse.setCode(CodeEnum.\u7f3a\u5931\u53c2\u6570.getCode());
            p2CBaseResponse.setMsg(CodeEnum.\u7f3a\u5931\u53c2\u6570.getMsg());
            return p2CBaseResponse;
        }
        String serialNumber = registerDeviceRequest.getDeviceNo();
        ObjectResponse parkDeviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
        ParkDevice parkDevice = (ParkDevice)parkDeviceResp.getData();
        if (parkDevice == null || parkDevice.getType() != 1) {
            p2CBaseResponse.setCode(CodeEnum.\u6210\u529f.getCode());
            p2CBaseResponse.setMsg(CodeEnum.\u6210\u529f.getMsg());
            RegisterDeviceResponse response = new RegisterDeviceResponse();
            response.setToken("TEMPTOKEN");
            response.setCloudTime(Long.valueOf(DateTools.unixTimestamp()));
            response.setParkCode("P999");
            response.setEnexType(Integer.valueOf(0));
            p2CBaseResponse.setData((Object)response);
            return p2CBaseResponse;
        }
        ObjectResponse parkInoutdeviceObjectResponse = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().longValue()));
        if (!ObjectResponse.isSuccess((Response)parkInoutdeviceObjectResponse)) {
            log.info("[\u8bbe\u5907\u6ce8\u518c\u63a5\u53e3] \u6839\u636echannelId[{}],\u672a\u67e5\u8be2\u5230\u901a\u9053\u4fe1\u606f,serialNumber[{}]", (Object)parkDevice.getChannelId(), (Object)serialNumber);
            p2CBaseResponse.setCode(CodeEnum.\u975e\u6cd5\u53c2\u6570.getCode());
            p2CBaseResponse.setMsg(CodeEnum.\u975e\u6cd5\u53c2\u6570.getMsg());
            return p2CBaseResponse;
        }
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)parkInoutdeviceObjectResponse.getData();
        Integer inandoutType = parkInoutdevice.getInandoutType();
        long parkId = parkDevice.getParkId();
        ObjectResponse byParkCode = this.parkService.findByParkId(Long.valueOf(parkId));
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        String parkCode = park.getParkCode();
        if (parkDevice.getEndUpdatetime() == null || (System.currentTimeMillis() - parkDevice.getEndUpdatetime().getTime()) / 1000L / 60L > INIT_TIME) {
            this.redisUtils.set("P2C:DEVICE:INIT:" + serialNumber, (Object)1, 60L);
        }
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        String token = null;
        if (deviceInfo != null && deviceInfo.getToken() != null) {
            token = deviceInfo.getToken();
            log.info("deviceInfo[{}]", (Object)deviceInfo);
            Integer protocolType = registerDeviceRequest.getSource();
            String protocolVer = registerDeviceRequest.getVersion();
            String productModel = registerDeviceRequest.getProductModel();
            String firmwareVersion = registerDeviceRequest.getFirmwareVersion();
            if (protocolVer.equals(parkDevice.getProtocolVer()) && protocolType.equals(parkDevice.getProtocolType()) && (productModel == null || productModel.equals(parkDevice.getProductModel())) && (firmwareVersion == null || firmwareVersion.equals(parkDevice.getFirmwareVersion()) && deviceInfo.getInandoutType().equals(inandoutType) && deviceInfo.getParkCode().equals(parkCode))) {
                log.info("[\u8bbe\u5907\u6ce8\u518c\u63a5\u53e3] \u4ece\u7f13\u5b58\u4e2d\u8fd4\u56deparkCode[{}], serialNumber[{}]", (Object)parkCode, (Object)serialNumber);
                RegisterDeviceResponse response = new RegisterDeviceResponse();
                response.setToken(token);
                response.setCloudTime(Long.valueOf(DateTools.unixTimestamp()));
                response.setParkCode(parkCode);
                response.setEnexType(inandoutType);
                p2CBaseResponse.setData((Object)response);
                p2CBaseResponse.setCode(CodeEnum.\u6210\u529f.getCode());
                p2CBaseResponse.setMsg(CodeEnum.\u6210\u529f.getMsg());
                return p2CBaseResponse;
            }
        }
        if (token == null) {
            token = UUIDTools.getUuid();
        }
        ParkConnectedDeviceVo parkConnectedDeviceVo = new ParkConnectedDeviceVo();
        parkConnectedDeviceVo.setDeviceNo(serialNumber);
        parkConnectedDeviceVo.setInandoutCode(parkInoutdevice.getInandoutCode());
        parkConnectedDeviceVo.setRegionId(parkInoutdevice.getRegionId());
        parkConnectedDeviceVo.setInandoutType(inandoutType);
        parkConnectedDeviceVo.setId(parkInoutdevice.getId());
        if (parkDevice.getIsDualcamera() != null && parkDevice.getIsDualcamera() == 1 && parkDevice.getIsMaster() != null && parkDevice.getIsMaster() == 0) {
            parkConnectedDeviceVo.setMaster(false);
        } else {
            parkConnectedDeviceVo.setMaster(true);
        }
        this.cacheHandle.addParkConnectList(parkCode, parkConnectedDeviceVo);
        TokenDeviceVo tdv = new TokenDeviceVo();
        tdv.setParkId(park.getId());
        tdv.setParkCode(parkCode);
        tdv.setDeviceNo(serialNumber);
        tdv.setMaster(parkConnectedDeviceVo.isMaster());
        tdv.setVersion(registerDeviceRequest.getVersion());
        tdv.setSource(registerDeviceRequest.getSource());
        tdv.setId(parkInoutdevice.getId());
        tdv.setInandoutName(parkInoutdevice.getInandoutName());
        tdv.setInandoutCode(parkInoutdevice.getInandoutCode());
        tdv.setRegionId(parkInoutdevice.getRegionId());
        tdv.setInandoutType(parkInoutdevice.getInandoutType());
        tdv.setToken(token);
        this.cacheHandle.cacheDeviceInfo(serialNumber, tdv);
        this.cacheHandle.setChannelSn(parkCode, parkInoutdevice.getInandoutCode(), serialNumber, parkConnectedDeviceVo.isMaster());
        this.propertyModify(registerDeviceRequest, serialNumber, parkDevice);
        RegisterDeviceResponse response = new RegisterDeviceResponse();
        response.setToken(token);
        response.setCloudTime(Long.valueOf(DateTools.unixTimestamp()));
        response.setParkCode(park.getParkCode());
        response.setEnexType(inandoutType);
        p2CBaseResponse.setData((Object)response);
        p2CBaseResponse.setCode(CodeEnum.\u6210\u529f.getCode());
        p2CBaseResponse.setMsg(CodeEnum.\u6210\u529f.getMsg());
        return p2CBaseResponse;
    }

    private void propertyModify(RegisterDeviceRequest registerDeviceRequest, String serialNumber, ParkDevice parkDevice) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            Integer protocolType = registerDeviceRequest.getSource();
            String protocolVer = registerDeviceRequest.getVersion();
            String productModel = registerDeviceRequest.getProductModel();
            String firmwareVersion = registerDeviceRequest.getFirmwareVersion();
            if (firmwareVersion != null) {
                this.deviceUpgradeHandle.versionModify(serialNumber, firmwareVersion);
            }
            if (!protocolVer.equals(parkDevice.getProtocolVer()) || !protocolType.equals(parkDevice.getProtocolType()) || productModel != null && !productModel.equals(parkDevice.getProductModel()) || firmwareVersion != null && !firmwareVersion.equals(parkDevice.getFirmwareVersion())) {
                parkDevice.setProtocolVer(protocolVer);
                parkDevice.setProtocolType(protocolType);
                parkDevice.setProductModel(productModel);
                parkDevice.setFirmwareVersion(firmwareVersion);
                this.parkDeviceService.updateDevice(parkDevice);
                log.info("[\u8bbe\u5907\u6ce8\u518c\u63a5\u53e3] \u66f4\u65b0\u7248\u672c\u53f7\u548c\u534f\u8bae\u7c7b\u578b\u5b8c\u6210, sn[{}], protocolType[{}], protocolVer[{}], productModel[{}], firmwareVersion[{}]", new Object[]{serialNumber, protocolType, protocolVer, productModel, firmwareVersion});
            }
        }));
    }
}

